/*
 * Decompiled with CFR 0.152.
 */
package net.redfox.tleveling.leveling;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.redfox.tleveling.TinkersLeveling;
import net.redfox.tleveling.leveling.ToolLevel;
import net.redfox.tleveling.util.MathHandler;
import slimeknights.tconstruct.library.tools.helper.TooltipUtil;

public class TooltipHandler {
    public static final TextColor RED = TextColor.m_131268_((String)"#FF5555");
    public static final TextColor ORANGE = TextColor.m_131268_((String)"#FFAA00");
    public static final TextColor YELLOW = TextColor.m_131268_((String)"#FFFF55");
    public static final TextColor GREEN = TextColor.m_131268_((String)"#55FF55");
    public static final TextColor BLUE = TextColor.m_131268_((String)"#5555FF");
    public static final TextColor DARK_AQUA = TextColor.m_131268_((String)"#00AAAA");

    public static Component getColorComponent(double a, int b) {
        double value = MathHandler.getUniformPercentage(a, b);
        String message = String.valueOf(value);
        if (value >= 0.0 && value < 25.0) {
            return Component.m_237113_((String)("(" + message + "%)")).m_130938_(s -> s.m_131148_(RED));
        }
        if (value >= 25.0 && value < 50.0) {
            return Component.m_237113_((String)("(" + message + "%)")).m_130938_(s -> s.m_131148_(ORANGE));
        }
        if (value >= 50.0 && value < 75.0) {
            return Component.m_237113_((String)("(" + message + "%)")).m_130938_(s -> s.m_131148_(YELLOW));
        }
        if (value >= 75.0 && value < 100.0) {
            return Component.m_237113_((String)("(" + message + "%)")).m_130938_(s -> s.m_131148_(GREEN));
        }
        return Component.m_237113_((String)("(" + message + "%)"));
    }

    public static void appendAltTooltip(List<Component> tooltip) {
        int index = tooltip.indexOf(TooltipUtil.TOOLTIP_HOLD_CTRL);
        if (index != -1) {
            index = tooltip.indexOf(TooltipUtil.TOOLTIP_HOLD_SHIFT);
        }
        if (index != -1) {
            tooltip.add(index + 2, (Component)Component.m_237110_((String)"tooltip.tleveling.hold_alt", (Object[])new Object[]{Component.m_237115_((String)"key.tleveling.alt").m_130938_(s -> s.m_131148_(TextColor.m_131268_((String)"#FF55FF"))).m_130938_(s -> s.m_131155_(Boolean.valueOf(true)))}));
        } else {
            TinkersLeveling.warnLog("The tool didn't have a shift or ctrl! Could not place the tooltip.");
        }
    }

    public static void handleExpTooltip(ItemTooltipEvent event, Component itemName, ItemStack stack) {
        event.getToolTip().clear();
        event.getToolTip().add(itemName);
        double currentExp = stack.m_41784_().m_128459_("toolExp");
        ToolLevel level = ToolLevel.TOOL_LEVELS[stack.m_41784_().m_128451_("toolLevel")];
        int requiredExp = MathHandler.getRequiredExp(level.getLevel());
        event.getToolTip().add(Component.m_237110_((String)"tooltip.tleveling.tool_level", (Object[])new Object[]{level.getName(), Component.m_237113_((String)("(" + level.getLevel() + ")")).m_130938_(s -> s.m_131148_(TextColor.m_131268_((String)"#555555")))}));
        event.getToolTip().add(Component.m_237110_((String)"tooltip.tleveling.tool_exp", (Object[])new Object[]{Component.m_237113_((String)(MathHandler.getUniformLongDecimal(MathHandler.getUniformDecimal(currentExp)) + "/" + MathHandler.getUniformLongDecimal(requiredExp))), TooltipHandler.getColorComponent(currentExp, requiredExp)}));
    }
}

