/*
 * Decompiled with CFR 0.152.
 */
package com.github.talrey.createdeco.api;

import com.github.talrey.createdeco.BlockRegistry;
import com.github.talrey.createdeco.BlockStateGenerator;
import com.simibubi.create.content.decoration.palettes.AllPaletteStoneTypes;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import com.tterrag.registrate.util.DataIngredient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class Bricks {
    public static List<String> TYPES = Arrays.asList("", "short", "tiled", "long", "corner", "cracked", "mossy");
    private static List<String> CAPITALS = Arrays.asList("", "Short ", "Tiled ", "Long ", "Corner ", "Cracked ", "Mossy ");
    public static HashMap<String, AllPaletteStoneTypes> BRICK_STONES = new HashMap<String, AllPaletteStoneTypes>(){
        {
            this.put("blue", AllPaletteStoneTypes.ASURINE);
            this.put("dean", AllPaletteStoneTypes.OCHRUM);
            this.put("dusk", AllPaletteStoneTypes.SCORCHIA);
            this.put("pearl", AllPaletteStoneTypes.LIMESTONE);
            this.put("scarlet", AllPaletteStoneTypes.CRIMSITE);
            this.put("verdant", AllPaletteStoneTypes.VERIDIUM);
            this.put("umber", AllPaletteStoneTypes.SCORIA);
        }
    };

    public static ArrayList<BlockBuilder<Block, ?>> buildBlock(CreateRegistrate reg, String color) {
        ArrayList ret = new ArrayList();
        for (String prefix : TYPES) {
            String name = (String)(prefix.isEmpty() ? "" : prefix + "_") + color + "_bricks";
            if (color.contains("red") && prefix.isEmpty()) continue;
            String finalName = name;
            ret.add(reg.block(name, Block::new).initialProperties(() -> Blocks.f_50076_).properties(props -> props.m_60913_(2.0f, 6.0f).m_60999_().m_60918_(SoundType.f_56742_)).blockstate((ctx, prov) -> BlockStateGenerator.brick(ctx, prov, color)).tag(new TagKey[]{BlockTags.f_144282_}).lang(CAPITALS.get(TYPES.indexOf(prefix)) + color.substring(0, 1).toUpperCase() + color.substring(1) + " Bricks").defaultLoot().recipe((ctx, prov) -> {
                if (prefix.isEmpty()) {
                    Bricks.recipeCrafting(color, ctx, prov);
                }
                if (prefix.equals("mossy")) {
                    Bricks.recipeCraftingMossy(color, ctx, prov);
                }
                if (prefix.equals("cracked")) {
                    Bricks.recipeSmeltingCracked(color, ctx, prov);
                }
                Bricks.recipeStonecuttingBrick(finalName, color, prefix, ctx, prov);
            }).simpleItem());
        }
        return ret;
    }

    public static ArrayList<BlockBuilder<StairBlock, ?>> buildStair(CreateRegistrate reg, String color) {
        ArrayList ret = new ArrayList();
        for (String prefix : TYPES) {
            if (color.isEmpty() && prefix.isEmpty()) continue;
            String name = (String)(prefix.isEmpty() ? "" : prefix + "_") + color + "_brick_stairs";
            if (color.contains("red") && prefix.isEmpty()) continue;
            String finalName = name;
            ret.add((BlockBuilder)reg.block(name, p -> new StairBlock(Blocks.f_50193_.m_49966_(), p)).initialProperties(() -> Blocks.f_50076_).properties(props -> props.m_60913_(2.0f, 6.0f).m_60999_().m_60918_(SoundType.f_56742_)).blockstate((ctx, prov) -> BlockStateGenerator.brickStair((DataGenContext<Block, StairBlock>)ctx, prov, color)).tag(new TagKey[]{BlockTags.f_144282_}).lang(CAPITALS.get(TYPES.indexOf(prefix)) + color.substring(0, 1).toUpperCase() + color.substring(1) + " Brick Stairs").defaultLoot().recipe((ctx, prov) -> {
                prov.stairs(DataIngredient.items((ItemLike)((ItemLike)BlockRegistry.BRICKS.get(BlockRegistry.fromName(color)).get((String)(prefix.isEmpty() ? "" : prefix + "_") + color + "_bricks")), (ItemLike[])new ItemLike[0]), RecipeCategory.BUILDING_BLOCKS, (Supplier)ctx, "createdeco", true);
                Bricks.recipeStonecuttingStair(finalName, color, prefix, ctx, prov);
            }).item().tag(new TagKey[]{ItemTags.f_13138_}).build());
        }
        return ret;
    }

    public static ArrayList<BlockBuilder<SlabBlock, ?>> buildSlab(CreateRegistrate reg, String color) {
        ArrayList ret = new ArrayList();
        for (String prefix : TYPES) {
            if (color.isEmpty() && prefix.isEmpty()) continue;
            String name = (String)(prefix.isEmpty() ? "" : prefix + "_") + color + "_brick_slab";
            if (color.contains("red") && prefix.isEmpty()) continue;
            String finalName = name;
            ret.add(reg.block(name, SlabBlock::new).initialProperties(() -> Blocks.f_50076_).properties(props -> props.m_60913_(2.0f, 6.0f).m_60999_().m_60918_(SoundType.f_56742_)).blockstate((ctx, prov) -> BlockStateGenerator.brickSlab((DataGenContext<Block, SlabBlock>)ctx, prov, color)).tag(new TagKey[]{BlockTags.f_144282_}).lang(CAPITALS.get(TYPES.indexOf(prefix)) + color.substring(0, 1).toUpperCase() + color.substring(1) + " Brick Slab").loot((table, block) -> {
                LootTable.Builder builder = LootTable.m_79147_();
                LootPool.Builder pool = LootPool.m_79043_();
                pool.m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)2.0f)).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)BlockStateProperties.f_61397_, (Comparable)SlabType.DOUBLE)))));
                table.m_247577_((Block)block, builder.m_79161_(pool));
            }).recipe((ctx, prov) -> {
                prov.slab(DataIngredient.items((ItemLike)((ItemLike)BlockRegistry.BRICKS.get(BlockRegistry.fromName(color)).get((String)(prefix.isEmpty() ? "" : prefix + "_") + color + "_bricks")), (ItemLike[])new ItemLike[0]), RecipeCategory.BUILDING_BLOCKS, (Supplier)ctx, "createdeco", true);
                Bricks.recipeStonecuttingSlab(finalName, color, prefix, ctx, prov);
            }).simpleItem());
        }
        return ret;
    }

    public static ArrayList<BlockBuilder<WallBlock, ?>> buildWall(CreateRegistrate reg, String color) {
        ArrayList ret = new ArrayList();
        for (String prefix : TYPES) {
            if (color.isEmpty() && prefix.isEmpty()) continue;
            String name = (String)(prefix.isEmpty() ? "" : prefix + "_") + color + "_brick_wall";
            if (color.contains("red") && prefix.isEmpty()) continue;
            String finalName = name;
            ret.add((BlockBuilder)reg.block(name, WallBlock::new).initialProperties(() -> Blocks.f_50076_).properties(props -> props.m_60913_(2.0f, 6.0f).m_60999_().m_60918_(SoundType.f_56742_)).blockstate((ctx, prov) -> BlockStateGenerator.brickWall((DataGenContext<Block, WallBlock>)ctx, prov, color)).tag(new TagKey[]{BlockTags.f_144282_}).tag(new TagKey[]{BlockTags.f_13032_}).lang(CAPITALS.get(TYPES.indexOf(prefix)) + color.substring(0, 1).toUpperCase() + color.substring(1) + " Brick Wall").defaultLoot().recipe((ctx, prov) -> {
                prov.wall(DataIngredient.items((ItemLike)((ItemLike)BlockRegistry.BRICKS.get(BlockRegistry.fromName(color)).get((String)(prefix.isEmpty() ? "" : prefix + "_") + color + "_bricks")), (ItemLike[])new ItemLike[0]), RecipeCategory.BUILDING_BLOCKS, (Supplier)ctx);
                Bricks.recipeStonecuttingWall(finalName, color, prefix, ctx, prov);
            }).item().tag(new TagKey[]{ItemTags.f_13140_}).model((ctx, prov) -> BlockStateGenerator.brickWallItem((DataGenContext<Item, BlockItem>)ctx, prov, color)).build());
        }
        return ret;
    }

    public static <T extends Block> void recipeCrafting(String color, DataGenContext<Block, T> ctx, RegistrateRecipeProvider prov) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ctx.get()), (int)4).m_126130_("bbb").m_126130_("bab").m_126130_("bbb").m_126127_(Character.valueOf('b'), (ItemLike)Items.f_42460_).m_126127_(Character.valueOf('a'), (ItemLike)BRICK_STONES.get(color).getBaseBlock().get()).m_126132_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)BRICK_STONES.get(color).getBaseBlock().get()})).m_176498_((Consumer)prov);
    }

    public static <T extends Block> void recipeCraftingMossy(String color, DataGenContext<Block, T> ctx, RegistrateRecipeProvider prov) {
        String original = color + "_bricks";
        DyeColor dye = BlockRegistry.fromName(color);
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ctx.get())).m_126184_((Ingredient)DataIngredient.items((ItemLike)(dye == null ? Blocks.f_50076_ : (ItemLike)BlockRegistry.BRICKS.get(dye).get(original)), (ItemLike[])new ItemLike[0])).m_126209_((ItemLike)Blocks.f_50191_).m_126132_("hasitem", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{dye == null ? Blocks.f_50076_ : (ItemLike)BlockRegistry.BRICKS.get(dye).get(original)})).m_176500_((Consumer)prov, ctx.getName() + "_from_vine");
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ctx.get())).m_126184_((Ingredient)DataIngredient.items((ItemLike)(dye == null ? Blocks.f_50076_ : (ItemLike)BlockRegistry.BRICKS.get(dye).get(original)), (ItemLike[])new ItemLike[0])).m_126209_((ItemLike)Blocks.f_152544_).m_126132_("hasitem", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{dye == null ? Blocks.f_50076_ : (ItemLike)BlockRegistry.BRICKS.get(dye).get(original)})).m_176500_((Consumer)prov, ctx.getName() + "_from_moss_block");
    }

    public static <T extends Block> void recipeSmeltingCracked(String color, DataGenContext<Block, T> ctx, RegistrateRecipeProvider prov) {
        String original = color + "_bricks";
        DyeColor dye = BlockRegistry.fromName(color);
        prov.smeltingAndBlasting(DataIngredient.items((ItemLike)(dye == null ? Blocks.f_50076_ : (ItemLike)BlockRegistry.BRICKS.get(dye).get(original)), (ItemLike[])new ItemLike[0]), RecipeCategory.BUILDING_BLOCKS, ctx, 0.1f);
    }

    public static <T extends Block> void recipeStonecuttingBrick(String original, String color, String prefix, DataGenContext<Block, T> ctx, RegistrateRecipeProvider prov) {
        Bricks.recipeStonecutting(original, color, prefix, 1, 0, ctx, prov);
    }

    public static <T extends Block> void recipeStonecuttingStair(String original, String color, String prefix, DataGenContext<Block, T> ctx, RegistrateRecipeProvider prov) {
        Bricks.recipeStonecutting(original, color, prefix, 1, 1, ctx, prov);
    }

    public static <T extends Block> void recipeStonecuttingSlab(String original, String color, String prefix, DataGenContext<Block, T> ctx, RegistrateRecipeProvider prov) {
        Bricks.recipeStonecutting(original, color, prefix, 2, 2, ctx, prov);
    }

    public static <T extends Block> void recipeStonecuttingWall(String original, String color, String prefix, DataGenContext<Block, T> ctx, RegistrateRecipeProvider prov) {
        Bricks.recipeStonecutting(original, color, prefix, 1, 3, ctx, prov);
    }

    private static <T extends Block> void recipeStonecuttingMossy(String original, String color, String prefix, int amount, int type, DataGenContext<Block, T> ctx, RegistrateRecipeProvider prov) {
    }

    private static <T extends Block> void recipeStonecuttingCracked(String original, String color, String prefix, int amount, int type, DataGenContext<Block, T> ctx, RegistrateRecipeProvider prov) {
    }

    private static <T extends Block> void recipeStonecutting(String original, String color, String prefix, int amount, int type, DataGenContext<Block, T> ctx, RegistrateRecipeProvider prov) {
        DyeColor dye = BlockRegistry.fromName(color);
        if (prefix.equals("mossy")) {
            Bricks.recipeStonecuttingMossy("mossy_" + color + "_bricks", color, prefix, amount, type, ctx, prov);
            return;
        }
        if (prefix.equals("cracked")) {
            Bricks.recipeStonecuttingCracked("cracked_" + color + "_bricks", color, prefix, amount, type, ctx, prov);
            return;
        }
        for (String pref : TYPES) {
            Object fix = pref.isEmpty() ? "" : pref + "_";
            String otherName = (String)fix + color + "_bricks";
            if (pref.equals(prefix) || pref.equals("mossy") || pref.equals("cracked")) continue;
            if (otherName.equals("red_bricks")) {
                prov.stonecutting(DataIngredient.items((ItemLike)Blocks.f_50076_, (ItemLike[])new Block[0]), RecipeCategory.BUILDING_BLOCKS, ctx, amount);
                continue;
            }
            prov.stonecutting(DataIngredient.items((ItemLike)((ItemLike)BlockRegistry.BRICKS.get(dye).get(otherName)), (ItemLike[])new ItemLike[0]), RecipeCategory.BUILDING_BLOCKS, ctx, amount);
            if (type == 1) {
                String stairName = (String)fix + color + "_brick_stairs";
                prov.stonecutting(DataIngredient.items((ItemLike)((ItemLike)BlockRegistry.STAIRS.get(dye).get(stairName)), (ItemLike[])new ItemLike[0]), RecipeCategory.BUILDING_BLOCKS, ctx, amount);
            }
            if (type == 2) {
                String slabName = (String)fix + color + "_brick_slab";
                prov.stonecutting(DataIngredient.items((ItemLike)((ItemLike)BlockRegistry.SLABS.get(dye).get(slabName)), (ItemLike[])new ItemLike[0]), RecipeCategory.BUILDING_BLOCKS, ctx, 1);
            }
            if (type != 3) continue;
            String wallName = (String)fix + color + "_brick_wall";
            prov.stonecutting(DataIngredient.items((ItemLike)((ItemLike)BlockRegistry.WALLS.get(dye).get(wallName)), (ItemLike[])new ItemLike[0]), RecipeCategory.BUILDING_BLOCKS, ctx, 1);
        }
    }
}

