/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.authlib.yggdrasil;

import com.mojang.authlib.Agent;
import com.mojang.authlib.Environment;
import com.mojang.authlib.EnvironmentParser;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.HttpAuthenticationService;
import com.mojang.authlib.UserAuthentication;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import com.mojang.authlib.exceptions.InsufficientPrivilegesException;
import com.mojang.authlib.exceptions.InvalidCredentialsException;
import com.mojang.authlib.exceptions.MinecraftClientException;
import com.mojang.authlib.exceptions.UserBannedException;
import com.mojang.authlib.exceptions.UserMigratedException;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.minecraft.UserApiService;
import com.mojang.authlib.minecraft.client.ObjectMapper;
import com.mojang.authlib.yggdrasil.ServicesKeySet;
import com.mojang.authlib.yggdrasil.YggdrasilEnvironment;
import com.mojang.authlib.yggdrasil.YggdrasilGameProfileRepository;
import com.mojang.authlib.yggdrasil.YggdrasilMinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilServicesKeyInfo;
import com.mojang.authlib.yggdrasil.YggdrasilUserApiService;
import com.mojang.authlib.yggdrasil.YggdrasilUserAuthentication;
import com.mojang.authlib.yggdrasil.response.Response;
import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YggdrasilAuthenticationService
extends HttpAuthenticationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(YggdrasilAuthenticationService.class);
    @Nullable
    private final String clientToken;
    private final ObjectMapper objectMapper = ObjectMapper.create();
    private final Environment environment;
    private final ServicesKeySet servicesKeySet;

    public YggdrasilAuthenticationService(Proxy proxy) {
        this(proxy, YggdrasilAuthenticationService.determineEnvironment());
    }

    public YggdrasilAuthenticationService(Proxy proxy, Environment environment) {
        this(proxy, null, environment);
    }

    public YggdrasilAuthenticationService(Proxy proxy, @Nullable String clientToken) {
        this(proxy, clientToken, YggdrasilAuthenticationService.determineEnvironment());
    }

    public YggdrasilAuthenticationService(Proxy proxy, @Nullable String clientToken, Environment environment) {
        super(proxy);
        this.clientToken = clientToken;
        this.environment = environment;
        LOGGER.info("Environment: " + environment.asString());
        URL publicKeySetUrl = HttpAuthenticationService.constantURL(environment.getServicesHost() + "/publickeys");
        this.servicesKeySet = YggdrasilServicesKeyInfo.get(publicKeySetUrl, this);
    }

    private static Environment determineEnvironment() {
        return EnvironmentParser.getEnvironmentFromProperties().orElse(YggdrasilEnvironment.PROD.getEnvironment());
    }

    @Override
    public UserAuthentication createUserAuthentication(Agent agent) {
        if (this.clientToken == null) {
            throw new IllegalStateException("Missing client token");
        }
        return new YggdrasilUserAuthentication(this, this.clientToken, agent, this.environment);
    }

    @Override
    public MinecraftSessionService createMinecraftSessionService() {
        return new YggdrasilMinecraftSessionService(this, this.environment);
    }

    @Override
    public GameProfileRepository createProfileRepository() {
        return new YggdrasilGameProfileRepository(this, this.environment);
    }

    public ServicesKeySet getServicesKeySet() {
        return this.servicesKeySet;
    }

    protected <T extends Response> T makeRequest(URL url, Object input, Class<T> classOfT) throws AuthenticationException {
        return this.makeRequest(url, input, classOfT, null);
    }

    protected <T extends Response> T makeRequest(URL url, Object input, Class<T> classOfT, @Nullable String authentication) throws AuthenticationException {
        try {
            String jsonResult = input == null ? this.performGetRequest(url, authentication) : this.performPostRequest(url, this.objectMapper.writeValueAsString(input), "application/json");
            Response result = (Response)this.objectMapper.readValue(jsonResult, classOfT);
            if (result == null) {
                return null;
            }
            if (StringUtils.isNotBlank((CharSequence)result.getError())) {
                if ("UserMigratedException".equals(result.getCause())) {
                    throw new UserMigratedException(result.getErrorMessage());
                }
                if ("ForbiddenOperationException".equals(result.getError())) {
                    throw new InvalidCredentialsException(result.getErrorMessage());
                }
                if ("InsufficientPrivilegesException".equals(result.getError())) {
                    throw new InsufficientPrivilegesException(result.getErrorMessage());
                }
                if ("multiplayer.access.banned".equals(result.getError())) {
                    throw new UserBannedException();
                }
                throw new AuthenticationException(result.getErrorMessage());
            }
            return (T)result;
        }
        catch (MinecraftClientException | IOException | IllegalStateException e) {
            throw new AuthenticationUnavailableException("Cannot contact authentication server", e);
        }
    }

    public UserApiService createUserApiService(String accessToken) throws AuthenticationException {
        return new YggdrasilUserApiService(accessToken, this.getProxy(), this.environment);
    }
}

