/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementList;
import net.minecraft.advancements.TreeNodePosition;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.storage.loot.LootDataManager;
import net.minecraftforge.common.crafting.conditions.ICondition;
import org.slf4j.Logger;

public class ServerAdvancementManager
extends SimpleJsonResourceReloadListener {
    private static final Logger f_136021_ = LogUtils.getLogger();
    private static final Gson f_136022_ = new GsonBuilder().create();
    private AdvancementList f_136023_ = new AdvancementList();
    private final LootDataManager f_278379_;
    private final ICondition.IContext context;

    @Deprecated
    public ServerAdvancementManager(LootDataManager p_279237_) {
        this(p_279237_, ICondition.IContext.EMPTY);
    }

    public ServerAdvancementManager(LootDataManager p_279237_, ICondition.IContext context) {
        super(f_136022_, "advancements");
        this.f_278379_ = p_279237_;
        this.context = context;
    }

    protected void m_5787_(Map<ResourceLocation, JsonElement> p_136034_, ResourceManager p_136035_, ProfilerFiller p_136036_) {
        HashMap map = Maps.newHashMap();
        p_136034_.forEach((p_278903_, p_278904_) -> {
            try {
                JsonObject jsonobject = GsonHelper.m_13918_((JsonElement)p_278904_, (String)"advancement");
                Advancement.Builder advancement$builder = Advancement.Builder.fromJson(jsonobject, new DeserializationContext(p_278903_, this.f_278379_), this.context);
                if (advancement$builder == null) {
                    f_136021_.debug("Skipping loading advancement {} as its conditions were not met", p_278903_);
                    return;
                }
                map.put(p_278903_, advancement$builder);
            }
            catch (Exception exception) {
                f_136021_.error("Parsing error loading custom advancement {}: {}", p_278903_, (Object)exception.getMessage());
            }
        });
        AdvancementList advancementlist = new AdvancementList();
        advancementlist.m_139333_((Map)map);
        for (Advancement advancement : advancementlist.m_139343_()) {
            if (advancement.m_138320_() == null) continue;
            TreeNodePosition.m_16587_((Advancement)advancement);
        }
        this.f_136023_ = advancementlist;
    }

    @Nullable
    public Advancement m_136041_(ResourceLocation p_136042_) {
        return this.f_136023_.m_139337_(p_136042_);
    }

    public Collection<Advancement> m_136028_() {
        return this.f_136023_.m_139344_();
    }
}

