/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.cable_facades.content.recipes;

import com.portingdeadmods.cable_facades.content.items.FacadeItem;
import com.portingdeadmods.cable_facades.registries.CFRecipes;
import java.util.Optional;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import org.jetbrains.annotations.NotNull;

public class FacadeCraftingRecipe
extends CustomRecipe {
    public FacadeCraftingRecipe(ResourceLocation p_252125_, CraftingBookCategory p_249010_) {
        super(p_252125_, p_249010_);
    }

    public boolean matches(CraftingContainer craftingContainer, Level level) {
        CompoundTag tag;
        boolean hasBlock = false;
        boolean hasFacade = false;
        ItemStack facadeStack = null;
        for (int i = 0; i < craftingContainer.m_6643_(); ++i) {
            ItemStack stack = craftingContainer.m_8020_(i);
            Item item = stack.m_41720_();
            if (item instanceof FacadeItem) {
                if (!hasFacade) {
                    facadeStack = stack.m_41777_();
                    hasFacade = true;
                    continue;
                }
                return false;
            }
            if (item instanceof BlockItem) {
                if (!hasBlock) {
                    hasBlock = true;
                    continue;
                }
                return false;
            }
            if (stack.m_41619_()) continue;
            return false;
        }
        if (hasFacade && !hasBlock && (tag = facadeStack.m_41783_()) != null && tag.m_128441_("facade_block")) {
            return true;
        }
        return hasFacade && hasBlock;
    }

    public ItemStack assemble(CraftingContainer craftingContainer, RegistryAccess registryAccess) {
        Block facadeBlock = null;
        ItemStack itemStack = ItemStack.f_41583_;
        ItemStack originalFacadeStack = ItemStack.f_41583_;
        ItemStack facadeStack = ItemStack.f_41583_;
        for (int i = 0; i < craftingContainer.m_6643_(); ++i) {
            ItemStack item = craftingContainer.m_8020_(i);
            Item item2 = item.m_41720_();
            if (item2 instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item2;
                facadeBlock = blockItem.m_40614_();
                if (facadeBlock.m_49966_().m_60799_() != RenderShape.ENTITYBLOCK_ANIMATED) continue;
                return ItemStack.f_41583_;
            }
            if (!(item.m_41720_() instanceof FacadeItem)) continue;
            facadeStack = item.m_41777_();
            originalFacadeStack = item;
        }
        if (!facadeStack.m_41619_() && facadeBlock != null) {
            ItemStack stack = facadeStack.m_41720_().m_7968_();
            stack.m_41784_().m_128359_("facade_block", BuiltInRegistries.f_256975_.m_7981_(facadeBlock).toString());
            return stack;
        }
        if (!facadeStack.m_41619_()) {
            Optional optionalBlock;
            Optional<Object> optional = optionalBlock = facadeStack.m_41783_().m_128441_("facade_block") ? Optional.ofNullable((Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(facadeStack.m_41783_().m_128461_("facade_block")))) : Optional.empty();
            if (optionalBlock.isPresent()) {
                originalFacadeStack.m_41783_().m_128379_("has_facade_remainder", true);
                return ((Block)optionalBlock.get()).m_5456_().m_7968_();
            }
        }
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int i, int i1) {
        return true;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)CFRecipes.FACADE.get();
    }
}

