/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.cable_facades.data.helper;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.portingdeadmods.cable_facades.utils.CodecUtils;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.NotImplementedException;

public class ChunkFacadeMap {
    public static final Codec<ChunkFacadeMap> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.unboundedMap((Codec)Codec.STRING, CodecUtils.BLOCKSTATE_CODEC).fieldOf("chunk_map").forGetter(ChunkFacadeMap::chunkMapToString)).apply((Applicative)builder, ChunkFacadeMap::chunkMapFromString));
    public static final Codec<ChunkFacadeMap> MIGRATION_CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.unboundedMap((Codec)Codec.STRING, CodecUtils.BLOCK_CODEC).fieldOf("chunk_map").forGetter(ChunkFacadeMap::chunkMapToOldString)).apply((Applicative)builder, ChunkFacadeMap::chunkMapFromOldString));
    private final Map<BlockPos, BlockState> chunkMap;

    public ChunkFacadeMap() {
        this.chunkMap = new HashMap<BlockPos, BlockState>();
    }

    public ChunkFacadeMap(Map<BlockPos, BlockState> chunkMap) {
        this.chunkMap = chunkMap;
    }

    public Map<BlockPos, BlockState> getChunkMap() {
        return this.chunkMap;
    }

    private static ChunkFacadeMap chunkMapFromString(Map<String, BlockState> chunkFacade) {
        return new ChunkFacadeMap(chunkFacade.entrySet().stream().map(entry -> new AbstractMap.SimpleEntry<BlockPos, BlockState>(BlockPos.m_122022_((long)Long.parseLong((String)entry.getKey())), (BlockState)entry.getValue())).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue)));
    }

    private static ChunkFacadeMap chunkMapFromOldString(Map<String, Block> chunkFacade) {
        return new ChunkFacadeMap(chunkFacade.entrySet().stream().map(entry -> new AbstractMap.SimpleEntry<BlockPos, BlockState>(BlockPos.m_122022_((long)Long.parseLong((String)entry.getKey())), ((Block)entry.getValue()).m_49966_())).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue)));
    }

    private Map<String, BlockState> chunkMapToString() {
        return this.getChunkMap().entrySet().stream().map(entry -> new AbstractMap.SimpleEntry<String, BlockState>(String.valueOf(((BlockPos)entry.getKey()).m_121878_()), (BlockState)entry.getValue())).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    }

    private Map<String, Block> chunkMapToOldString() {
        throw new NotImplementedException("This method shouldn't be called!");
    }

    public String toString() {
        return "ChunkFacadeMap{chunkMap=" + String.valueOf(this.chunkMap) + "}";
    }
}

