/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.cable_facades.utils;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.portingdeadmods.cable_facades.CFMain;
import com.portingdeadmods.cable_facades.utils.CodecUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.state.BlockState;

public class NetworkingUtils {
    public static void writeBlockState(FriendlyByteBuf buf, BlockState blockState) {
        Optional tag = CodecUtils.BLOCKSTATE_CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)blockState).result();
        if (tag.isPresent()) {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128365_("blockState", (Tag)tag.get());
            buf.m_130079_(compoundTag);
        }
    }

    public static Map<BlockPos, BlockState> getFacades(FriendlyByteBuf buf) {
        int size = buf.readInt();
        HashMap<BlockPos, BlockState> facades = new HashMap<BlockPos, BlockState>(size);
        for (int i = 0; i < size; ++i) {
            BlockPos pos = buf.m_130135_();
            BlockState blockState = NetworkingUtils.readBlockState(buf);
            if (blockState == null) continue;
            facades.put(pos, blockState);
        }
        return facades;
    }

    public static BlockState readBlockState(FriendlyByteBuf buf) {
        Tag tag = buf.m_130260_().m_128423_("blockState");
        DataResult dataResult = CodecUtils.BLOCKSTATE_CODEC.decode((DynamicOps)NbtOps.f_128958_, (Object)tag);
        Optional optionalBlockState = dataResult.result();
        if (optionalBlockState.isPresent()) {
            return (BlockState)((Pair)optionalBlockState.get()).getFirst();
        }
        CFMain.LOGGER.error("Failed to decode blockstate from bytebuf: {}", (Object)((DataResult.PartialResult)dataResult.error().get()).message());
        return null;
    }
}

