/*
 * Decompiled with CFR 0.152.
 */
package mcjty.incontrol.setup;

import mcjty.incontrol.ForgeEventHandlers;
import mcjty.incontrol.areas.AreaParser;
import mcjty.incontrol.compat.EnigmaSupport;
import mcjty.incontrol.compat.LostCitySupport;
import mcjty.incontrol.events.EventsParser;
import mcjty.incontrol.rules.RulesManager;
import mcjty.incontrol.rules.support.RuleCache;
import mcjty.incontrol.spawner.SpawnerParser;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModSetup {
    public static boolean lostcities = false;
    public static boolean gamestages = false;
    public static boolean sereneSeasons = false;
    public static boolean baubles = false;
    public static boolean enigma = false;
    private Logger logger;
    public RuleCache cache = new RuleCache();
    public static final TagKey<Block> CAVE_BLOCK = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("incontrol", "cave_block"));

    public void init() {
        this.logger = LogManager.getLogger((String)"incontrol");
        this.setupModCompat();
        MinecraftForge.EVENT_BUS.register((Object)new ForgeEventHandlers());
        RulesManager.setRulePath(FMLPaths.CONFIGDIR.get());
        SpawnerParser.setRulePath(FMLPaths.CONFIGDIR.get());
        EventsParser.setRulePath(FMLPaths.CONFIGDIR.get());
        AreaParser.setRulePath(FMLPaths.CONFIGDIR.get());
    }

    public Logger getLogger() {
        return this.logger;
    }

    private void setupModCompat() {
        lostcities = ModList.get().isLoaded("lostcities");
        gamestages = ModList.get().isLoaded("gamestages");
        sereneSeasons = ModList.get().isLoaded("sereneseasons");
        baubles = ModList.get().isLoaded("baubles");
        enigma = ModList.get().isLoaded("enigma");
        if (lostcities) {
            LostCitySupport.register();
            this.logger.log(Level.INFO, "Enabling support for Lost Cities");
        }
        if (gamestages) {
            this.logger.log(Level.INFO, "Enabling support for Game Stages");
        }
        if (sereneSeasons) {
            this.logger.log(Level.INFO, "Enabling support for Serene Seasons");
        }
        if (baubles) {
            this.logger.log(Level.INFO, "Enabling support for Baubles");
        }
        if (enigma) {
            EnigmaSupport.register();
            this.logger.log(Level.INFO, "Enabling support for EnigmaScript");
        }
    }
}

