/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.network.message;

import com.mrcrayfish.framework.api.network.MessageContext;
import com.mrcrayfish.framework.api.network.message.PlayMessage;
import com.mrcrayfish.furniture.refurbished.computer.app.PaddleBall;
import com.mrcrayfish.furniture.refurbished.network.play.ClientPlayHandler;
import com.mrcrayfish.furniture.refurbished.network.play.ServerPlayHandler;
import net.minecraft.network.FriendlyByteBuf;

public class MessagePaddleBall {

    public static class Event
    extends PlayMessage<Event> {
        private byte data;

        public Event() {
        }

        public Event(byte event) {
            this.data = event;
        }

        public void encode(Event message, FriendlyByteBuf buffer) {
            buffer.writeByte((int)message.data);
        }

        public Event decode(FriendlyByteBuf buffer) {
            byte event = buffer.readByte();
            return new Event(event);
        }

        public void handle(Event message, MessageContext context) {
            context.execute(() -> ClientPlayHandler.handleMessagePaddleBallEvent(message));
            context.setHandled(true);
        }

        public byte getEvent() {
            return this.data;
        }
    }

    public static class OpponentName
    extends PlayMessage<OpponentName> {
        private String name;

        public OpponentName() {
        }

        public OpponentName(String name) {
            this.name = name;
        }

        public void encode(OpponentName message, FriendlyByteBuf buffer) {
            buffer.m_130070_(message.name);
        }

        public OpponentName decode(FriendlyByteBuf buffer) {
            String name = buffer.m_130277_();
            return new OpponentName(name);
        }

        public void handle(OpponentName message, MessageContext context) {
            context.execute(() -> ClientPlayHandler.handleMessagePaddleBallOpponentName(message));
            context.setHandled(true);
        }

        public String getName() {
            return this.name;
        }
    }

    public static class Action
    extends PlayMessage<Action> {
        private PaddleBall.Action action;
        private byte data;

        public Action() {
        }

        public Action(PaddleBall.Action action, byte data) {
            this.action = action;
            this.data = data;
        }

        public void encode(Action message, FriendlyByteBuf buffer) {
            buffer.m_130068_((Enum)message.action);
            buffer.writeByte((int)message.data);
        }

        public Action decode(FriendlyByteBuf buffer) {
            PaddleBall.Action action = (PaddleBall.Action)buffer.m_130066_(PaddleBall.Action.class);
            byte data = buffer.readByte();
            return new Action(action, data);
        }

        public void handle(Action message, MessageContext context) {
            context.execute(() -> ServerPlayHandler.handleMessageTennisGame(message, context.getPlayer()));
            context.setHandled(true);
        }

        public PaddleBall.Action getMode() {
            return this.action;
        }

        public byte getData() {
            return this.data;
        }
    }

    public static class BallUpdate
    extends PlayMessage<BallUpdate> {
        private float ballX;
        private float ballY;
        private float velocityX;
        private float velocityY;

        public BallUpdate() {
        }

        public BallUpdate(float ballX, float ballY, float velocityX, float velocityY) {
            this.ballX = ballX;
            this.ballY = ballY;
            this.velocityX = velocityX;
            this.velocityY = velocityY;
        }

        public void encode(BallUpdate message, FriendlyByteBuf buffer) {
            buffer.writeFloat(message.ballX);
            buffer.writeFloat(message.ballY);
            buffer.writeFloat(message.velocityX);
            buffer.writeFloat(message.velocityY);
        }

        public BallUpdate decode(FriendlyByteBuf buffer) {
            float ballX = buffer.readFloat();
            float ballY = buffer.readFloat();
            float velocityX = buffer.readFloat();
            float velocityY = buffer.readFloat();
            return new BallUpdate(ballX, ballY, velocityX, velocityY);
        }

        public void handle(BallUpdate message, MessageContext context) {
            context.execute(() -> ClientPlayHandler.handleMessageTennisGameBallUpdate(message));
            context.setHandled(true);
        }

        public float getBallX() {
            return this.ballX;
        }

        public float getBallY() {
            return this.ballY;
        }

        public float getVelocityX() {
            return this.velocityX;
        }

        public float getVelocityY() {
            return this.velocityY;
        }
    }

    public static class PaddlePosition
    extends PlayMessage<PaddlePosition> {
        private float playerPos;
        private float opponentPos;

        public PaddlePosition() {
        }

        public PaddlePosition(float playerPos, float opponentPos) {
            this.playerPos = playerPos;
            this.opponentPos = opponentPos;
        }

        public void encode(PaddlePosition message, FriendlyByteBuf buffer) {
            buffer.writeFloat(message.playerPos);
            buffer.writeFloat(message.opponentPos);
        }

        public PaddlePosition decode(FriendlyByteBuf buffer) {
            float playerPos = buffer.readFloat();
            float opponentPos = buffer.readFloat();
            return new PaddlePosition(playerPos, opponentPos);
        }

        public void handle(PaddlePosition message, MessageContext context) {
            context.execute(() -> ClientPlayHandler.handleMessageTennisGamePaddlePosition(message));
            context.setHandled(true);
        }

        public float getPlayerPos() {
            return this.playerPos;
        }

        public float getOpponentPos() {
            return this.opponentPos;
        }
    }
}

