/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.starterstructure_common_forge.events;

import com.natamus.starterstructure_common_forge.config.ConfigHandler;
import com.natamus.starterstructure_common_forge.util.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class StructureProtectionEvents {
    public static boolean onBlockBreak(Level level, Player player, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        if (level.f_46443_) {
            return true;
        }
        if (ConfigHandler.playersInCreativeModeIgnoreProtection && player.m_7500_()) {
            return true;
        }
        if (Util.protectedMap.containsKey(level.m_46472_())) {
            return !Util.protectedMap.get(level.m_46472_()).contains(pos);
        }
        return true;
    }

    public static boolean onBlockPlace(Level level, BlockPos blockPos, BlockState blockState, LivingEntity livingEntity, ItemStack itemStack) {
        if (ConfigHandler.playersInCreativeModeIgnoreProtection && livingEntity instanceof Player && ((Player)livingEntity).m_7500_()) {
            return true;
        }
        if (Util.protectedMap.containsKey(level.m_46472_())) {
            return !Util.protectedMap.get(level.m_46472_()).contains(blockPos);
        }
        return true;
    }

    public static boolean onPistonMove(Level level, BlockPos blockPos, Direction direction, boolean isExtending) {
        BlockPos faceOffsetPos = blockPos.m_121945_(direction);
        BlockPos nextPos = faceOffsetPos.m_121945_(direction);
        if (Util.protectedMap.containsKey(level.m_46472_())) {
            return !Util.protectedMap.get(level.m_46472_()).contains(faceOffsetPos) && !Util.protectedMap.get(level.m_46472_()).contains(nextPos);
        }
        return true;
    }

    public static void onTNTExplode(Level level, Entity sourceEntity, Explosion explosion) {
        if (level.f_46443_) {
            return;
        }
        if (explosion == null) {
            return;
        }
        boolean cancel = false;
        if (Util.protectedMap.containsKey(level.m_46472_())) {
            for (BlockPos affectedPos : explosion.m_46081_()) {
                if (!Util.protectedMap.get(level.m_46472_()).contains(affectedPos)) continue;
                cancel = true;
                break;
            }
        }
        if (cancel) {
            explosion.m_46081_().clear();
            explosion.m_46078_().clear();
        }
    }

    public static boolean onEntityAttack(Player player, Level level, Entity targetEntity) {
        if (ConfigHandler.playersInCreativeModeIgnoreEntityProtection && player.m_7500_()) {
            return true;
        }
        if (ConfigHandler.protectSpawnedEntities && targetEntity.m_19880_().contains("starterstructure.protected")) {
            return false;
        }
        if ((targetEntity instanceof Painting || targetEntity instanceof ItemFrame) && Util.protectedMap.containsKey(level.m_46472_())) {
            return !Util.protectedMap.get(level.m_46472_()).contains(targetEntity.m_20183_());
        }
        return true;
    }
}

