/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.starterstructure_common_forge.util;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.natamus.collective_common_forge.data.GlobalVariables;
import com.natamus.collective_common_forge.functions.BlockPosFunctions;
import com.natamus.collective_common_forge.functions.DataFunctions;
import com.natamus.collective_common_forge.functions.DimensionFunctions;
import com.natamus.collective_common_forge.functions.SignFunctions;
import com.natamus.collective_common_forge.functions.WorldFunctions;
import com.natamus.collective_common_forge.schematic.ParseSchematicFile;
import com.natamus.collective_common_forge.schematic.ParsedSchematicObject;
import com.natamus.starterstructure_common_forge.config.ConfigHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.StructureBlock;
import net.minecraft.world.level.block.StructureVoidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.slf4j.Logger;

public class Util {
    public static HashMap<ResourceKey<Level>, List<BlockPos>> protectedMap = new HashMap();
    private static final String dirpath = DataFunctions.getConfigDirectory() + File.separator + "starterstructure";
    private static final File schematicDir = new File(dirpath + File.separator + "schematics");
    private static final File signDataDir = new File(dirpath + File.separator + "signdata");
    private static final Logger logger = LogUtils.getLogger();
    private static final String logPrefix = "[Starter Structure] ";

    public static boolean initDirs() {
        if (!schematicDir.isDirectory() && !schematicDir.mkdirs()) {
            return false;
        }
        if (!signDataDir.isDirectory()) {
            return signDataDir.mkdirs();
        }
        return true;
    }

    public static BlockPos generateSchematic(ServerLevel serverLevel) {
        ParsedSchematicObject parsedSchematicObject;
        File[] listOfFiles;
        if (!schematicDir.isDirectory() && !Util.initDirs()) {
            logger.info("[Starter Structure] Unable to generate directories.");
            return null;
        }
        ArrayList<File> listOfSchematicFiles = new ArrayList<File>();
        for (File file : listOfFiles = schematicDir.listFiles()) {
            if (!file.getName().endsWith(".schem") && !file.getName().endsWith(".schematic") && !file.getName().endsWith(".nbt")) continue;
            listOfSchematicFiles.add(file);
        }
        if (listOfSchematicFiles.isEmpty()) {
            logger.info("[Starter Structure] No schematics found to generate the starter structure.");
            return null;
        }
        File schematicFile = (File)listOfSchematicFiles.get(GlobalVariables.random.nextInt(listOfSchematicFiles.size()));
        if (!schematicFile.isFile()) {
            logger.info("[Starter Structure] Unable to find starter structure file.");
            return null;
        }
        boolean automaticCenter = schematicFile.getName().endsWith(".nbt");
        BlockPos structurePos = serverLevel.m_220360_();
        if (ConfigHandler.shouldUseStructurePosition) {
            structurePos = new BlockPos(ConfigHandler.generatedStructureXPosition, ConfigHandler.generatedStructureYPosition, ConfigHandler.generatedStructureZPosition);
        }
        if (ConfigHandler.ignoreTreesDuringStructurePlacement && (!ConfigHandler.shouldUseStructurePosition || ConfigHandler.generatedStructureYPosition == 0)) {
            structurePos = Util.getSpawnPos(serverLevel, BlockPosFunctions.getSurfaceBlockPos((ServerLevel)serverLevel, (int)structurePos.m_123341_(), (int)structurePos.m_123343_(), (boolean)true), false, false);
        }
        if (ConfigHandler.shouldUseStructureOffset) {
            structurePos = structurePos.m_7918_(ConfigHandler.generatedStructureXOffset, ConfigHandler.generatedStructureYOffset, ConfigHandler.generatedStructureZOffset).m_7949_();
        }
        try (FileInputStream fileInputStream = new FileInputStream(schematicFile);){
            parsedSchematicObject = ParseSchematicFile.getParsedSchematicObject((InputStream)fileInputStream, (Level)serverLevel, (BlockPos)structurePos, (int)0, (boolean)false, (boolean)automaticCenter);
        }
        catch (Exception ex) {
            logger.info("[Starter Structure] Exception while attempting to parse schematic file.");
            ex.printStackTrace();
            return null;
        }
        if (!parsedSchematicObject.parsedCorrectly) {
            logger.info("[Starter Structure] The starter structure object was not parsed correctly.");
            return null;
        }
        BlockPos finalStructurePos = structurePos;
        MinecraftServer minecraftServer = serverLevel.m_7654_();
        minecraftServer.execute(() -> {
            ArrayList<BlockPos> protectedList = null;
            if (ConfigHandler.protectStructureBlocks) {
                protectedList = new ArrayList<BlockPos>();
            }
            int yoffset = ConfigHandler.generatedStructureYOffset;
            logger.info("[Starter Structure] Generating starter structure with {} blocks.", (Object)parsedSchematicObject.blocks.size());
            for (Pair blockPair : parsedSchematicObject.blocks) {
                BlockState blockState = (BlockState)blockPair.getSecond();
                Block block = blockState.m_60734_();
                if ((block instanceof JigsawBlock || block instanceof StructureBlock || block instanceof StructureVoidBlock) && ConfigHandler.generationIgnoreJigsawAndStructureBlocks) continue;
                serverLevel.m_7731_((BlockPos)blockPair.getFirst(), blockState, 3);
                if (protectedList == null) continue;
                protectedList.add((BlockPos)blockPair.getFirst());
            }
            if (protectedList != null) {
                Util.writeProtectedList(serverLevel, protectedList);
            }
            minecraftServer.execute(() -> {
                parsedSchematicObject.placeBlockEntitiesInWorld((Level)serverLevel);
                Registry entityTypeRegistry = serverLevel.m_9598_().m_175515_(Registries.f_256939_);
                for (Pair blockEntityPair : parsedSchematicObject.getBlockEntities((Level)serverLevel)) {
                    BlockPos blockPos = (BlockPos)blockEntityPair.getFirst();
                    BlockEntity blockEntity = (BlockEntity)blockEntityPair.getSecond();
                    if (!(blockEntity instanceof SignBlockEntity)) continue;
                    SignBlockEntity signBlockEntity = (SignBlockEntity)blockEntity;
                    List signLines = SignFunctions.getSignText((SignBlockEntity)signBlockEntity);
                    String firstLine = (String)signLines.get(0);
                    signLines.remove(0);
                    String signContent = String.join((CharSequence)"", signLines);
                    Entity newEntity = null;
                    if (firstLine.contains("[Mob]") || firstLine.contains("[Entity]")) {
                        EntityType entityType = (EntityType)entityTypeRegistry.m_7745_(new ResourceLocation(signContent));
                        if (entityType != null) {
                            newEntity = entityType.m_20615_((Level)serverLevel);
                        }
                    } else {
                        if (!firstLine.contains("[NBT]")) continue;
                        String nbtFilePath = signDataDir + File.separator + signContent + ".txt";
                        File nbtTextFile = new File(nbtFilePath);
                        if (nbtTextFile.isFile()) {
                            for (int n = 1; n >= 0; --n) {
                                String rawNBT = "";
                                try {
                                    rawNBT = new String(Files.readAllBytes(Paths.get(nbtFilePath, new String[0])));
                                    CompoundTag entityCompoundTag = TagParser.m_129359_((String)rawNBT);
                                    Optional optionalNewEntity = EntityType.m_20642_((CompoundTag)entityCompoundTag, (Level)serverLevel);
                                    if (!optionalNewEntity.isPresent()) continue;
                                    if (n != 1) {
                                        logger.info("[Starter Structure] Unable to parse the {}.txt entitydata file. Attempting automatic fix. (1)", (Object)signContent);
                                    }
                                    newEntity = (Entity)optionalNewEntity.get();
                                    n = -1;
                                    continue;
                                }
                                catch (Exception ex) {
                                    logger.info("[Starter Structure] Unable to parse the {}.txt entitydata file. Attempting automatic fix. (2)", (Object)signContent);
                                    try {
                                        Util.attemptEntityDataFileFix(nbtFilePath, rawNBT);
                                        continue;
                                    }
                                    catch (IOException iOException) {
                                        // empty catch block
                                    }
                                }
                            }
                        }
                    }
                    if (newEntity == null) continue;
                    newEntity.m_19880_().add("starterstructure.protected");
                    newEntity.m_6034_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_(), (double)blockPos.m_123343_() + 0.5);
                    serverLevel.m_7967_(newEntity);
                    serverLevel.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 3);
                }
                if (ConfigHandler.spawnNonSignEntitiesFromSupportedSchematics && !parsedSchematicObject.entities.isEmpty()) {
                    for (Pair entityPair : parsedSchematicObject.entities) {
                        Entity newEntity = (Entity)entityPair.getSecond();
                        newEntity.m_19880_().add("starterstructure.protected");
                        serverLevel.m_7967_(newEntity);
                    }
                }
                minecraftServer.execute(() -> {
                    float spawnAngle = serverLevel.m_220361_();
                    if (!Util.isSpawnablePos((Level)serverLevel, finalStructurePos)) {
                        List<Integer> absoluteArray = Arrays.asList(-1, 1);
                        for (int i = 0; i <= 10; ++i) {
                            for (BlockPos aroundPos : BlockPos.m_121976_((int)(finalStructurePos.m_123341_() - i), (int)(finalStructurePos.m_123342_() - i), (int)(finalStructurePos.m_123343_() - i), (int)(finalStructurePos.m_123341_() + i), (int)(finalStructurePos.m_123342_() + i), (int)(finalStructurePos.m_123343_() + i))) {
                                BlockPos upPos = aroundPos.m_7494_();
                                if (!Util.isSpawnablePos((Level)serverLevel, aroundPos) || !Util.isSpawnablePos((Level)serverLevel, upPos)) continue;
                                serverLevel.m_8733_(aroundPos, spawnAngle);
                                return;
                            }
                        }
                    }
                });
            });
        });
        return structurePos;
    }

    private static void attemptEntityDataFileFix(String nbtFilePath, String rawNBT) throws IOException {
        String[] rawSplit = rawNBT.split("\\{", 2);
        if (rawSplit.length > 1) {
            String prefix = rawSplit[0];
            Object newRawNBT = rawSplit[1];
            Object idValue = "";
            if (prefix.contains(":")) {
                String[] prefixSplit;
                for (String word : prefixSplit = prefix.split(" ")) {
                    if (!word.contains(":")) continue;
                    idValue = "id:\"" + word + "\",";
                }
            }
            if (!((String)idValue).isEmpty()) {
                newRawNBT = "{" + (String)idValue + (String)newRawNBT;
                Files.write(Path.of(nbtFilePath, new String[0]), ((String)newRawNBT).getBytes(), new OpenOption[0]);
            }
        }
    }

    private static boolean isSpawnablePos(Level level, BlockPos pos) {
        return level.m_8055_(pos).m_60734_().equals(Blocks.f_50016_);
    }

    private static void writeProtectedList(ServerLevel serverLevel, List<BlockPos> protectedList) {
        protectedMap.put((ResourceKey<Level>)serverLevel.m_46472_(), protectedList);
        String protectedPath = WorldFunctions.getWorldPath((ServerLevel)serverLevel) + File.separator + "data" + File.separator + "starterstructure" + File.separator + "protection" + File.separator + DimensionFunctions.getSimpleDimensionString((Level)serverLevel);
        File protectedPathDir = new File(protectedPath);
        if (!protectedPathDir.isDirectory()) {
            protectedPathDir.mkdirs();
        }
        try {
            FileWriter writer = new FileWriter(protectedPath + File.separator + "blocks.txt");
            for (BlockPos protectedPos : protectedList) {
                String coordinateString = protectedPos.m_123341_() + "," + protectedPos.m_123342_() + "," + protectedPos.m_123343_();
                writer.write(coordinateString + "\n");
            }
            writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void readProtectedList(ServerLevel serverLevel) {
        String protectedPath = WorldFunctions.getWorldPath((ServerLevel)serverLevel) + File.separator + "data" + File.separator + "starterstructure" + File.separator + "protection" + File.separator + DimensionFunctions.getSimpleDimensionString((Level)serverLevel);
        File protectedPathDir = new File(protectedPath);
        if (!protectedPathDir.isDirectory()) {
            return;
        }
        String protectedFilePath = protectedPath + File.separator + "blocks.txt";
        if (!new File(protectedFilePath).isFile()) {
            return;
        }
        try {
            String rawProtectedList = new String(Files.readAllBytes(Paths.get(protectedFilePath, new String[0])));
            ArrayList<BlockPos> newProtectedList = new ArrayList<BlockPos>();
            for (String coordinateString : rawProtectedList.split("\n")) {
                String[] csspl = coordinateString.split(",");
                if (csspl.length != 3) continue;
                try {
                    newProtectedList.add(new BlockPos(Integer.parseInt(csspl[0]), Integer.parseInt(csspl[1]), Integer.parseInt(csspl[2])));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (!newProtectedList.isEmpty()) {
                protectedMap.put((ResourceKey<Level>)serverLevel.m_46472_(), newProtectedList);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void processEntityMovementOnJoin(Entity entity) {
        if (entity.m_19880_().contains("starterstructure.protected") && ConfigHandler.preventSpawnedEntityMovement && entity instanceof LivingEntity) {
            ((LivingEntity)entity).m_21051_(Attributes.f_22279_).m_22100_(0.0);
        }
    }

    public static BlockPos getSpawnPos(ServerLevel serverLevel, BlockPos blockPos, boolean withOffset, boolean onSurface) {
        int x = blockPos.m_123341_();
        int y = blockPos.m_123342_();
        int z = blockPos.m_123343_();
        if (ConfigHandler.shouldUseSpawnCoordinates) {
            x = ConfigHandler.spawnXCoordinate;
            y = ConfigHandler.spawnYCoordinate;
            z = ConfigHandler.spawnZCoordinate;
            if (ConfigHandler.spawnYCoordinate != 0) {
                onSurface = false;
            }
        }
        if (ConfigHandler.shouldUseSpawnCoordOffsets && withOffset) {
            x += ConfigHandler.spawnXCoordOffset;
            y += ConfigHandler.spawnYCoordOffset;
            z += ConfigHandler.spawnZCoordOffset;
        }
        if (onSurface) {
            y = BlockPosFunctions.getSurfaceBlockPos((ServerLevel)serverLevel, (int)x, (int)z, (boolean)ConfigHandler.ignoreTreesDuringStructurePlacement).m_123342_();
        }
        if (y < serverLevel.m_141937_()) {
            y = serverLevel.m_141937_() + 1;
        } else if (y > serverLevel.m_151558_()) {
            y = serverLevel.m_151558_() - 1;
        }
        return new BlockPos(x, y, z);
    }
}

