/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive;

import com.stereowalker.survive.Survive;
import com.stereowalker.survive.json.FoodJsonHolder;
import com.stereowalker.survive.world.DataMaps;
import com.stereowalker.unionlib.util.RegistryHelper;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class FoodUtils {
    public static final String EXPIRE = "expiry_date";

    public static void giveLifespanToFood(NonNullList<ItemStack> items, long gametime) {
        if (Survive.CONFIG.enable_food_spoiling) {
            items.forEach(stack -> {
                long lifespan;
                if (stack.m_41614_() && DataMaps.Server.consummableItem.containsKey(RegistryHelper.items().m_7981_((Object)stack.m_41720_())) && !stack.m_41784_().m_128441_(EXPIRE) && (lifespan = (long)DataMaps.Server.consummableItem.get(RegistryHelper.items().m_7981_((Object)stack.m_41720_())).lifespan()) > 0L) {
                    long shaveAMinuteOff = gametime - gametime % 1200L;
                    stack.m_41783_().m_128356_(EXPIRE, shaveAMinuteOff + (long)DataMaps.Server.consummableItem.get(RegistryHelper.items().m_7981_((Object)stack.m_41720_())).lifespan());
                }
            });
        } else {
            items.forEach(stack -> {
                if (stack.m_41783_() != null && stack.m_41783_().m_128441_(EXPIRE)) {
                    stack.m_41783_().m_128473_(EXPIRE);
                }
            });
        }
    }

    public static void applyFoodStatusToTooltip(Player player, ItemStack stack, List<Component> tip) {
        if (stack.m_41614_() && Survive.CONFIG.enable_food_spoiling) {
            if (FoodUtils.foodStatus(stack, player.m_9236_()) == State.Fresh) {
                tip.add((Component)Component.m_237113_((String)"Fresh").m_6270_(Style.f_131099_.m_178520_(0x88FF88)));
            } else if (FoodUtils.foodStatus(stack, player.m_9236_()) == State.Good) {
                tip.add((Component)Component.m_237113_((String)"Good").m_6270_(Style.f_131099_.m_178520_(65280)));
            } else if (FoodUtils.foodStatus(stack, player.m_9236_()) == State.Spoiling) {
                tip.add((Component)Component.m_237113_((String)"Spoiling").m_6270_(Style.f_131099_.m_178520_(0xAAFF00)));
            } else if (FoodUtils.foodStatus(stack, player.m_9236_()) == State.Spoiled) {
                tip.add((Component)Component.m_237113_((String)"Spoiled").m_6270_(Style.f_131099_.m_178520_(0x88AA00)));
            } else {
                tip.add((Component)Component.m_237113_((String)"Okay").m_6270_(Style.f_131099_.m_178520_(0xFFFF00)));
            }
        }
    }

    public static State foodStatus(ItemStack stack, Level level) {
        if (stack.m_41783_() != null && DataMaps.Server.consummableItem.containsKey(RegistryHelper.items().m_7981_((Object)stack.m_41720_())) && stack.m_41783_().m_128441_(EXPIRE) && Survive.CONFIG.enable_food_spoiling) {
            FoodJsonHolder food = DataMaps.Server.consummableItem.get(RegistryHelper.items().m_7981_((Object)stack.m_41720_()));
            long timeTill = (long)stack.m_41783_().m_128451_(EXPIRE) - level.m_46467_();
            long timeSince = (long)food.lifespan() - timeTill;
            if (timeTill < 0L) {
                return State.Spoiled;
            }
            if (timeTill <= (long)(food.ticksFresh() * 2)) {
                return State.Spoiling;
            }
            if (timeSince <= (long)food.ticksFresh()) {
                return State.Fresh;
            }
            if (timeSince <= (long)(food.ticksFresh() * 3)) {
                return State.Good;
            }
        }
        return State.Okay;
    }

    public static enum State {
        Fresh,
        Good,
        Okay,
        Spoiling,
        Spoiled;

    }
}

