/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive;

import com.mojang.blaze3d.systems.RenderSystem;
import com.stereowalker.survive.Survive;
import com.stereowalker.survive.core.SurviveEntityStats;
import com.stereowalker.survive.needs.IRealisticEntity;
import com.stereowalker.survive.world.effect.SMobEffects;
import com.stereowalker.survive.world.entity.ai.attributes.SAttributes;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import org.apache.commons.lang3.mutable.MutableInt;

@OnlyIn(value=Dist.CLIENT)
public class GuiHelper {
    public static final ResourceLocation GUI_ICONS = new ResourceLocation("survive", "textures/gui/icons.png");

    @OnlyIn(value=Dist.CLIENT)
    public static void registerOverlays(RegisterGuiOverlaysEvent event) {
        event.registerAbove(VanillaGuiOverlay.FOOD_LEVEL.id(), "thirst_level", (gui, mStack, partialTicks, screenWidth, screenHeight) -> {
            boolean isMounted = gui.f_92986_.f_91074_.m_20202_() instanceof LivingEntity;
            if (Survive.THIRST_CONFIG.enabled && !isMounted && !gui.f_92986_.f_91066_.f_92062_ && gui.shouldDrawSurvivalElements()) {
                gui.setupOverlayRenderState(true, false);
                int left = screenWidth / 2 + 91;
                int top = screenHeight - gui.rightHeight;
                GuiHelper.renderThirst((Gui)gui, mStack, new MutableInt(), left, top, true);
                gui.rightHeight += 10;
            }
        });
        event.registerAbove(VanillaGuiOverlay.FOOD_LEVEL.id(), "stamina_level", (gui, mStack, partialTicks, screenWidth, screenHeight) -> {
            boolean isMounted = gui.f_92986_.f_91074_.m_20202_() instanceof LivingEntity;
            if (Survive.STAMINA_CONFIG.enabled && !isMounted && !gui.f_92986_.f_91066_.f_92062_ && gui.shouldDrawSurvivalElements()) {
                gui.setupOverlayRenderState(true, false);
                int left = screenWidth / 2 + 91;
                int top = screenHeight - gui.rightHeight;
                MutableInt moveUp = new MutableInt();
                GuiHelper.renderEnergyBars((Gui)gui, mStack, moveUp, left, top, true);
                gui.rightHeight += moveUp.getValue().intValue();
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderThirst(Gui gui, GuiGraphics mStack, MutableInt moveUp, int j1, int k1, boolean forgeOverlay) {
        Player player = (Player)gui.f_92986_.m_91288_();
        IRealisticEntity realisticPlayer = (IRealisticEntity)player;
        int waterL = realisticPlayer.getWaterData().getWaterLevel();
        gui.f_92986_.m_91307_().m_6180_("thirst");
        for (int k6 = 0; k6 < 10; ++k6) {
            int i7 = k1;
            int k7 = 16;
            int i8 = 0;
            if (player.m_21023_(SMobEffects.THIRST)) {
                k7 += 36;
                i8 = 13;
            }
            if (realisticPlayer.getWaterData().getHydrationLevel() <= 0.0f && gui.f_92989_ % (waterL * 3 + 1) == 0) {
                i7 = k1 + (gui.f_92985_.m_188503_(3) - 1);
            }
            int k8 = j1 - k6 * 8 - 9;
            mStack.m_280218_(GUI_ICONS, k8, i7 - moveUp.getValue(), 16 + i8 * 9, 54, 9, 9);
            if (k6 * 2 + 1 < waterL) {
                mStack.m_280218_(GUI_ICONS, k8, i7 - moveUp.getValue(), k7 + 36, 54, 9, 9);
            }
            if (k6 * 2 + 1 != waterL) continue;
            mStack.m_280218_(GUI_ICONS, k8, i7 - moveUp.getValue(), k7 + 45, 54, 9, 9);
        }
        moveUp.add(-10);
        gui.f_92986_.m_91307_().m_7238_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderEnergyBars(Gui gui, GuiGraphics mStack, MutableInt moveUp, int j1, int k1, boolean forgeOverlay) {
        Random rand = new Random();
        Player player = (Player)gui.f_92986_.m_91288_();
        float maxStamina = (float)player.m_21133_(SAttributes.MAX_STAMINA);
        int l = SurviveEntityStats.getEnergyStats((LivingEntity)player).getEnergyLevel();
        if (SurviveEntityStats.getEnergyStats((LivingEntity)player).isExhausted()) {
            l = SurviveEntityStats.getEnergyStats((LivingEntity)player).getReserveLevel();
        }
        Minecraft.m_91087_().m_91307_().m_6180_("energy");
        if (!forgeOverlay) {
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_ICONS);
        }
        for (int i = 0; i < Mth.m_14167_((float)(maxStamina / 20.0f)); ++i) {
            for (int k6 = 0; k6 < 10; ++k6) {
                int i7 = k1;
                int k7 = 16;
                int i8 = 0;
                if (SurviveEntityStats.getEnergyStats((LivingEntity)player).isExhausted()) {
                    k7 += 36;
                    i8 = 13;
                }
                if (player.m_36324_().m_38722_() <= 0.0f && gui.m_93079_() % (l * 3 + 1) == 0) {
                    i7 = k1 + (rand.nextInt(3) - 1);
                }
                int k8 = j1 - k6 * 8 - 9;
                if (k6 * 2 + 1 + 20 * i < Mth.m_14143_((float)maxStamina) + 1) {
                    mStack.m_280218_(GUI_ICONS, k8, i7 - moveUp.getValue(), 16 + i8 * 9, 36, 9, 9);
                }
                if (k6 * 2 + 1 + 20 * i < l) {
                    mStack.m_280218_(GUI_ICONS, k8, i7 - moveUp.getValue(), k7 + 36, 36, 9, 9);
                }
                if (k6 * 2 + 1 + 20 * i != l) continue;
                mStack.m_280218_(GUI_ICONS, k8, i7 - moveUp.getValue(), k7 + 45, 36, 9, 9);
            }
            moveUp.add(10);
        }
        Minecraft.m_91087_().m_91307_().m_7238_();
    }
}

