/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.stereowalker.survive.FoodUtils;
import com.stereowalker.survive.GuiHelper;
import com.stereowalker.survive.SurviveClientSegment;
import com.stereowalker.survive.compat.OriginsCompat;
import com.stereowalker.survive.compat.SItemProperties;
import com.stereowalker.survive.config.Config;
import com.stereowalker.survive.config.HygieneConfig;
import com.stereowalker.survive.config.ServerConfig;
import com.stereowalker.survive.config.StaminaConfig;
import com.stereowalker.survive.config.TemperatureConfig;
import com.stereowalker.survive.config.ThirstConfig;
import com.stereowalker.survive.config.WellbeingConfig;
import com.stereowalker.survive.core.cauldron.SCauldronInteraction;
import com.stereowalker.survive.events.SurviveEvents;
import com.stereowalker.survive.json.ArmorJsonHolder;
import com.stereowalker.survive.json.BiomeJsonHolder;
import com.stereowalker.survive.json.BlockTemperatureJsonHolder;
import com.stereowalker.survive.json.EntityTemperatureJsonHolder;
import com.stereowalker.survive.json.FoodJsonHolder;
import com.stereowalker.survive.json.PotionJsonHolder;
import com.stereowalker.survive.json.property.BlockPropertyHandlerImpl;
import com.stereowalker.survive.network.protocol.game.ClientboundDataTransferPacket;
import com.stereowalker.survive.network.protocol.game.ClientboundDrinkSoundPacket;
import com.stereowalker.survive.network.protocol.game.ClientboundSurvivalStatsPacket;
import com.stereowalker.survive.network.protocol.game.ServerboundArmorStaminaPacket;
import com.stereowalker.survive.network.protocol.game.ServerboundInteractWithWaterPacket;
import com.stereowalker.survive.network.protocol.game.ServerboundPlayerStatusBookPacket;
import com.stereowalker.survive.network.protocol.game.ServerboundRelaxPacket;
import com.stereowalker.survive.network.protocol.game.ServerboundStaminaExhaustionPacket;
import com.stereowalker.survive.network.protocol.game.ServerboundThirstMovementPacket;
import com.stereowalker.survive.resource.ArmorDataManager;
import com.stereowalker.survive.resource.BiomeDataManager;
import com.stereowalker.survive.resource.BlockDataManager;
import com.stereowalker.survive.resource.EntityTemperatureDataManager;
import com.stereowalker.survive.resource.FluidDataManager;
import com.stereowalker.survive.resource.ItemConsummableDataManager;
import com.stereowalker.survive.resource.PotionDrinkDataManager;
import com.stereowalker.survive.server.commands.NeedsCommand;
import com.stereowalker.survive.tags.FluidSTags;
import com.stereowalker.survive.tags.ItemSTags;
import com.stereowalker.survive.world.DataMaps;
import com.stereowalker.survive.world.effect.SMobEffects;
import com.stereowalker.survive.world.entity.ai.attributes.SAttributes;
import com.stereowalker.survive.world.item.CanteenItem;
import com.stereowalker.survive.world.item.HygieneItems;
import com.stereowalker.survive.world.item.SCreativeModeTab;
import com.stereowalker.survive.world.item.SItems;
import com.stereowalker.survive.world.item.alchemy.BrewingRecipes;
import com.stereowalker.survive.world.item.alchemy.SPotions;
import com.stereowalker.survive.world.item.crafting.SRecipeSerializer;
import com.stereowalker.survive.world.item.enchantment.StaminaEnchantments;
import com.stereowalker.survive.world.item.enchantment.TemperatureEnchantments;
import com.stereowalker.survive.world.level.CGameRules;
import com.stereowalker.survive.world.level.block.SBlocks;
import com.stereowalker.survive.world.level.material.PurifiedWaterFluid;
import com.stereowalker.survive.world.level.material.SFluids;
import com.stereowalker.survive.world.spellcraft.SSpells;
import com.stereowalker.unionlib.api.collectors.CommandCollector;
import com.stereowalker.unionlib.api.collectors.ConfigCollector;
import com.stereowalker.unionlib.api.collectors.DefaultAttributeModifier;
import com.stereowalker.unionlib.api.collectors.InsertCollector;
import com.stereowalker.unionlib.api.collectors.PacketCollector;
import com.stereowalker.unionlib.api.collectors.ReloadListeners;
import com.stereowalker.unionlib.api.creativetabs.CreativeTabBuilder;
import com.stereowalker.unionlib.api.creativetabs.CreativeTabPopulator;
import com.stereowalker.unionlib.api.registries.RegistryCollector;
import com.stereowalker.unionlib.config.ConfigObject;
import com.stereowalker.unionlib.insert.InsertHandler;
import com.stereowalker.unionlib.insert.Inserts;
import com.stereowalker.unionlib.insert.handler.ItemTooltipHandler;
import com.stereowalker.unionlib.insert.handler.LevelHandler;
import com.stereowalker.unionlib.insert.handler.LootTableLoadHandler;
import com.stereowalker.unionlib.insert.handler.MenuHandler;
import com.stereowalker.unionlib.insert.handler.PlayerInsertHandler;
import com.stereowalker.unionlib.insert.handler.PlayerRestoreHandler;
import com.stereowalker.unionlib.insert.handler.living.LivingInsertHandler;
import com.stereowalker.unionlib.mod.MinecraftMod;
import com.stereowalker.unionlib.mod.PacketHolder;
import com.stereowalker.unionlib.mod.ServerSegment;
import com.stereowalker.unionlib.resource.ReloadListener;
import com.stereowalker.unionlib.util.RegistryHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

@Mod(value="survive")
public class Survive
extends MinecraftMod
implements PacketHolder {
    public static final float DEFAULT_TEMP = 37.0f;
    public static final int PURIFIED_WATER_COLOR = 4314104;
    public static Map<Potion, List<Fluid>> POTION_FLUID_MAP;
    public static final String MOD_ID = "survive";
    public static final Config CONFIG;
    public static final StaminaConfig STAMINA_CONFIG;
    public static final HygieneConfig HYGIENE_CONFIG;
    public static final TemperatureConfig TEMPERATURE_CONFIG;
    public static final ThirstConfig THIRST_CONFIG;
    public static final WellbeingConfig WELLBEING_CONFIG;
    public static boolean isPrimalWinterLoaded;
    public static final ItemConsummableDataManager consummableReloader;
    public static final PotionDrinkDataManager potionReloader;
    public static final ArmorDataManager armorReloader;
    public static final BlockDataManager blockReloader;
    public static final BiomeDataManager biomeReloader;
    public static final EntityTemperatureDataManager entityReloader;
    public static final FluidDataManager fluidReloader;
    private static Survive instance;

    public static boolean isCombatLoaded() {
        return ModList.get().isLoaded("combat");
    }

    public static boolean isOriginsLoaded() {
        return ModList.get().isLoaded("origins");
    }

    public Survive() {
        super(MOD_ID, () -> new SurviveClientSegment(), () -> new ServerSegment());
        instance = this;
        this.eventBus().addListener(this::clientRegistries);
        this.eventBus().addListener(event -> GuiHelper.registerOverlays(event));
        MinecraftForge.EVENT_BUS.addListener(event -> {
            if (event.getPotion() == SPotions.PURIFIED_WATER) {
                event.setFluid((Fluid)SFluids.PURIFIED_WATER);
                event.setFlowingFluid((Fluid)SFluids.FLOWING_PURIFIED_WATER);
            }
        });
        MinecraftForge.EVENT_BUS.addListener(event -> {
            if (event.getFluid().m_76152_() instanceof PurifiedWaterFluid) {
                event.setPotion(SPotions.PURIFIED_WATER);
            }
        });
        isPrimalWinterLoaded = ModList.get().isLoaded("primalwinter");
    }

    public void onModConstruct() {
        new FluidSTags();
        new ItemSTags();
        if (Survive.isCombatLoaded()) {
            SSpells.registerAll(this.eventBus());
        }
        if (Survive.isOriginsLoaded()) {
            OriginsCompat.initOriginsPatcher();
        }
        BlockPropertyHandlerImpl.init();
    }

    public void onModStartup() {
        SCauldronInteraction.bootStrap();
        BrewingRecipes.addBrewingRecipes();
        CGameRules.init();
        for (Item item : ForgeRegistries.ITEMS) {
            if (!item.m_41472_()) continue;
            DataMaps.Server.defaultFood.put(ForgeRegistries.ITEMS.getKey((Object)item), item.m_41473_());
        }
    }

    public void onModStartupInClient() {
        RenderType frendertype = RenderType.m_110466_();
        ItemBlockRenderTypes.setRenderLayer((Fluid)SFluids.PURIFIED_WATER, (RenderType)frendertype);
        ItemBlockRenderTypes.setRenderLayer((Fluid)SFluids.FLOWING_PURIFIED_WATER, (RenderType)frendertype);
    }

    public void setupConfigs(ConfigCollector collector) {
        collector.registerConfig(ServerConfig.class);
        collector.registerConfig((ConfigObject)CONFIG);
        collector.registerConfig((ConfigObject)HYGIENE_CONFIG);
        collector.registerConfig((ConfigObject)TEMPERATURE_CONFIG);
        collector.registerConfig((ConfigObject)THIRST_CONFIG);
        collector.registerConfig((ConfigObject)WELLBEING_CONFIG);
        collector.registerConfig((ConfigObject)STAMINA_CONFIG);
    }

    public void setupCommands(CommandCollector collector) {
        NeedsCommand.register((CommandDispatcher<CommandSourceStack>)collector.dispatcher());
    }

    public void setupRegistries(RegistryCollector collector) {
        collector.addRegistryHolder(SBlocks.class);
        collector.addRegistryHolder(SFluids.class);
        collector.addRegistryHolder(SItems.class);
        collector.addRegistryHolder(HygieneItems.class);
        collector.addRegistryHolder(SRecipeSerializer.class);
        collector.addRegistryHolder(SAttributes.class);
        collector.addRegistryHolder(SMobEffects.class);
        if (Survive.STAMINA_CONFIG.enabled) {
            collector.addRegistryHolder(StaminaEnchantments.class);
        }
        if (Survive.TEMPERATURE_CONFIG.enabled) {
            collector.addRegistryHolder(TemperatureEnchantments.class);
        }
    }

    public void registerInserts(InsertCollector collector) {
        collector.addInsert((InsertHandler)Inserts.LIVING_TICK, (InsertHandler.Insert)((LivingInsertHandler.LivingInsert)SurviveEvents::sendToClient));
        collector.addInsert((InsertHandler)Inserts.LIVING_TICK, (InsertHandler.Insert)((LivingInsertHandler.LivingInsert)SurviveEvents::updateEnvTemperature));
        collector.addInsert((InsertHandler)Inserts.PLAYER_RESTORE, (InsertHandler.Insert)((PlayerRestoreHandler.PlayerRestoreInsert)SurviveEvents::restoreStats));
        collector.addInsert((InsertHandler)Inserts.LOGGED_OUT, (InsertHandler.Insert)((PlayerInsertHandler.PlayerInsert)SurviveEvents::desyncClient));
        collector.addInsert((InsertHandler)Inserts.LEVEL_LOAD, (InsertHandler.Insert)((LevelHandler.LevelInsert)SurviveEvents::addReload));
        collector.addInsert((InsertHandler)Inserts.LOOT_TABLE_LOAD, (InsertHandler.Insert)((LootTableLoadHandler.LivingFallInsert)(id, lootTable, cancel) -> {
            String ANIMAL_LOOT = "entities/animal_fat";
            ArrayList LOOT_MODIFIERS = Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)new ResourceLocation("entities/sheep"), (Object)Lists.newArrayList((Object[])new String[]{ANIMAL_LOOT})), Pair.of((Object)new ResourceLocation("entities/chicken"), (Object)Lists.newArrayList((Object[])new String[]{ANIMAL_LOOT})), Pair.of((Object)new ResourceLocation("entities/cow"), (Object)Lists.newArrayList((Object[])new String[]{ANIMAL_LOOT})), Pair.of((Object)new ResourceLocation("entities/pig"), (Object)Lists.newArrayList((Object[])new String[]{ANIMAL_LOOT}))});
            BiFunction<String, Integer, LootPoolEntryContainer.Builder> getInjectEntry = (name, weight) -> {
                ResourceLocation table = Survive.getInstance().location("inject/" + name);
                return LootTableReference.m_79776_((ResourceLocation)table).m_79707_(weight.intValue());
            };
            LOOT_MODIFIERS.forEach(pair -> {
                if (id.equals(pair.getKey())) {
                    ((List)pair.getValue()).forEach(file -> {
                        Survive.getInstance().debug("Injecting \"" + file + "\" in " + pair.getKey());
                        ((LootTable)lootTable.get()).addPool(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)getInjectEntry.apply((String)file, 1)).m_165135_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f)).name("survive_inject").m_79082_());
                    });
                }
            });
        }));
        collector.addInsert((InsertHandler)Inserts.ITEM_TOOLTIP, (InsertHandler.Insert)((ItemTooltipHandler.ItemTooltipInsert)(stack, player, tip, flag) -> {
            if (player != null) {
                FoodUtils.applyFoodStatusToTooltip(player, stack, tip);
            }
        }));
        collector.addInsert((InsertHandler)Inserts.MENU_OPEN, (InsertHandler.Insert)((MenuHandler.EntityJoinLevelInsert)(player, menu) -> {
            if (player != null) {
                FoodUtils.giveLifespanToFood((NonNullList<ItemStack>)menu.m_38927_(), player.m_9236_().m_46467_());
            }
        }));
    }

    public void modifyDefaultEntityAttributes(DefaultAttributeModifier modifier) {
        super.modifyDefaultEntityAttributes(modifier);
        modifier.addToEntity(EntityType.f_20532_, new Attribute[]{SAttributes.COLD_RESISTANCE, SAttributes.HEAT_RESISTANCE, SAttributes.MAX_STAMINA});
    }

    public void registerPackets(PacketCollector collector) {
        collector.registerServerboundPacket(this.location(""), ServerboundArmorStaminaPacket.class, packetBuffer -> new ServerboundArmorStaminaPacket((FriendlyByteBuf)packetBuffer));
        collector.registerServerboundPacket(this.location(""), ServerboundThirstMovementPacket.class, packetBuffer -> new ServerboundThirstMovementPacket((FriendlyByteBuf)packetBuffer));
        collector.registerServerboundPacket(this.location(""), ServerboundInteractWithWaterPacket.class, packetBuffer -> new ServerboundInteractWithWaterPacket((FriendlyByteBuf)packetBuffer));
        collector.registerServerboundPacket(this.location(""), ServerboundStaminaExhaustionPacket.class, ServerboundStaminaExhaustionPacket::new);
        collector.registerServerboundPacket(this.location(""), ServerboundRelaxPacket.class, ServerboundRelaxPacket::new);
        collector.registerServerboundPacket(this.location(""), ServerboundPlayerStatusBookPacket.class, ServerboundPlayerStatusBookPacket::new);
        collector.registerClientboundPacket(this.location(""), ClientboundSurvivalStatsPacket.class, packetBuffer -> new ClientboundSurvivalStatsPacket((FriendlyByteBuf)packetBuffer));
        collector.registerClientboundPacket(this.location(""), ClientboundDrinkSoundPacket.class, packetBuffer -> new ClientboundDrinkSoundPacket((FriendlyByteBuf)packetBuffer));
        collector.registerClientboundPacket(this.location(""), ClientboundDataTransferPacket.class, packetBuffer -> new ClientboundDataTransferPacket((FriendlyByteBuf)packetBuffer));
    }

    public static void registerDrinkDataForItem(ResourceLocation location, FoodJsonHolder drinkData) {
        DataMaps.Server.consummableItem.put(location, drinkData);
    }

    public static void registerDrinkDataForPotion(ResourceLocation location, PotionJsonHolder consummableData) {
        DataMaps.Server.potionDrink.put(location, consummableData);
    }

    public static void registerArmorTemperatures(ResourceLocation location, ArmorJsonHolder armorData) {
        DataMaps.Server.armor.put(location, armorData);
    }

    public static void registerBlockTemperatures(ResourceLocation location, BlockTemperatureJsonHolder drinkData) {
        DataMaps.Server.blockTemperature.put(location, drinkData);
    }

    public static void registerEntityTemperatures(ResourceLocation location, EntityTemperatureJsonHolder drinkData) {
        DataMaps.Server.entityTemperature.put(location, drinkData);
    }

    public static void registerBiomeTemperatures(ResourceLocation location, BiomeJsonHolder biomeData) {
        DataMaps.Server.biome.put(location, biomeData);
    }

    public void debug(Object message) {
        if (Survive.CONFIG.debugMode) {
            this.getLogger().debug(message);
        }
    }

    public void clientRegistries(FMLClientSetupEvent event) {
        event.enqueueWork(() -> SItemProperties.registerAll());
    }

    public static ItemStack convertToPlayerStatusBook(ItemStack stack) {
        ItemStack result = new ItemStack((ItemLike)Items.f_42615_);
        if (stack.m_41783_() != null) {
            result.m_41751_(stack.m_41783_().m_6426_());
        }
        result.m_41700_("status_owner", (Tag)StringTag.m_129297_((String)""));
        result.m_41783_().m_128405_("generation", 0);
        return result;
    }

    public void registerServerRelaodableResources(ReloadListeners reloadListener) {
        reloadListener.listenTo((ReloadListener)consummableReloader);
        reloadListener.listenTo((ReloadListener)potionReloader);
        reloadListener.listenTo((ReloadListener)armorReloader);
        reloadListener.listenTo((ReloadListener)blockReloader);
        reloadListener.listenTo((ReloadListener)biomeReloader);
        reloadListener.listenTo((ReloadListener)entityReloader);
        reloadListener.listenTo((ReloadListener)fluidReloader);
    }

    public void registerCreativeTabs(CreativeTabBuilder builder) {
        builder.addTab("main_tab", SCreativeModeTab.TAB_MAIN);
    }

    public void populateCreativeTabs(CreativeTabPopulator populator) {
        if (populator.getTab().m_40786_().equals(SCreativeModeTab.TAB_MAIN.m_40786_()) && Survive.HYGIENE_CONFIG.enabled) {
            populator.addItems(new Item[]{HygieneItems.BATH_SPONGE});
            populator.addItems(new Item[]{HygieneItems.WHITE_WASHCLOTH});
            populator.addItems(new Item[]{HygieneItems.ORANGE_WASHCLOTH});
            populator.addItems(new Item[]{HygieneItems.MAGENTA_WASHCLOTH});
            populator.addItems(new Item[]{HygieneItems.LIGHT_BLUE_WASHCLOTH});
            populator.addItems(new Item[]{HygieneItems.YELLOW_WASHCLOTH});
            populator.addItems(new Item[]{HygieneItems.LIME_WASHCLOTH});
            populator.addItems(new Item[]{HygieneItems.PINK_WASHCLOTH});
            populator.addItems(new Item[]{HygieneItems.GRAY_WASHCLOTH});
            populator.addItems(new Item[]{HygieneItems.LIGHT_GRAY_WASHCLOTH});
            populator.addItems(new Item[]{HygieneItems.CYAN_WASHCLOTH});
            populator.addItems(new Item[]{HygieneItems.PURPLE_WASHCLOTH});
            populator.addItems(new Item[]{HygieneItems.BLUE_WASHCLOTH});
            populator.addItems(new Item[]{HygieneItems.BROWN_WASHCLOTH});
            populator.addItems(new Item[]{HygieneItems.GREEN_WASHCLOTH});
            populator.addItems(new Item[]{HygieneItems.RED_WASHCLOTH});
            populator.addItems(new Item[]{HygieneItems.BLACK_WASHCLOTH});
            populator.addItems(new Item[]{HygieneItems.WOOD_ASH});
            populator.addItems(new Item[]{HygieneItems.POTASH_SOLUTION});
            populator.addItems(new Item[]{HygieneItems.POTASH});
            populator.addItems(new Item[]{HygieneItems.ANIMAL_FAT});
            populator.addItems(new Item[]{HygieneItems.SOAP_MIX});
            populator.addItems(new Item[]{HygieneItems.SOAP_BOTTLE});
        }
        if (populator.getTab().m_40786_().equals(SCreativeModeTab.TAB_MAIN.m_40786_())) {
            populator.addItems(new Item[]{SItems.WOOL_HAT});
            populator.addItems(new Item[]{SItems.WOOL_JACKET});
            populator.addItems(new Item[]{SItems.WOOL_PANTS});
            populator.addItems(new Item[]{SItems.WOOL_BOOTS});
            populator.addItems(new Item[]{SItems.STIFFENED_HONEY_HELMET});
            populator.addItems(new Item[]{SItems.STIFFENED_HONEY_CHESTPLATE});
            populator.addItems(new Item[]{SItems.STIFFENED_HONEY_LEGGINGS});
            populator.addItems(new Item[]{SItems.STIFFENED_HONEY_BOOTS});
            populator.addItems(new Item[]{SItems.CANTEEN});
            for (Potion potion : RegistryHelper.potions()) {
                if (potion == Potions.f_43598_) continue;
                populator.getOutput().m_246342_(CanteenItem.addToCanteen(new ItemStack((ItemLike)SItems.FILLED_CANTEEN), Survive.THIRST_CONFIG.canteen_fill_amount, potion));
            }
            populator.addItems(new Item[]{SItems.WATER_BOWL});
            populator.addItems(new Item[]{SItems.PURIFIED_WATER_BOWL});
            populator.addItems(new Item[]{SItems.ICE_CUBE});
            populator.addItems(new Item[]{SItems.THERMOMETER});
            populator.addItems(new Item[]{SItems.TEMPERATURE_REGULATOR});
            populator.addItems(new Item[]{SItems.LARGE_HEATING_PLATE});
            populator.addItems(new Item[]{SItems.LARGE_COOLING_PLATE});
            populator.addItems(new Item[]{SItems.MEDIUM_HEATING_PLATE});
            populator.addItems(new Item[]{SItems.MEDIUM_COOLING_PLATE});
            populator.addItems(new Item[]{SItems.SMALL_HEATING_PLATE});
            populator.addItems(new Item[]{SItems.SMALL_COOLING_PLATE});
            populator.addItems(new Item[]{SItems.CHARCOAL_FILTER});
            populator.addItems(new Item[]{SItems.PURIFIED_WATER_BUCKET});
            populator.addItems(new Item[]{SItems.MAGMA_PASTE});
        }
    }

    public static List<String> defaultDimensionMods() {
        ArrayList<String> dims = new ArrayList<String>();
        dims.add("minecraft:overworld,0.0");
        dims.add("minecraft:the_nether,0.0");
        dims.add("minecraft:the_end,0.0");
        return dims;
    }

    public static Survive getInstance() {
        return instance;
    }

    static {
        CONFIG = new Config();
        STAMINA_CONFIG = new StaminaConfig();
        HYGIENE_CONFIG = new HygieneConfig();
        TEMPERATURE_CONFIG = new TemperatureConfig();
        THIRST_CONFIG = new ThirstConfig();
        WELLBEING_CONFIG = new WellbeingConfig();
        consummableReloader = new ItemConsummableDataManager();
        potionReloader = new PotionDrinkDataManager();
        armorReloader = new ArmorDataManager();
        blockReloader = new BlockDataManager();
        biomeReloader = new BiomeDataManager();
        entityReloader = new EntityTemperatureDataManager();
        fluidReloader = new FluidDataManager();
    }
}

