/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive;

import com.mojang.blaze3d.systems.RenderSystem;
import com.stereowalker.survive.Survive;
import com.stereowalker.survive.core.SurviveEntityStats;
import com.stereowalker.survive.core.TempDisplayMode;
import com.stereowalker.survive.needs.IRealisticEntity;
import com.stereowalker.survive.needs.IRoastedEntity;
import com.stereowalker.survive.world.effect.SMobEffects;
import com.stereowalker.unionlib.api.collectors.OverlayCollector;
import com.stereowalker.unionlib.api.gui.GuiRenderer;
import com.stereowalker.unionlib.client.gui.screens.config.MinecraftModConfigsScreen;
import com.stereowalker.unionlib.config.ConfigObject;
import com.stereowalker.unionlib.mod.ClientSegment;
import com.stereowalker.unionlib.util.ScreenHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class SurviveClientSegment
extends ClientSegment {
    public static final ResourceLocation GUI_ICONS = new ResourceLocation("survive", "textures/gui/icons.png");

    public ResourceLocation getModIcon() {
        return new ResourceLocation("survive", "textures/icon.png");
    }

    public Screen getConfigScreen(Minecraft mc, Screen previousScreen) {
        return new MinecraftModConfigsScreen(previousScreen, (Component)Component.m_237115_((String)"gui.survive.config.title"), new ConfigObject[]{Survive.HYGIENE_CONFIG, Survive.STAMINA_CONFIG, Survive.TEMPERATURE_CONFIG, Survive.THIRST_CONFIG, Survive.WELLBEING_CONFIG, Survive.CONFIG});
    }

    public void setupGuiOverlays(OverlayCollector collector) {
        collector.register("tired", OverlayCollector.Order.END, (gui, renderer, width, height) -> {
            if (!Survive.CONFIG.tired_overlay && gui.f_92986_.f_91074_.m_21023_(SMobEffects.TIREDNESS)) {
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.disableDepthTest();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.setShader(GameRenderer::m_172817_);
                SurviveClientSegment.renderTiredOverlay(gui, renderer);
            }
        });
        collector.register("heat_stroke", OverlayCollector.Order.END, (gui, renderer, width, height) -> {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableDepthTest();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShader(GameRenderer::m_172817_);
            SurviveClientSegment.renderHeatStroke(gui, renderer);
        });
        collector.register("temperature", OverlayCollector.Order.END, (gui, renderer, width, height) -> {
            if (!gui.f_92986_.f_91066_.f_92062_ && Survive.TEMPERATURE_CONFIG.enabled && !Survive.TEMPERATURE_CONFIG.tempDisplayMode.equals((Object)TempDisplayMode.HOTBAR)) {
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.disableDepthTest();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.setShader(GameRenderer::m_172817_);
                SurviveClientSegment.renderTemperature(gui, ScreenHelper.ScreenOffset.TOP, gui.m_93092_(), renderer, true);
            }
        });
    }

    public static void renderTemperature(Gui gui, ScreenHelper.ScreenOffset position, Player playerentity, GuiRenderer renderer, boolean forgeOverlay) {
        int x = ScreenHelper.getXOffset((ScreenHelper.ScreenOffset)position, (Minecraft)gui.f_92986_) + Survive.TEMPERATURE_CONFIG.tempXLoc;
        int y = ScreenHelper.getYOffset((ScreenHelper.ScreenOffset)position, (Minecraft)gui.f_92986_) + Survive.TEMPERATURE_CONFIG.tempYLoc;
        Minecraft.m_91087_().m_91307_().m_6180_("temperature");
        double displayTemp = SurviveEntityStats.getTemperatureStats((LivingEntity)playerentity).getDisplayTemperature();
        String s = SurviveEntityStats.getTemperatureStats((LivingEntity)playerentity).getCelcius() + " \u00b0C";
        if (Minecraft.m_91087_().f_91072_.m_105288_()) {
            if (Survive.TEMPERATURE_CONFIG.tempDisplayMode.equals((Object)TempDisplayMode.HORIZONTAL_BAR)) {
                if (Survive.TEMPERATURE_CONFIG.tempEffects && displayTemp >= 1.0) {
                    renderer.blit(GUI_ICONS, x - 3, y - 3, 0, 79, 138, 11);
                } else if (Survive.TEMPERATURE_CONFIG.tempEffects && displayTemp <= -1.0) {
                    renderer.blit(GUI_ICONS, x - 3, y - 3, 0, 90, 138, 11);
                } else {
                    renderer.blit(GUI_ICONS, x, y, 3, 64, 132, 5);
                    renderer.blit(GUI_ICONS, x, y, 3, 69, 132, 5);
                }
                renderer.blit(GUI_ICONS, x + Mth.m_14107_((double)(displayTemp * 44.0)) + 63 + (displayTemp > 0.0 ? 1 : 0), y, 1, 74, 4, 5);
            } else if (Survive.TEMPERATURE_CONFIG.tempDisplayMode.equals((Object)TempDisplayMode.VERTICAL_BAR)) {
                if (Survive.TEMPERATURE_CONFIG.tempEffects && displayTemp >= 1.0) {
                    renderer.blit(GUI_ICONS, x - 3, y - 3, 11, 101, 11, 138);
                } else if (Survive.TEMPERATURE_CONFIG.tempEffects && displayTemp <= -1.0) {
                    renderer.blit(GUI_ICONS, x - 3, y - 3, 0, 101, 11, 138);
                } else {
                    renderer.blit(GUI_ICONS, x, y, 32, 104, 5, 132);
                    renderer.blit(GUI_ICONS, x, y, 27, 104, 5, 132);
                }
                renderer.blit(GUI_ICONS, x, y - Mth.m_14107_((double)(displayTemp * 44.0)) + 63 - (displayTemp > 0.0 ? 1 : 0), 22, 104, 5, 5);
            } else if (Survive.TEMPERATURE_CONFIG.tempDisplayMode.equals((Object)TempDisplayMode.NUMBERS)) {
                if (Survive.TEMPERATURE_CONFIG.displayTempInFahrenheit) {
                    s = SurviveEntityStats.getTemperatureStats((LivingEntity)playerentity).getFahrenheit() + " \u00b0F";
                }
                if (displayTemp >= 1.0) {
                    renderer.drawString(s, x, y, ChatFormatting.GOLD.m_126665_().intValue(), false);
                } else if (displayTemp <= -1.0) {
                    renderer.drawString(s, x, y, ChatFormatting.BLUE.m_126665_().intValue(), false);
                } else {
                    renderer.drawString(s, x, y, ChatFormatting.GRAY.m_126665_().intValue(), false);
                }
            }
        }
        if (Survive.CONFIG.nutrition_enabled && (playerentity.m_21205_().m_41614_() || playerentity.m_21206_().m_41614_())) {
            renderer.drawString("Carbs = " + ((IRealisticEntity)playerentity).getNutritionData().getCarbLevel(), 0, 0, ChatFormatting.GRAY.m_126665_().intValue(), false);
            renderer.drawString("Protein = " + ((IRealisticEntity)playerentity).getNutritionData().getProteinLevel(), 0, 10, ChatFormatting.GRAY.m_126665_().intValue(), false);
        }
        Minecraft.m_91087_().m_91307_().m_7238_();
    }

    public static void renderHeatStroke(Gui gui, GuiRenderer renderer) {
        if (((IRoastedEntity)gui.f_92986_.f_91074_).getTicksRoasted() > 0) {
            gui.m_280155_(renderer.guiGraphics(), Survive.getInstance().location("textures/misc/burning_overlay.png"), ((IRoastedEntity)gui.f_92986_.f_91074_).getPercentRoasted());
        }
    }

    public static void renderTiredOverlay(Gui gui, GuiRenderer graphics) {
        Minecraft.m_91087_().m_91307_().m_6180_("tired");
        int amplifier = Minecraft.m_91087_().f_91074_.m_21124_(SMobEffects.TIREDNESS).m_19564_() + 1;
        amplifier /= Survive.CONFIG.tiredTimeStacks / 5;
        amplifier = Mth.m_14045_((int)amplifier, (int)0, (int)4);
        gui.m_280155_(graphics.guiGraphics(), Survive.getInstance().location("textures/misc/sleep_overlay_" + amplifier + ".png"), 0.5f);
        Minecraft.m_91087_().m_91307_().m_7238_();
    }
}

