/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.core;

import com.stereowalker.survive.Survive;
import com.stereowalker.survive.needs.HygieneData;
import com.stereowalker.survive.needs.SleepData;
import com.stereowalker.survive.needs.StaminaData;
import com.stereowalker.survive.needs.TemperatureData;
import com.stereowalker.survive.needs.WaterData;
import com.stereowalker.survive.world.entity.ai.attributes.SAttributes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;

public class SurviveEntityStats {
    public static String waterStatsID = "WaterStats";
    public static String temperatureStatsID = "TemperatureStats";
    public static String energyStatsID = "EnergyStats";
    public static String hygieneStatsID = "HygieneStats";
    public static String sleepStatsID = "SleepStats";

    public static WaterData getWaterStats(LivingEntity entity) {
        WaterData stats = new WaterData();
        if (entity != null && SurviveEntityStats.getModNBT((Entity)entity) != null && SurviveEntityStats.getModNBT((Entity)entity).m_128425_(waterStatsID, 10)) {
            stats.read(SurviveEntityStats.getModNBT((Entity)entity).m_128469_(waterStatsID));
            return stats;
        }
        return stats;
    }

    public static StaminaData getEnergyStats(LivingEntity entity) {
        StaminaData stats = new StaminaData(entity.m_21133_(SAttributes.MAX_STAMINA));
        if (entity != null && SurviveEntityStats.getModNBT((Entity)entity) != null && SurviveEntityStats.getModNBT((Entity)entity).m_128425_(energyStatsID, 10)) {
            stats.read(SurviveEntityStats.getModNBT((Entity)entity).m_128469_(energyStatsID));
            return stats;
        }
        return stats;
    }

    public static TemperatureData getTemperatureStats(LivingEntity entity) {
        TemperatureData stats = new TemperatureData();
        if (entity != null && SurviveEntityStats.getModNBT((Entity)entity) != null && SurviveEntityStats.getModNBT((Entity)entity).m_128425_(temperatureStatsID, 10)) {
            stats.read(SurviveEntityStats.getModNBT((Entity)entity).m_128469_(temperatureStatsID));
            return stats;
        }
        return stats;
    }

    public static HygieneData getHygieneStats(LivingEntity entity) {
        HygieneData stats = new HygieneData();
        if (entity != null && SurviveEntityStats.getModNBT((Entity)entity) != null && SurviveEntityStats.getModNBT((Entity)entity).m_128425_(hygieneStatsID, 10)) {
            stats.read(SurviveEntityStats.getModNBT((Entity)entity).m_128469_(hygieneStatsID));
            return stats;
        }
        return stats;
    }

    public static SleepData getSleepStats(LivingEntity entity) {
        SleepData stats = new SleepData();
        if (entity != null && SurviveEntityStats.getModNBT((Entity)entity) != null && SurviveEntityStats.getModNBT((Entity)entity).m_128425_(sleepStatsID, 10)) {
            stats.read(SurviveEntityStats.getModNBT((Entity)entity).m_128469_(sleepStatsID));
            return stats;
        }
        return stats;
    }

    public static int getWetTime(LivingEntity entity) {
        if (SurviveEntityStats.getModNBT((Entity)entity) != null && SurviveEntityStats.getModNBT((Entity)entity).m_128441_(SurviveEntityStats.append("WetTime"))) {
            return SurviveEntityStats.getModNBT((Entity)entity).m_128451_(SurviveEntityStats.append("WetTime"));
        }
        return 0;
    }

    public static void setWaterStats(LivingEntity entity, WaterData waterStats) {
        CompoundTag compound2 = new CompoundTag();
        waterStats.write(compound2);
        SurviveEntityStats.getModNBT((Entity)entity).m_128365_(waterStatsID, (Tag)compound2);
    }

    public static void setStaminaStats(LivingEntity entity, StaminaData energyStats) {
        CompoundTag compound2 = new CompoundTag();
        energyStats.write(compound2);
        SurviveEntityStats.getModNBT((Entity)entity).m_128365_(energyStatsID, (Tag)compound2);
    }

    public static void setTemperatureStats(Entity entity, TemperatureData temperatureStats) {
        CompoundTag compound2 = new CompoundTag();
        temperatureStats.write(compound2);
        SurviveEntityStats.getModNBT(entity).m_128365_(temperatureStatsID, (Tag)compound2);
    }

    public static void setHygieneStats(LivingEntity entity, HygieneData hygieneStats) {
        CompoundTag compound2 = new CompoundTag();
        hygieneStats.write(compound2);
        SurviveEntityStats.getModNBT((Entity)entity).m_128365_(hygieneStatsID, (Tag)compound2);
    }

    public static void setSleepStats(LivingEntity entity, SleepData sleepStats) {
        CompoundTag compound2 = new CompoundTag();
        sleepStats.write(compound2);
        SurviveEntityStats.getModNBT((Entity)entity).m_128365_(sleepStatsID, (Tag)compound2);
    }

    public static void setWetTime(LivingEntity entity, int wetTime) {
        SurviveEntityStats.getModNBT((Entity)entity).m_128405_(SurviveEntityStats.append("WetTime"), wetTime);
    }

    public static boolean addWetTime(LivingEntity entity, int wetTime) {
        CompoundTag compound = entity.getPersistentData();
        if (compound != null) {
            SurviveEntityStats.setWetTime(entity, SurviveEntityStats.getWetTime(entity) + wetTime);
            if (SurviveEntityStats.getWetTime(entity) < 0) {
                SurviveEntityStats.setWetTime(entity, 0);
            }
            if (SurviveEntityStats.getWetTime(entity) > 3600) {
                SurviveEntityStats.setWetTime(entity, 3600);
            }
            return true;
        }
        return false;
    }

    public static void addStatsOnSpawn(ItemFrame frame) {
        if (frame != null) {
            CompoundTag compound = SurviveEntityStats.getOrCreateModNBT((Entity)frame);
            if (frame.m_6084_() && !compound.m_128441_(temperatureStatsID)) {
                SurviveEntityStats.setTemperatureStats((Entity)frame, new TemperatureData());
            }
        }
    }

    public static void addStatsOnSpawn(Player player) {
        if (player != null) {
            CompoundTag compound = SurviveEntityStats.getOrCreateModNBT((Entity)player);
            String name = player.m_6302_();
            if (player.m_6084_()) {
                if (!compound.m_128441_(waterStatsID)) {
                    SurviveEntityStats.setWaterStats((LivingEntity)player, new WaterData());
                }
                if (!compound.m_128441_(energyStatsID)) {
                    SurviveEntityStats.setStaminaStats((LivingEntity)player, new StaminaData(player.m_21133_(SAttributes.MAX_STAMINA)));
                }
                if (!compound.m_128441_(temperatureStatsID)) {
                    SurviveEntityStats.setTemperatureStats((Entity)player, new TemperatureData());
                }
                if (!compound.m_128441_(hygieneStatsID)) {
                    SurviveEntityStats.setHygieneStats((LivingEntity)player, new HygieneData());
                }
                if (!compound.m_128441_(sleepStatsID)) {
                    SurviveEntityStats.setSleepStats((LivingEntity)player, new SleepData());
                }
                if (!compound.m_128441_(SurviveEntityStats.append("WetTime"))) {
                    SurviveEntityStats.setWetTime((LivingEntity)player, 0);
                    Survive.getInstance().debug("Set " + name + "'s wet time to " + SurviveEntityStats.getWetTime((LivingEntity)player));
                }
            }
        }
    }

    private static String append(String string) {
        return "survive:" + string;
    }

    public static String getModDataString() {
        return "survive:PlayerData";
    }

    public static CompoundTag getModNBT(Entity entity) {
        return entity.getPersistentData().m_128469_(SurviveEntityStats.getModDataString());
    }

    public static CompoundTag getOrCreateModNBT(Entity entity) {
        if (!entity.getPersistentData().m_128425_(SurviveEntityStats.getModDataString(), 10)) {
            entity.getPersistentData().m_128365_(SurviveEntityStats.getModDataString(), (Tag)new CompoundTag());
        }
        return entity.getPersistentData().m_128469_(SurviveEntityStats.getModDataString());
    }

    public static void setModNBT(CompoundTag nbt, Entity entity) {
        entity.getPersistentData().m_128365_(SurviveEntityStats.getModDataString(), (Tag)nbt);
    }
}

