/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.core.registries;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.stereowalker.survive.Survive;
import com.stereowalker.survive.client.particle.HygieneParticle;
import com.stereowalker.survive.core.particles.SParticleTypes;
import com.stereowalker.survive.core.registries.SurviveRegistries;
import com.stereowalker.survive.world.entity.ai.attributes.SAttributes;
import com.stereowalker.survive.world.item.SItems;
import com.stereowalker.survive.world.item.TemperatureRegulatorPlateItem;
import com.stereowalker.survive.world.item.alchemy.SPotions;
import com.stereowalker.survive.world.item.crafting.conditions.ModuleEnabledCondition;
import com.stereowalker.survive.world.level.block.PlatedTemperatureRegulatorBlock;
import com.stereowalker.survive.world.level.block.SBlocks;
import com.stereowalker.survive.world.level.material.PurifiedWaterFluid;
import com.stereowalker.survive.world.level.material.SFluids;
import com.stereowalker.survive.world.level.storage.loot.predicates.SLootItemConditions;
import com.stereowalker.survive.world.seasons.Season;
import com.stereowalker.survive.world.seasons.Seasons;
import com.stereowalker.survive.world.temperature.conditions.TemperatureChangeConditions;
import com.stereowalker.unionlib.util.RegistryHelper;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryBuilder;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class SurviveRegistryEvents {
    private static final int MAX_VARINT = 0x7FFFFFFE;

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void registerItemColors(RegisterColorHandlersEvent.Block event) {
        event.register((state, displayReader, blockPos, tintIndex) -> 4314104, new Block[]{SBlocks.PURIFIED_WATER, SBlocks.PURIFIED_WATER_CAULDRON});
        event.register((state, displayReader, blockPos, tintIndex) -> 4734005, new Block[]{SBlocks.POTASH_CAULDRON});
        event.register((state, displayReader, blockPos, tintIndex) -> PlatedTemperatureRegulatorBlock.getColor(state), new Block[]{SBlocks.PLATED_TEMPERATURE_REGULATOR});
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void registerItemColors(RegisterColorHandlersEvent.Item event) {
        event.register((stack, tintIndex) -> tintIndex > 0 ? -1 : (PotionUtils.m_43579_((ItemStack)stack) == SPotions.PURIFIED_WATER ? 4314104 : PotionUtils.m_43575_((ItemStack)stack)), new ItemLike[]{Items.f_42589_, Items.f_42736_, Items.f_42739_});
        event.register((stack, tintIndex) -> TemperatureRegulatorPlateItem.getColor(stack), new ItemLike[]{SItems.LARGE_HEATING_PLATE, SItems.LARGE_COOLING_PLATE, SItems.MEDIUM_HEATING_PLATE, SItems.MEDIUM_COOLING_PLATE, SItems.SMALL_HEATING_PLATE, SItems.SMALL_COOLING_PLATE});
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void registerParticleFactories(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)SParticleTypes.STINK, HygieneParticle.StinkFactory::new);
        event.registerSpriteSet((ParticleType)SParticleTypes.CLEAN, HygieneParticle.CleanFactory::new);
    }

    @SubscribeEvent
    public static void registerParticlesz(RegisterEvent event) {
        event.register(RegistryHelper.particleTypeKey(), helper -> SParticleTypes.registerAll(helper));
        event.register(RegistryHelper.potionKey(), helper -> SPotions.registerAll((RegisterEvent.RegisterHelper<Potion>)helper));
        event.register(SurviveRegistries.CONDITION, helper -> TemperatureChangeConditions.registerAll(helper));
        event.register(SurviveRegistries.SEASON, helper -> Seasons.registerAll((RegisterEvent.RegisterHelper<Season>)helper));
        event.register(ForgeRegistries.Keys.FLUID_TYPES, helper -> helper.register(new ResourceLocation("survive:purified_water"), (Object)PurifiedWaterFluid.TYPE));
        if (event.getRegistryKey().equals((Object)ForgeRegistries.Keys.RECIPE_SERIALIZERS)) {
            CraftingHelper.register((IConditionSerializer)ModuleEnabledCondition.Serializer.INSTANCE);
        }
        new SLootItemConditions();
        MobEffects.f_19607_.m_19472_(SAttributes.HEAT_RESISTANCE, "795606d6-4ac6-4ae7-8311-63ccdb293eb4", 5.0, AttributeModifier.Operation.ADDITION);
        Survive.POTION_FLUID_MAP = new ImmutableMap.Builder().put((Object)Potions.f_43599_, (Object)Lists.newArrayList((Object[])new Fluid[]{Fluids.f_76192_, Fluids.f_76193_})).put((Object)SPotions.PURIFIED_WATER, (Object)Lists.newArrayList((Object[])new Fluid[]{SFluids.FLOWING_PURIFIED_WATER, SFluids.PURIFIED_WATER})).build();
    }

    @SubscribeEvent
    public static void registerSurviveRegistries(NewRegistryEvent event) {
        event.create(new RegistryBuilder().setName(SurviveRegistries.CONDITION.m_135782_()).setMaxID(0x7FFFFFFE));
        event.create(new RegistryBuilder().setName(Survive.getInstance().location("season")).setMaxID(0x7FFFFFFE));
    }
}

