/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.events;

import com.mojang.datafixers.util.Pair;
import com.stereowalker.survive.FoodUtils;
import com.stereowalker.survive.Survive;
import com.stereowalker.survive.api.IBlockPropertyHandler;
import com.stereowalker.survive.api.json.JsonHolder;
import com.stereowalker.survive.api.world.level.block.TemperatureEmitter;
import com.stereowalker.survive.compat.SereneSeasonsCompat;
import com.stereowalker.survive.config.ServerConfig;
import com.stereowalker.survive.core.SurviveEntityStats;
import com.stereowalker.survive.core.TempMode;
import com.stereowalker.survive.json.BiomeJsonHolder;
import com.stereowalker.survive.json.BlockTemperatureJsonHolder;
import com.stereowalker.survive.json.EntityTemperatureJsonHolder;
import com.stereowalker.survive.json.FluidJsonHolder;
import com.stereowalker.survive.needs.IRealisticEntity;
import com.stereowalker.survive.needs.SleepData;
import com.stereowalker.survive.needs.TemperatureData;
import com.stereowalker.survive.needs.TemperatureUtil;
import com.stereowalker.survive.network.protocol.game.ClientboundDataTransferPacket;
import com.stereowalker.survive.network.protocol.game.ClientboundSurvivalStatsPacket;
import com.stereowalker.survive.network.protocol.game.ServerboundInteractWithWaterPacket;
import com.stereowalker.survive.world.DataMaps;
import com.stereowalker.survive.world.effect.SMobEffects;
import com.stereowalker.survive.world.entity.ai.attributes.SAttributes;
import com.stereowalker.survive.world.item.enchantment.SEnchantmentHelper;
import com.stereowalker.survive.world.seasons.Season;
import com.stereowalker.survive.world.temperature.TemperatureModifier;
import com.stereowalker.survive.world.temperature.TemperatureQuery;
import com.stereowalker.survive.world.temperature.conditions.TemperatureChangeInstance;
import com.stereowalker.unionlib.util.ModHelper;
import com.stereowalker.unionlib.util.RegistryHelper;
import com.stereowalker.unionlib.util.math.UnionMathHelper;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.SleepingTimeCheckEvent;
import net.minecraftforge.event.level.SleepFinishedTimeEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.tuple.Triple;

@Mod.EventBusSubscriber
public class SurviveEvents {
    @SubscribeEvent
    public static void allowSleep(SleepingTimeCheckEvent event) {
        if (Survive.CONFIG.enable_sleep && event.getEntity() instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            if (SurviveEntityStats.getSleepStats((LivingEntity)player).getAwakeTimer() > SurviveEvents.time(0) - 5000 && Survive.CONFIG.canSleepDuringDay) {
                event.setResult(Event.Result.ALLOW);
            } else if ((double)SurviveEntityStats.getEnergyStats((LivingEntity)player).getEnergyLevel() < player.m_21133_(SAttributes.MAX_STAMINA) / 2.0) {
                event.setResult(Event.Result.ALLOW);
            }
        }
    }

    public static int time(int i) {
        return Survive.CONFIG.initialTiredTime + Survive.CONFIG.tiredTimeStep * i;
    }

    @SubscribeEvent
    public static void manageSleep(SleepFinishedTimeEvent event) {
        for (Player player : event.getLevel().m_6907_()) {
            SleepData stats = SurviveEntityStats.getSleepStats((LivingEntity)player);
            stats.setAwakeTimer(0);
            stats.save((LivingEntity)player);
        }
    }

    public static void desyncClient(Player player) {
        if (!player.m_9236_().f_46443_ && DataMaps.Server.syncedClients.containsKey(player.m_20148_())) {
            Survive.getInstance().getLogger().info("Removing Client (" + player.m_5446_().getString() + ") From Survive Data Sync List");
            DataMaps.Server.syncedClients.put(player.m_20148_(), false);
        }
    }

    public static void sendToClient(LivingEntity living) {
        if (living != null && !living.m_9236_().f_46443_ && living instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)living;
            new ClientboundSurvivalStatsPacket(player).send(player);
            if (!DataMaps.Server.syncedClients.containsKey(player.m_20148_())) {
                DataMaps.Server.syncedClients.put(player.m_20148_(), false);
            }
            if (!DataMaps.Server.syncedClients.get(player.m_20148_()).booleanValue()) {
                Survive.getInstance().getLogger().info("Syncing All Data To Client (" + player.m_5446_().getString() + ")");
                Survive.getInstance().getLogger().info("Syncing Armor Data");
                MutableInt a = new MutableInt(0);
                DataMaps.Server.armor.forEach((key, value) -> {
                    new ClientboundDataTransferPacket((ResourceLocation)key, (JsonHolder)value, a.getValue() == 0).send(player);
                    a.increment();
                });
                Survive.getInstance().getLogger().info("Done with Armors");
                Survive.getInstance().getLogger().info("Syncing Fluid Data");
                MutableInt f = new MutableInt(0);
                DataMaps.Server.fluid.forEach((key, value) -> {
                    new ClientboundDataTransferPacket((ResourceLocation)key, (JsonHolder)value, f.getValue() == 0).send(player);
                    f.increment();
                });
                Survive.getInstance().getLogger().info("Done with Fluids");
                Survive.getInstance().getLogger().info("Syncing Biome Data");
                MutableInt i = new MutableInt(0);
                DataMaps.Server.biome.forEach((key, value) -> {
                    new ClientboundDataTransferPacket((ResourceLocation)key, (JsonHolder)value, i.getValue() == 0).send(player);
                    i.increment();
                });
                Survive.getInstance().getLogger().info("Done syncing " + i + " biomes");
                DataMaps.Server.syncedClients.put(player.m_20148_(), true);
            }
        }
    }

    public static boolean isSnowingAt(Level world, BlockPos position) {
        if (!world.m_46471_()) {
            return false;
        }
        if (!world.m_45527_(position)) {
            return false;
        }
        if (world.m_5452_(Heightmap.Types.MOTION_BLOCKING, position).m_123342_() > position.m_123342_()) {
            return false;
        }
        Biome biome = (Biome)world.m_204166_(position).m_203334_();
        return biome.m_264600_(position) == Biome.Precipitation.SNOW || biome.m_47505_(position) <= 0.15f || ModHelper.isPrimalWinterLoaded() || ModHelper.isSereneSeasonsLoaded() && SereneSeasonsCompat.snowsHere(world, position);
    }

    public static void updateEnvTemperature(LivingEntity living) {
        ServerPlayer player;
        if (living != null && living instanceof ServerPlayer) {
            player = (ServerPlayer)living;
            if (!living.m_9236_().f_46443_) {
                SurviveEntityStats.addWetTime((LivingEntity)player, player.m_5842_() ? 2 : (player.m_20070_() ? 1 : -2));
            }
        }
        if (living != null && living instanceof ServerPlayer && (player = (ServerPlayer)living).m_6084_()) {
            for (ResourceLocation queryId : TemperatureQuery.queries.keySet()) {
                double queryValue = ((TemperatureQuery)TemperatureQuery.queries.get(queryId).m_14418_()).run((Player)player, SurviveEntityStats.getTemperatureStats((LivingEntity)player).getTemperatureLevel(), player.m_9236_(), player.m_20183_(), true);
                TemperatureData.setTemperatureModifier((LivingEntity)player, queryId, queryValue, (TemperatureModifier.ContributingFactor)((Object)TemperatureQuery.queries.get(queryId).m_14419_()));
            }
        }
        if (living instanceof Player) {
            player = (Player)living;
            FoodUtils.giveLifespanToFood((NonNullList<ItemStack>)player.m_150109_().f_35974_, player.m_9236_().m_46467_());
        }
    }

    public static float getModifierFromSlot(EquipmentSlot slot) {
        switch (slot) {
            case HEAD: {
                return 0.05f;
            }
            case CHEST: {
                return 0.16f;
            }
            case LEGS: {
                return 0.13f;
            }
            case FEET: {
                return 0.06f;
            }
        }
        return 0.0f;
    }

    public static double getExactTemperature(Level world, BlockPos pos, TempType type) {
        float skyLight = world.m_7726_().m_7827_().m_75814_(LightLayer.SKY).m_7768_(pos);
        float gameTime = world.m_46468_() % 24000L;
        gameTime /= 66.0f;
        gameTime = (float)Math.sin(Math.toRadians(gameTime));
        switch (type) {
            case SUN: {
                float sunIntensity = 5.0f;
                if (world.m_204166_(pos).m_203543_().isPresent() && DataMaps.Server.biome.containsKey(((ResourceKey)world.m_204166_(pos).m_203543_().get()).m_135782_())) {
                    sunIntensity = DataMaps.Server.biome.get(((ResourceKey)world.m_204166_(pos).m_203543_().get()).m_135782_()).getSunIntensity();
                }
                if (skyLight > 5.0f) {
                    return gameTime * sunIntensity;
                }
                return -1.0f * sunIntensity;
            }
            case BIOME: {
                float biomeTemp = TemperatureUtil.getTemperature((Holder<Biome>)world.m_204166_(pos), pos) * 2.0f - 2.0f;
                if (ModHelper.isPrimalWinterLoaded()) {
                    biomeTemp = -0.7f;
                }
                return biomeTemp;
            }
            case BLOCK: {
                float totalBlockTemp = 0.0f;
                int rangeInBlocks = 5;
                for (int x = -rangeInBlocks; x <= rangeInBlocks; ++x) {
                    for (int y = -rangeInBlocks; y <= rangeInBlocks; ++y) {
                        for (int z = -rangeInBlocks; z <= rangeInBlocks; ++z) {
                            float sourceRange;
                            float blockTemp = 0.0f;
                            BlockPos heatSource = new BlockPos(pos.m_123341_() + x, pos.m_123342_() + y, pos.m_123343_() + z);
                            float blockLight = world.m_7726_().m_7827_().m_75814_(LightLayer.BLOCK).m_7768_(heatSource);
                            BlockState heatState = world.m_8055_(heatSource);
                            if (heatState.m_60734_() instanceof TemperatureEmitter) {
                                sourceRange = ((TemperatureEmitter)heatState.m_60734_()).getModificationRange(heatState);
                            } else {
                                float f = sourceRange = DataMaps.Server.blockTemperature.containsKey(RegistryHelper.blocks().m_7981_((Object)heatState.m_60734_())) ? (float)DataMaps.Server.blockTemperature.get(RegistryHelper.blocks().m_7981_((Object)heatState.m_60734_())).getRange() : 5.0f;
                            }
                            if (!pos.m_123314_((Vec3i)heatSource, (double)sourceRange)) continue;
                            blockTemp += blockLight / 500.0f;
                            if (heatState.m_60734_() instanceof TemperatureEmitter) {
                                blockTemp = ((TemperatureEmitter)heatState.m_60734_()).getTemperatureModification(heatState);
                            } else if (DataMaps.Server.blockTemperature.containsKey(RegistryHelper.blocks().m_7981_((Object)heatState.m_60734_()))) {
                                BlockTemperatureJsonHolder blockTemperatureData = DataMaps.Server.blockTemperature.get(RegistryHelper.blocks().m_7981_((Object)heatState.m_60734_()));
                                if (blockTemperatureData.getStateChangeProperty() != null) {
                                    boolean setTemp = false;
                                    List<Triple<IBlockPropertyHandler<?>, List<IBlockPropertyHandler.PropertyPair<?>>, Map<String, Float>>> changeProperty = blockTemperatureData.getStateChangeProperty();
                                    block10: for (Triple<IBlockPropertyHandler<?>, List<IBlockPropertyHandler.PropertyPair<?>>, Map<String, Float>> handler : changeProperty) {
                                        boolean meets = true;
                                        for (IBlockPropertyHandler.PropertyPair requirements : (List)handler.getMiddle()) {
                                            if (heatState.m_61143_((Property)requirements.getFirst()).equals(requirements.getSecond())) continue;
                                            meets = false;
                                            break;
                                        }
                                        if (!meets) continue;
                                        for (String prop2 : ((Map)handler.getRight()).keySet()) {
                                            if (!heatState.m_61143_(((IBlockPropertyHandler)handler.getLeft()).derivedProperty()).equals(((IBlockPropertyHandler)handler.getLeft()).getValue(prop2))) continue;
                                            blockTemp += ((Float)((Map)handler.getRight()).get(prop2)).floatValue();
                                            setTemp = true;
                                            break block10;
                                        }
                                    }
                                    if (!setTemp) {
                                        blockTemp += blockTemperatureData.getTemperatureModifier();
                                    }
                                } else {
                                    blockTemp += blockTemperatureData.getTemperatureModifier();
                                    if (blockTemperatureData.usesLevelProperty()) {
                                        if (heatState.m_61138_((Property)BlockStateProperties.f_61422_)) {
                                            blockTemp *= (float)(((Integer)heatState.m_61143_((Property)BlockStateProperties.f_61422_) + 1) / 16);
                                        } else if (heatState.m_61138_((Property)BlockStateProperties.f_61419_)) {
                                            blockTemp *= (float)(((Integer)heatState.m_61143_((Property)BlockStateProperties.f_61419_) + 1) / 9);
                                        } else if (heatState.m_61138_((Property)BlockStateProperties.f_61420_)) {
                                            blockTemp *= (float)((Integer)heatState.m_61143_((Property)BlockStateProperties.f_61420_) / 8);
                                        } else if (heatState.m_61138_((Property)BlockStateProperties.f_61418_)) {
                                            blockTemp *= (float)(((Integer)heatState.m_61143_((Property)BlockStateProperties.f_61418_) + 1) / 4);
                                        }
                                    }
                                }
                            }
                            totalBlockTemp += blockTemp;
                        }
                    }
                }
                return totalBlockTemp;
            }
            case SHADE: {
                return skyLight / 7.5f - 1.0f;
            }
            case ENTITY: {
                float totalEntityTemp = 0.0f;
                int rangeInBlocks = 5;
                for (Entity entity : world.m_45976_(Entity.class, new AABB(pos.m_7918_(rangeInBlocks, rangeInBlocks, rangeInBlocks), pos.m_7918_(-rangeInBlocks, -rangeInBlocks, -rangeInBlocks)))) {
                    float sourceRange;
                    float f = sourceRange = DataMaps.Server.entityTemperature.containsKey(RegistryHelper.entityTypes().m_7981_((Object)entity.m_6095_())) ? DataMaps.Server.entityTemperature.get(RegistryHelper.entityTypes().m_7981_((Object)entity.m_6095_())).getRange() : 5.0f;
                    if (!pos.m_123314_((Vec3i)entity.m_20183_(), (double)sourceRange) || !DataMaps.Server.entityTemperature.containsKey(RegistryHelper.entityTypes().m_7981_((Object)entity.m_6095_()))) continue;
                    EntityTemperatureJsonHolder entityTemperatureData = DataMaps.Server.entityTemperature.get(RegistryHelper.entityTypes().m_7981_((Object)entity.m_6095_()));
                    totalEntityTemp += entityTemperatureData.getTemperatureModifier();
                }
                return totalEntityTemp;
            }
        }
        return 37.0;
    }

    public static double getBlendedTemperature(Level world, BlockPos mainPos, BlockPos blendPos, TempType type) {
        float distance = (float)Math.sqrt(mainPos.m_123331_((Vec3i)blendPos));
        if ((double)distance <= 5.0) {
            float blendRatio0 = distance / 5.0f;
            float blendRatio1 = 1.0f - blendRatio0;
            double temp0 = SurviveEvents.getExactTemperature(world, blendPos, type);
            double temp1 = SurviveEvents.getExactTemperature(world, mainPos, type);
            return temp0 * (double)blendRatio0 + temp1 * (double)blendRatio1;
        }
        return SurviveEvents.getExactTemperature(world, mainPos, type);
    }

    public static float getAverageTemperature(Level world, BlockPos pos, TempType type, int rangeInBlocks, TempMode mode) {
        float temp = 0.0f;
        int tempAmount = 0;
        for (int x = -rangeInBlocks; x <= rangeInBlocks; ++x) {
            for (int y = -rangeInBlocks; y <= rangeInBlocks; ++y) {
                for (int z = -rangeInBlocks; z <= rangeInBlocks; ++z) {
                    if (mode == TempMode.BLEND) {
                        temp = (float)((double)temp + SurviveEvents.getBlendedTemperature(world, new BlockPos(pos.m_123341_() + x, pos.m_123342_() + y, pos.m_123343_() + z), pos, type));
                    } else if (mode == TempMode.NORMAL) {
                        temp = (float)((double)temp + SurviveEvents.getExactTemperature(world, new BlockPos(pos.m_123341_() + x, pos.m_123342_() + y, pos.m_123343_() + z), type));
                    }
                    ++tempAmount;
                }
            }
        }
        return temp / (float)tempAmount;
    }

    @SubscribeEvent
    public static void interactWithWaterSourceBlock(PlayerInteractEvent.RightClickEmpty event) {
        HitResult raytraceresult = SurviveEvents.rayTrace(event.getLevel(), (LivingEntity)event.getEntity(), ClipContext.Fluid.SOURCE_ONLY);
        BlockPos blockpos = ((BlockHitResult)raytraceresult).m_82425_();
        if (event.getLevel().f_46443_ && event.getItemStack().m_41619_() && event.getHand() == InteractionHand.MAIN_HAND) {
            Fluid fluid = event.getLevel().m_6425_(blockpos).m_76152_();
            if (DataMaps.Client.fluid.containsKey((Object)RegistryHelper.fluids().m_7981_((Object)fluid))) {
                BiomeJsonHolder biomeData;
                FluidJsonHolder fluidHolder = (FluidJsonHolder)DataMaps.Client.fluid.get((Object)RegistryHelper.fluids().m_7981_((Object)fluid));
                float thirstChance = fluidHolder.getThirstChance();
                if (DataMaps.Client.biome.containsKey((Object)((ResourceKey)event.getLevel().m_204166_(blockpos).m_203543_().get()).m_135782_()) && (biomeData = (BiomeJsonHolder)DataMaps.Client.biome.get((Object)((ResourceKey)event.getLevel().m_204166_(blockpos).m_203543_().get()).m_135782_())).getThirstChance() >= 0.0f) {
                    thirstChance = biomeData.getThirstChance();
                }
                new ServerboundInteractWithWaterPacket(blockpos, thirstChance, fluidHolder.getThirstAmount(), fluidHolder.getHydrationAmount(), event.getHand()).send();
            }
            if (event.getLevel().m_46758_(blockpos)) {
                new ServerboundInteractWithWaterPacket(event.getPos(), 0.0f, 1.0, 0.5, event.getHand()).send();
            }
        }
    }

    @SubscribeEvent
    public static void interactWithWaterSourceBlock(PlayerInteractEvent.RightClickBlock event) {
        HitResult raytraceresult = SurviveEvents.rayTrace(event.getLevel(), (LivingEntity)event.getEntity(), ClipContext.Fluid.SOURCE_ONLY);
        BlockPos blockpos = ((BlockHitResult)raytraceresult).m_82425_();
        BlockState state = event.getLevel().m_8055_(event.getPos());
        Fluid fluid = event.getLevel().m_6425_(blockpos).m_76152_();
        BlockState stateUnder = event.getLevel().m_8055_(event.getPos().m_7495_());
        if (event.getLevel().f_46443_ && ServerboundInteractWithWaterPacket.isValidStack(event.getItemStack())) {
            int i;
            if (DataMaps.Client.fluid.containsKey((Object)RegistryHelper.fluids().m_7981_((Object)fluid))) {
                FluidJsonHolder fluidHolder = (FluidJsonHolder)DataMaps.Client.fluid.get((Object)RegistryHelper.fluids().m_7981_((Object)fluid));
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
                new ServerboundInteractWithWaterPacket(blockpos, fluidHolder.getThirstChance(), fluidHolder.getThirstAmount(), fluidHolder.getHydrationAmount(), event.getHand()).send();
            }
            if (state.m_60734_() == Blocks.f_152476_ && (i = ((Integer)state.m_61143_((Property)LayeredCauldronBlock.f_153514_)).intValue()) > 0) {
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
                if (stateUnder.m_60734_() == Blocks.f_50683_ && ((Boolean)stateUnder.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) {
                    new ServerboundInteractWithWaterPacket(event.getPos(), 0.0f, 4.0, event.getHand()).send();
                } else {
                    new ServerboundInteractWithWaterPacket(event.getPos(), 0.5f, 4.0, event.getHand()).send();
                }
            }
        }
    }

    protected static HitResult rayTrace(Level worldIn, LivingEntity player, ClipContext.Fluid fluidMode) {
        float f = player.m_146909_();
        float f1 = player.m_146908_();
        Vec3 vec3d = player.m_20299_(1.0f);
        float f2 = Mth.m_14089_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.m_14031_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.m_14089_((float)(-f * ((float)Math.PI / 180)));
        float f5 = Mth.m_14031_((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d0 = player.m_21051_((Attribute)ForgeMod.BLOCK_REACH.get()).m_22135_();
        Vec3 vec3d1 = vec3d.m_82520_((double)f6 * d0, (double)f5 * d0, (double)f7 * d0);
        return worldIn.m_45547_(new ClipContext(vec3d, vec3d1, ClipContext.Block.OUTLINE, fluidMode, (Entity)player));
    }

    public static void restoreStats(Player thisPlayer, Player thatPlayer, boolean keepEverything) {
        SurviveEntityStats.getOrCreateModNBT((Entity)thisPlayer);
        if (keepEverything) {
            IRealisticEntity entity = (IRealisticEntity)thisPlayer;
            IRealisticEntity original = (IRealisticEntity)thatPlayer;
            entity.setNutritionData(original.getNutritionData());
            entity.setWellbeingData(original.getWellbeingData());
            SurviveEntityStats.setHygieneStats((LivingEntity)thisPlayer, SurviveEntityStats.getHygieneStats((LivingEntity)thatPlayer));
            SurviveEntityStats.setWaterStats((LivingEntity)thisPlayer, original.getWaterData());
            SurviveEntityStats.setStaminaStats((LivingEntity)thisPlayer, SurviveEntityStats.getEnergyStats((LivingEntity)thatPlayer));
            SurviveEntityStats.setTemperatureStats((Entity)thisPlayer, SurviveEntityStats.getTemperatureStats((LivingEntity)thatPlayer));
            SurviveEntityStats.setSleepStats((LivingEntity)thisPlayer, SurviveEntityStats.getSleepStats((LivingEntity)thatPlayer));
            SurviveEntityStats.setWetTime((LivingEntity)thisPlayer, SurviveEntityStats.getWetTime((LivingEntity)thatPlayer));
        }
    }

    public static void addReload(LevelAccessor lvl) {
        System.out.println("Start Resistering Temperature Queries");
        for (TempType type : TempType.values()) {
            TemperatureQuery.registerQuery("survive:" + type.getName(), TemperatureModifier.ContributingFactor.ENVIRONMENTAL, (player, temp, level, pos, applyTemp) -> {
                double temperature = type.isUsingExact() ? SurviveEvents.getExactTemperature(level, pos, type) : (double)SurviveEvents.getAverageTemperature(level, pos, type, 5, Survive.TEMPERATURE_CONFIG.tempMode);
                return UnionMathHelper.roundDecimal((int)3, (double)(temperature / type.getReductionAmount()));
            });
        }
        TemperatureQuery.registerQuery("survive:snow", TemperatureModifier.ContributingFactor.ENVIRONMENTAL, (player, temp, level, pos, applyTemp) -> {
            double snow = 0.0;
            if (SurviveEvents.isSnowingAt(level, pos)) {
                snow = -2.0;
            }
            return snow;
        });
        TemperatureQuery.registerQuery("survive:season", TemperatureModifier.ContributingFactor.ENVIRONMENTAL, (player, temp, level, pos, applyTemp) -> {
            float seasonMod = 0.0f;
            if (ModHelper.isSereneSeasonsLoaded()) {
                Season season = SereneSeasonsCompat.modifyTemperatureBySeason(level, pos);
                seasonMod = level.m_204166_(pos).m_203543_().isPresent() && DataMaps.Server.biome.containsKey(((ResourceKey)level.m_204166_(pos).m_203543_().get()).m_135782_()) ? DataMaps.Server.biome.get(((ResourceKey)level.m_204166_(pos).m_203543_().get()).m_135782_()).getSeasonModifiers().get(season).floatValue() : season.getModifier();
                if (ModHelper.isPrimalWinterLoaded()) {
                    seasonMod = -1.0f;
                }
            }
            return seasonMod;
        });
        TemperatureQuery.registerQuery("survive:dimension", TemperatureModifier.ContributingFactor.ENVIRONMENTAL, (player, temp, level, pos, applyTemp) -> {
            for (String dimensionList : ServerConfig.dimensionModifiers) {
                String[] dimension = dimensionList.split(",");
                ResourceLocation loc = new ResourceLocation(dimension[0]);
                if (!RegistryHelper.matchesRegistryKey((ResourceLocation)loc, (ResourceKey)level.m_46472_())) continue;
                return Float.parseFloat(dimension[1]);
            }
            return 0.0;
        });
        TemperatureQuery.registerQuery("survive:wetness", TemperatureModifier.ContributingFactor.INTERNAL, (player, temp, level, pos, applyTemp) -> {
            if (level.m_204166_(pos).m_203543_().isPresent() && DataMaps.Server.biome.containsKey(((ResourceKey)level.m_204166_(pos).m_203543_().get()).m_135782_())) {
                float f = DataMaps.Server.biome.get(((ResourceKey)level.m_204166_(pos).m_203543_().get()).m_135782_()).getWetnessModifier();
                return (double)SurviveEntityStats.getWetTime((LivingEntity)player) / -1800.0 * (double)f;
            }
            return (double)SurviveEntityStats.getWetTime((LivingEntity)player) / -1800.0;
        });
        TemperatureQuery.registerQuery("survive:cooling_enchantment", TemperatureModifier.ContributingFactor.INTERNAL, (player, temp, level, pos, applyTemp) -> {
            double coolingMod = 0.0;
            coolingMod -= 0.05 * (double)SEnchantmentHelper.getCoolingModifier(player.m_6844_(EquipmentSlot.HEAD));
            coolingMod -= 0.16 * (double)SEnchantmentHelper.getCoolingModifier(player.m_6844_(EquipmentSlot.CHEST));
            coolingMod -= 0.13 * (double)SEnchantmentHelper.getCoolingModifier(player.m_6844_(EquipmentSlot.LEGS));
            return coolingMod -= 0.06 * (double)SEnchantmentHelper.getCoolingModifier(player.m_6844_(EquipmentSlot.FEET));
        });
        TemperatureQuery.registerQuery("survive:warming_enchantment", TemperatureModifier.ContributingFactor.INTERNAL, (player, temp, level, pos, applyTemp) -> {
            double warmingMod = 0.0;
            warmingMod += 0.05 * (double)SEnchantmentHelper.getWarmingModifier(player.m_6844_(EquipmentSlot.HEAD));
            warmingMod += 0.16 * (double)SEnchantmentHelper.getWarmingModifier(player.m_6844_(EquipmentSlot.CHEST));
            warmingMod += 0.13 * (double)SEnchantmentHelper.getWarmingModifier(player.m_6844_(EquipmentSlot.LEGS));
            return warmingMod += 0.06 * (double)SEnchantmentHelper.getWarmingModifier(player.m_6844_(EquipmentSlot.FEET));
        });
        TemperatureQuery.registerQuery("survive:thirst_cooldown", TemperatureModifier.ContributingFactor.INTERNAL, (player, temp, level, pos, applyTemp) -> {
            if (((IRealisticEntity)player).getWaterData().shouldTempDrop()) {
                if (applyTemp) {
                    ((IRealisticEntity)player).getWaterData().applyTempDrop(player);
                }
                return 1.0;
            }
            return 0.0;
        });
        TemperatureQuery.registerQuery("survive:adjusted_cooling_enchantment", TemperatureModifier.ContributingFactor.INTERNAL, (player, temp, level, pos, applyTemp) -> {
            boolean shouldCool = false;
            if (temp > 37.0) {
                for (EquipmentSlot types : EquipmentSlot.values()) {
                    if (!SEnchantmentHelper.hasAdjustedCooling(player.m_6844_(types))) continue;
                    shouldCool = true;
                }
            }
            return shouldCool ? -2.0 : 0.0;
        });
        TemperatureQuery.registerQuery("survive:adjusted_warming_enchantment", TemperatureModifier.ContributingFactor.INTERNAL, (player, temp, level, pos, applyTemp) -> {
            boolean shouldWarm = false;
            if (temp < 37.0) {
                for (EquipmentSlot types : EquipmentSlot.values()) {
                    if (!SEnchantmentHelper.hasAdjustedWarming(player.m_6844_(types))) continue;
                    shouldWarm = true;
                }
            }
            return shouldWarm ? 2.0 : 0.0;
        });
        TemperatureQuery.registerQuery("survive:armor", TemperatureModifier.ContributingFactor.INTERNAL, (player, temp, level, pos, applyTemp) -> {
            double armorMod = 0.0;
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                if (slot.m_20743_() != EquipmentSlot.Type.ARMOR || player.m_6844_(slot).m_41619_()) continue;
                Item armor = player.m_6844_(slot).m_41720_();
                float modifier = 1.0f;
                if (DataMaps.Server.armor.containsKey(RegistryHelper.items().m_7981_((Object)armor))) {
                    for (Pair<String, TemperatureChangeInstance> instance : DataMaps.Server.armor.get(RegistryHelper.items().m_7981_((Object)armor)).getTemperatureModifier()) {
                        if (!((TemperatureChangeInstance)instance.getSecond()).shouldChangeTemperature(player)) continue;
                        modifier = ((TemperatureChangeInstance)instance.getSecond()).getTemperature();
                        break;
                    }
                }
                armorMod += (double)(SurviveEvents.getModifierFromSlot(slot) * modifier);
            }
            return armorMod;
        });
        TemperatureQuery.registerQuery("survive:chilled_effect", TemperatureModifier.ContributingFactor.INTERNAL, (player, temp, level, pos, applyTemp) -> {
            if (player.m_21023_(SMobEffects.CHILLED)) {
                return -(0.05f * (float)(player.m_21124_(SMobEffects.CHILLED).m_19564_() + 1));
            }
            return 0.0;
        });
        TemperatureQuery.registerQuery("survive:heated_effect", TemperatureModifier.ContributingFactor.INTERNAL, (player, temp, level, pos, applyTemp) -> {
            if (player.m_21023_(SMobEffects.HEATED)) {
                return 0.05f * (float)(player.m_21124_(SMobEffects.HEATED).m_19564_() + 1);
            }
            return 0.0;
        });
        TemperatureQuery.registerQuery("survive:main_held_item", TemperatureModifier.ContributingFactor.INTERNAL, (player, temp, level, pos, applyTemp) -> {
            if (player.m_21205_().m_41720_() == Items.f_42000_ && DataMaps.Server.blockTemperature.containsKey(RegistryHelper.blocks().m_7981_((Object)Blocks.f_50081_))) {
                return DataMaps.Server.blockTemperature.get(RegistryHelper.blocks().m_7981_((Object)Blocks.f_50081_)).getTemperatureModifier();
            }
            return 0.0;
        });
        TemperatureQuery.registerQuery("survive:off_held_item", TemperatureModifier.ContributingFactor.INTERNAL, (player, temp, level, pos, applyTemp) -> {
            if (player.m_21206_().m_41720_() == Items.f_42000_ && DataMaps.Server.blockTemperature.containsKey(RegistryHelper.blocks().m_7981_((Object)Blocks.f_50081_))) {
                return DataMaps.Server.blockTemperature.get(RegistryHelper.blocks().m_7981_((Object)Blocks.f_50081_)).getTemperatureModifier();
            }
            return 0.0;
        });
        System.out.println("Done Resistering Temperature Queries");
    }

    private static enum TempType {
        BIOME("biome", 7.0, false),
        BLOCK("block", 9.0, true),
        ENTITY("entity", 9.0, true),
        SHADE("shade", 200.0, true),
        SUN("sun", 200.0, true);

        String name;
        double reductionAmount;
        boolean usingExact;

        private TempType(String name, double reductionAmountIn, boolean usingExactIn) {
            this.reductionAmount = reductionAmountIn;
            this.usingExact = usingExactIn;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public double getReductionAmount() {
            return this.reductionAmount;
        }

        public boolean isUsingExact() {
            return this.usingExact;
        }
    }
}

