/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.json;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.stereowalker.survive.Survive;
import com.stereowalker.survive.api.json.JsonHolder;
import com.stereowalker.survive.core.registries.SurviveRegistries;
import com.stereowalker.survive.world.temperature.conditions.TemperatureChangeCondition;
import com.stereowalker.survive.world.temperature.conditions.TemperatureChangeInstance;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class ArmorJsonHolder
implements JsonHolder {
    private static final Marker ARMOR_DATA = MarkerManager.getMarker((String)"ARMOR_DATA");
    private ResourceLocation itemID;
    private final List<Pair<String, TemperatureChangeInstance>> temperatureModifier;
    private final float weightModifier;
    String wo = "NOTHING";

    public ArmorJsonHolder(CompoundTag nbt) {
        this.itemID = new ResourceLocation(nbt.m_128461_("id"));
        this.weightModifier = nbt.m_128457_("weight_modifier");
        this.temperatureModifier = Lists.newArrayList();
        nbt.m_128437_("temperature_modifiers", 10).forEach(comp -> {
            CompoundTag nbt2 = (CompoundTag)comp;
            this.temperatureModifier.add((Pair<String, TemperatureChangeInstance>)Pair.of((Object)nbt2.m_128461_("condition"), ((TemperatureChangeCondition)SurviveRegistries.ForgeRegistry.CONDITION.getValue(new ResourceLocation(nbt2.m_128461_("condition")))).createInstance(nbt2.m_128469_("contents"))));
        });
    }

    public ArmorJsonHolder(ResourceLocation itemID, JsonObject object) {
        ArrayList temperatureModifierIn = Lists.newArrayList();
        float weightModifierIn = 0.0f;
        this.itemID = itemID;
        if (object.entrySet().size() != 0) {
            try {
                if (this.hasMemberAndIsJsonArray("temperature_modifiers", object)) {
                    this.setWorkingOn("temperature_modifiers");
                    for (JsonElement elem : object.get("temperature_modifiers").getAsJsonArray()) {
                        if (elem.isJsonObject()) {
                            JsonObject object2 = elem.getAsJsonObject();
                            TemperatureChangeCondition condition = null;
                            if (object2 == null || object2.entrySet().size() == 0 || !object2.has("condition") || !object2.get("condition").isJsonPrimitive()) continue;
                            this.setWorkingOn("condition");
                            condition = (TemperatureChangeCondition)SurviveRegistries.ForgeRegistry.CONDITION.getValue(new ResourceLocation(object2.get("condition").getAsString()));
                            if (condition != null) {
                                temperatureModifierIn.add(Pair.of((Object)object2.get("condition").getAsString(), condition.createInstance(object2)));
                            } else {
                                Survive.getInstance().getLogger().error("Error loading armor data {} from JSON: The condition {} does not exist", (Object)itemID, (Object)new ResourceLocation(object2.get("condition").getAsString()));
                            }
                            this.stopWorking();
                            continue;
                        }
                        Survive.getInstance().getLogger().error("Error loading armor data {} from JSON: The conditions for {} aren't a json object", (Object)itemID, (Object)elem);
                    }
                    this.stopWorking();
                }
                if (object.has("weight_modifier") && object.get("weight_modifier").isJsonPrimitive()) {
                    weightModifierIn = this.workOnFloat("weight_modifier", object);
                }
            }
            catch (ClassCastException e) {
                Survive.getInstance().getLogger().warn(ARMOR_DATA, "Error loading armor data {} from JSON: Parsing element {}: element was wrong type!", (Object)itemID, (Object)this.getworkingOn());
            }
            catch (NumberFormatException e) {
                Survive.getInstance().getLogger().warn(ARMOR_DATA, "Error loading armor data {} from JSON: Parsing element {}: element was an invalid number!", (Object)itemID, (Object)this.getworkingOn());
            }
        }
        if (weightModifierIn < 0.0f) {
            Survive.getInstance().getLogger().warn(ARMOR_DATA, "Error loading armor data {} from JSON: Parsing element {}: weight is less than zero, please fix this!", (Object)itemID, (Object)"weight_modifier");
            weightModifierIn = 0.0f;
        }
        this.temperatureModifier = temperatureModifierIn;
        this.weightModifier = weightModifierIn;
    }

    public ResourceLocation getItemID() {
        return this.itemID;
    }

    public List<Pair<String, TemperatureChangeInstance>> getTemperatureModifier() {
        return this.temperatureModifier;
    }

    public float getWeightModifier() {
        return this.weightModifier;
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("id", this.itemID.toString());
        nbt.m_128350_("weight_modifier", this.weightModifier);
        ListTag list = new ListTag();
        this.temperatureModifier.forEach(mod -> {
            CompoundTag entry = new CompoundTag();
            entry.m_128359_("condition", (String)mod.getFirst());
            entry.m_128365_("contents", (Tag)((TemperatureChangeInstance)mod.getSecond()).serialize());
            list.add((Object)entry);
        });
        nbt.m_128365_("temperature_modifiers", (Tag)list);
        return nbt;
    }

    @Override
    public ArmorJsonHolder deserialize(CompoundTag input) {
        return new ArmorJsonHolder(input);
    }

    @Override
    public String getworkingOn() {
        return this.wo;
    }

    @Override
    public void setWorkingOn(String member) {
        this.wo = member;
    }
}

