/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.json;

import com.google.gson.JsonObject;
import com.stereowalker.survive.Survive;
import com.stereowalker.survive.api.json.JsonHolder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class ConsummableJsonHolder
implements JsonHolder {
    private static final Marker DRINK_DATA = MarkerManager.getMarker((String)"DRINK_DATA");
    private ResourceLocation itemID;
    private int thirstAmount;
    private float hydrationAmount;
    private float thirstChance;
    private int hungerAmount;
    private float saturationAmount;
    private float hungerChance;
    private int energyAmount;
    private int carbohydrateRatio;
    private int proteinRatio;
    private boolean isChilled;
    private boolean isHeated;
    private boolean isEnergizing;
    private boolean overwritesDefaultHunger;
    private boolean overwritesDefaultSaturation;
    private boolean overwritesDefaultHungerChance;
    String wo;

    public ConsummableJsonHolder(ResourceLocation itemID, JsonObject object) {
        block21: {
            this.thirstAmount = 0;
            this.hydrationAmount = 0.0f;
            this.thirstChance = 0.0f;
            this.hungerAmount = 0;
            this.saturationAmount = 0.0f;
            this.hungerChance = 0.0f;
            this.energyAmount = 0;
            this.carbohydrateRatio = 1;
            this.proteinRatio = 1;
            this.isChilled = false;
            this.isHeated = false;
            this.isEnergizing = false;
            this.overwritesDefaultHunger = false;
            this.overwritesDefaultSaturation = false;
            this.overwritesDefaultHungerChance = false;
            this.wo = "NOTHING";
            String THIRST = "thirst";
            String HUNGER = "hunger";
            String ENERGY = "energy";
            String SATURATION = "saturation";
            String HUNGERY = "hunger_chance";
            String CHILLED = "gives_chilled_effect";
            String HEATED = "gives_heated_effect";
            String ENERGIZING = "gives_energizing_effect";
            String NUTRITION = "nutrition";
            this.itemID = itemID;
            if (object.entrySet().size() != 0) {
                this.stopWorking();
                try {
                    if (this.hasMemberAndIsPrimitive(THIRST, object)) {
                        this.setWorkingOn(THIRST);
                        this.thirstAmount = object.get(THIRST).getAsInt();
                        this.stopWorking();
                    }
                    if (this.hasMemberAndIsPrimitive("hydration", object)) {
                        this.hydrationAmount = this.workOnFloat("hydration", object);
                        if (this.hydrationAmount > 4.0f) {
                            Survive.getInstance().getLogger().warn(DRINK_DATA, "Loading consummable data $s from JSON: Hydration should not be greater than 4.0", (Object)itemID);
                        }
                        if (this.hydrationAmount < 1.0f) {
                            Survive.getInstance().getLogger().warn(DRINK_DATA, "Loading consummable data $s from JSON: Hydration should not be less than 1.0", (Object)itemID);
                        }
                        this.hydrationAmount = Mth.m_14036_((float)this.hydrationAmount, (float)1.0f, (float)4.0f);
                    }
                    this.thirstChance = this.workOnFloat("thirst_chance", object);
                    if (this.hasMemberAndIsPrimitive(HUNGER, object)) {
                        this.setWorkingOn(HUNGER);
                        this.hungerAmount = object.get(HUNGER).getAsInt();
                        this.overwritesDefaultHunger = true;
                        this.stopWorking();
                    }
                    if (this.hasMemberAndIsPrimitive(SATURATION, object)) {
                        this.setWorkingOn(SATURATION);
                        this.saturationAmount = object.get(SATURATION).getAsFloat();
                        this.overwritesDefaultSaturation = true;
                        this.stopWorking();
                    }
                    if (this.hasMemberAndIsPrimitive(HUNGERY, object)) {
                        this.setWorkingOn(HUNGERY);
                        this.hungerChance = object.get(HUNGERY).getAsFloat();
                        this.overwritesDefaultHungerChance = true;
                        this.stopWorking();
                    }
                    if (this.hasMemberAndIsPrimitive(ENERGY, object)) {
                        this.setWorkingOn(ENERGY);
                        this.energyAmount = object.get(ENERGY).getAsInt();
                        this.stopWorking();
                    }
                    if (this.hasMemberAndIsPrimitive(CHILLED, object)) {
                        this.setWorkingOn(CHILLED);
                        this.isChilled = object.get(CHILLED).getAsBoolean();
                        this.stopWorking();
                    }
                    if (this.hasMemberAndIsPrimitive(HEATED, object)) {
                        this.setWorkingOn(HEATED);
                        this.isHeated = object.get(HEATED).getAsBoolean();
                        this.stopWorking();
                    }
                    if (this.hasMemberAndIsPrimitive(ENERGIZING, object)) {
                        this.setWorkingOn(ENERGIZING);
                        this.isEnergizing = object.get(ENERGIZING).getAsBoolean();
                        this.stopWorking();
                    }
                    if (!this.hasMemberAndIsObject(NUTRITION, object)) break block21;
                    this.setWorkingOn(NUTRITION);
                    JsonObject object2 = object.get(NUTRITION).getAsJsonObject();
                    String CARB_RATIO = "carbohydrate_ratio";
                    String PROTEIN_RATIO = "protein_ratio";
                    if (object2.entrySet().size() != 0) {
                        try {
                            if (this.hasMemberAndIsPrimitive(CARB_RATIO, object2)) {
                                this.setWorkingOn(CARB_RATIO);
                                this.carbohydrateRatio = object.get(CARB_RATIO).getAsInt();
                                this.stopWorking();
                            }
                            if (this.hasMemberAndIsPrimitive(PROTEIN_RATIO, object2)) {
                                this.setWorkingOn(PROTEIN_RATIO);
                                this.proteinRatio = object.get(PROTEIN_RATIO).getAsInt();
                                this.stopWorking();
                            }
                        }
                        catch (ClassCastException e) {
                            Survive.getInstance().getLogger().warn(DRINK_DATA, "Loading drink data $s from JSON: Parsing element %s: element was wrong type!", (Object)e, (Object)itemID, (Object)this.getworkingOn());
                        }
                        catch (NumberFormatException e) {
                            Survive.getInstance().getLogger().warn(DRINK_DATA, "Loading drink data $s from JSON: Parsing element %s: element was an invalid number!", (Object)e, (Object)itemID, (Object)this.getworkingOn());
                        }
                    }
                    this.stopWorking();
                }
                catch (ClassCastException e) {
                    Survive.getInstance().getLogger().warn(DRINK_DATA, "Loading drink data $s from JSON: Parsing element %s: element was wrong type!", (Object)e, (Object)itemID, (Object)this.getworkingOn());
                }
                catch (NumberFormatException e) {
                    Survive.getInstance().getLogger().warn(DRINK_DATA, "Loading drink data $s from JSON: Parsing element %s: element was an invalid number!", (Object)e, (Object)itemID, (Object)this.getworkingOn());
                }
            }
        }
    }

    public ResourceLocation getItemID() {
        return this.itemID;
    }

    public int getThirstAmount() {
        return this.thirstAmount;
    }

    public float getHydrationAmount() {
        return this.hydrationAmount;
    }

    public float getThirstChance() {
        return this.thirstChance;
    }

    public boolean isChilled() {
        return this.isChilled;
    }

    public boolean isHeated() {
        return this.isHeated;
    }

    public boolean isEnergizing() {
        return this.isEnergizing;
    }

    public int getHungerAmount() {
        return this.hungerAmount;
    }

    public float getSaturationAmount() {
        return this.saturationAmount;
    }

    public float getHungerChance() {
        return this.hungerChance;
    }

    public boolean overwritesDefaultHunger() {
        return this.overwritesDefaultHunger;
    }

    public boolean overwritesDefaultSaturation() {
        return this.overwritesDefaultSaturation;
    }

    public boolean overwritesDefaultHungerChance() {
        return this.overwritesDefaultHungerChance;
    }

    public boolean overwritesDefaultFood() {
        return this.overwritesDefaultHunger || this.overwritesDefaultHungerChance || this.overwritesDefaultSaturation;
    }

    public int getEnergyAmount() {
        return this.energyAmount;
    }

    public int getCarbohydrateRatio() {
        return this.carbohydrateRatio;
    }

    public int getProteinRatio() {
        return this.proteinRatio;
    }

    @Override
    public CompoundTag serialize() {
        return null;
    }

    @Override
    public String getworkingOn() {
        return this.wo;
    }

    @Override
    public void setWorkingOn(String member) {
        this.wo = member;
    }

    @Override
    public JsonHolder deserialize(CompoundTag input) {
        return null;
    }
}

