/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.json;

import com.google.gson.JsonObject;
import com.stereowalker.survive.Survive;
import com.stereowalker.survive.json.ConsummableJsonHolder;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class FoodJsonHolder
extends ConsummableJsonHolder {
    private static final Marker MARKER = MarkerManager.getMarker((String)"FOOD_DRINK_DATA");
    private int timeFresh = 12000;
    private int lifespan = 156000;

    public FoodJsonHolder(ResourceLocation itemID, JsonObject object) {
        super(itemID, object);
        if (object.entrySet().size() != 0) {
            this.stopWorking();
            try {
                this.lifespan = this.workOnIntIfAvailable("lifespan", object, 0);
                this.timeFresh = this.workOnIntIfAvailable("ticks_fresh", object, 0);
                this.stopWorking();
            }
            catch (ClassCastException e) {
                Survive.getInstance().getLogger().warn(MARKER, "Loading food & drink data $s from JSON: Parsing element %s: element was wrong type!", (Object)e, (Object)itemID, (Object)this.getworkingOn());
            }
            catch (NumberFormatException e) {
                Survive.getInstance().getLogger().warn(MARKER, "Loading food & drink data $s from JSON: Parsing element %s: element was an invalid number!", (Object)e, (Object)itemID, (Object)this.getworkingOn());
            }
        }
    }

    public int lifespan() {
        return this.lifespan + this.timeFresh;
    }

    public int ticksFresh() {
        return this.timeFresh;
    }
}

