/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.mixins;

import com.stereowalker.survive.Survive;
import com.stereowalker.survive.core.SurviveEntityStats;
import com.stereowalker.survive.damagesource.SDamageSources;
import com.stereowalker.survive.damagesource.SDamageTypes;
import com.stereowalker.survive.mixins.EntityMixin;
import com.stereowalker.survive.needs.IRealisticEntity;
import com.stereowalker.survive.needs.TemperatureData;
import com.stereowalker.survive.needs.TemperatureUtil;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends EntityMixin {
    public LivingEntityMixin(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Shadow
    public abstract ItemStack m_6844_(EquipmentSlot var1);

    @Shadow
    public boolean m_6469_(DamageSource pSource, float pAmount) {
        return false;
    }

    @Redirect(method={"aiStep"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"))
    public boolean aiStep_hurt_redirect(LivingEntity living, DamageSource pSource, float pAmount) {
        float amount = pAmount;
        if ((LivingEntity)this instanceof Player && !Survive.TEMPERATURE_CONFIG.useLegacyTemperatureSystem && Survive.TEMPERATURE_CONFIG.enabled) {
            double maxCold1 = TemperatureUtil.firstCold((Player)this);
            double maxCold2 = TemperatureUtil.secondCold((Player)this);
            double maxCold3 = TemperatureUtil.maxCold((Player)this);
            TemperatureData data = SurviveEntityStats.getTemperatureStats((LivingEntity)this);
            if (data.getTemperatureLevel() < maxCold1 && data.getTemperatureLevel() >= maxCold2) {
                amount *= 1.0f;
            } else if (data.getTemperatureLevel() < maxCold2 && data.getTemperatureLevel() >= maxCold3) {
                amount *= 10.0f;
            } else if (data.getTemperatureLevel() < maxCold3) {
                amount *= 100.0f;
            }
        }
        return living.m_6469_(this.m_269291_().m_269109_(), amount);
    }

    @Redirect(method={"aiStep"}, at=@At(value="FIELD", target="Lnet/minecraft/world/entity/LivingEntity;isInPowderSnow:Z"))
    public boolean aiStep_isInPowderSnow_redirect(LivingEntity living) {
        if ((LivingEntity)this instanceof Player && !Survive.TEMPERATURE_CONFIG.useLegacyTemperatureSystem && Survive.TEMPERATURE_CONFIG.enabled) {
            TemperatureData data = SurviveEntityStats.getTemperatureStats((LivingEntity)this);
            return data.getTemperatureLevel() < TemperatureUtil.firstCold((Player)this) || this.f_146808_;
        }
        return this.f_146808_;
    }

    @Inject(method={"aiStep"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getTicksFrozen()I")}, locals=LocalCapture.CAPTURE_FAILHARD)
    public void aiStep_inject_1(CallbackInfo ci) {
        int i = this.getTicksRoasted();
        if (this.canRoast() && (LivingEntity)this instanceof Player && !Survive.TEMPERATURE_CONFIG.useLegacyTemperatureSystem && Survive.TEMPERATURE_CONFIG.enabled) {
            this.setTicksRoasted(Math.min(this.getTicksRequiredToRoast(), i + 1));
        } else {
            this.setTicksRoasted(Math.max(0, i - 2));
        }
    }

    @Inject(method={"aiStep"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;tryAddFrost()V")}, locals=LocalCapture.CAPTURE_FAILHARD)
    public void aiStep_inject_2(CallbackInfo ci) {
        if (!this.m_9236_().f_46443_ && this.f_19797_ % 40 == 0 && this.isFullyRoasted() && this.canRoast()) {
            int j = this.m_6095_().m_204039_(EntityTypeTags.f_144295_) ? 5 : 1;
            float amount = j;
            if ((LivingEntity)this instanceof Player && !Survive.TEMPERATURE_CONFIG.useLegacyTemperatureSystem && Survive.TEMPERATURE_CONFIG.enabled) {
                double maxHeat1 = TemperatureUtil.firstHeat((Player)this);
                double maxHeat2 = TemperatureUtil.secondHeat((Player)this);
                double maxHeat3 = TemperatureUtil.maxHeat((Player)this);
                TemperatureData data = SurviveEntityStats.getTemperatureStats((LivingEntity)this);
                if (data.getTemperatureLevel() > maxHeat1 && data.getTemperatureLevel() <= maxHeat2) {
                    amount *= 1.0f;
                } else if (data.getTemperatureLevel() > maxHeat2 && data.getTemperatureLevel() <= maxHeat3) {
                    amount *= 10.0f;
                } else if (data.getTemperatureLevel() > maxHeat3) {
                    amount *= 100.0f;
                }
            }
            this.m_6469_(SDamageSources.source(this.m_9236_().m_9598_(), SDamageTypes.ROAST), amount);
        }
    }

    @Inject(method={"completeUsingItem"}, at={@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/world/item/ItemStack;copy()Lnet/minecraft/world/item/ItemStack;")}, locals=LocalCapture.CAPTURE_FAILHARD)
    public void completeUsingItem_inject(CallbackInfo ci, InteractionHand interactionhand, ItemStack copy) {
        if (!copy.m_41614_() && this instanceof IRealisticEntity) {
            ((IRealisticEntity)((Object)this)).drink(this.m_9236_(), copy);
        }
    }

    @Override
    @Overwrite
    public boolean m_142079_() {
        if (this.m_5833_()) {
            return false;
        }
        if ((LivingEntity)this instanceof Player && !Survive.TEMPERATURE_CONFIG.useLegacyTemperatureSystem && Survive.TEMPERATURE_CONFIG.enabled) {
            TemperatureData data = SurviveEntityStats.getTemperatureStats((LivingEntity)this);
            return data.getTemperatureLevel() < TemperatureUtil.firstCold((Player)this) && super.m_142079_();
        }
        boolean flag = !this.m_6844_(EquipmentSlot.HEAD).m_204117_(ItemTags.f_144320_) && !this.m_6844_(EquipmentSlot.CHEST).m_204117_(ItemTags.f_144320_) && !this.m_6844_(EquipmentSlot.LEGS).m_204117_(ItemTags.f_144320_) && !this.m_6844_(EquipmentSlot.FEET).m_204117_(ItemTags.f_144320_);
        return flag && super.m_142079_();
    }

    @Override
    public boolean canRoast() {
        if (this.m_5833_()) {
            return false;
        }
        if ((LivingEntity)this instanceof Player && !Survive.TEMPERATURE_CONFIG.useLegacyTemperatureSystem && Survive.TEMPERATURE_CONFIG.enabled) {
            TemperatureData data = SurviveEntityStats.getTemperatureStats((LivingEntity)this);
            return data.getTemperatureLevel() > TemperatureUtil.firstHeat((Player)this) && super.canRoast();
        }
        boolean flag = !this.m_6844_(EquipmentSlot.HEAD).m_204117_(ItemTags.f_144320_) && !this.m_6844_(EquipmentSlot.CHEST).m_204117_(ItemTags.f_144320_) && !this.m_6844_(EquipmentSlot.LEGS).m_204117_(ItemTags.f_144320_) && !this.m_6844_(EquipmentSlot.FEET).m_204117_(ItemTags.f_144320_);
        return flag && super.canRoast();
    }
}

