/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.mixins;

import com.stereowalker.survive.Survive;
import com.stereowalker.survive.core.SurviveEntityStats;
import com.stereowalker.survive.json.ConsummableJsonHolder;
import com.stereowalker.survive.needs.CustomFoodData;
import com.stereowalker.survive.needs.HygieneData;
import com.stereowalker.survive.needs.IRealisticEntity;
import com.stereowalker.survive.needs.NutritionData;
import com.stereowalker.survive.needs.SleepData;
import com.stereowalker.survive.needs.StaminaData;
import com.stereowalker.survive.needs.TemperatureData;
import com.stereowalker.survive.needs.WaterData;
import com.stereowalker.survive.needs.WellbeingData;
import com.stereowalker.survive.world.DataMaps;
import com.stereowalker.unionlib.util.RegistryHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class PlayerMixin
extends LivingEntity
implements IRealisticEntity {
    @Shadow
    protected FoodData f_36097_;
    @Shadow
    private int f_36110_;
    private WellbeingData wellbeingData = new WellbeingData();
    private NutritionData nutritionData = new NutritionData();

    protected PlayerMixin(EntityType<? extends LivingEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    public void initInject(CallbackInfo ci) {
        this.f_36097_ = new CustomFoodData(this.f_36097_);
    }

    @Inject(method={"eat"}, at={@At(value="HEAD")})
    public void eatInject(Level pLevel, ItemStack pFood, CallbackInfoReturnable<ItemStack> cir) {
        this.getStaminaData().eat(pFood.m_41720_(), pFood, this);
        this.getWaterData().drink(pFood.m_41720_(), pFood, this);
        this.getRealFoodData().markAsSpoiled(pFood, this);
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/world/entity/player/Player;updateIsUnderwater()Z")})
    public void tickInject(CallbackInfo ci) {
        SurviveEntityStats.addStatsOnSpawn((Player)this);
        if (!this.m_9236_().f_46443_ && (Player)this instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)this;
            if (Survive.THIRST_CONFIG.enabled) {
                if (player.m_9236_().m_46791_() == Difficulty.PEACEFUL && player.m_9236_().m_46469_().m_46207_(GameRules.f_46139_) && this.getWaterData().needWater() && player.f_19797_ % 10 == 0) {
                    this.getWaterData().setWaterLevel(this.getWaterData().getWaterLevel() + 1);
                }
                this.getWaterData().save((LivingEntity)player);
            }
        }
        if (!this.m_9236_().f_46443_) {
            this.getStaminaData().baseTick((Player)this);
            this.getHygieneData().baseTick((Player)this);
            this.nutritionData.baseTick((Player)this);
            this.getTemperatureData().baseTick((Player)this);
            this.getWaterData().baseTick((Player)this);
            this.wellbeingData.baseTick((Player)this);
            this.getSleepData().baseTick((Player)this);
        }
    }

    @Redirect(method={"canEat"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/food/FoodData;needsFood()Z"))
    public boolean makeEdible(FoodData foodData) {
        if (foodData instanceof CustomFoodData) {
            return ((CustomFoodData)foodData).canConsumeFood();
        }
        return foodData.m_38721_();
    }

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;causeFoodExhaustion(F)V"), method={"jumpFromGround", "actuallyHurt", "checkMovementStatistics"})
    public void morphExhaustion(Player player, float value) {
        if (Survive.STAMINA_CONFIG.enabled) {
            this.getStaminaData().addExhaustion(player, value * 2.5f, "Jumped, Got hurt or moved");
        } else if (Survive.CONFIG.nutrition_enabled) {
            this.nutritionData.removeCarbs(Mth.m_14167_((float)(value * 2.5f)));
        } else {
            player.m_36399_(value);
        }
    }

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;causeFoodExhaustion(F)V"), method={"attack"})
    public void morphStaminaDuringAttack(Player player, float value) {
        if (Survive.STAMINA_CONFIG.enabled) {
            this.getStaminaData().addExhaustion(player, 1.25f, "Player Attacked");
        } else if (Survive.CONFIG.nutrition_enabled) {
            this.nutritionData.removeCarbs(Mth.m_14167_((float)(value * 2.5f)));
        } else {
            player.m_36399_(value);
        }
    }

    @Inject(method={"eat"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/food/FoodData;eat(Lnet/minecraft/world/item/Item;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/entity/LivingEntity;)V")})
    public void addNutrients(Level arg0, ItemStack p_213357_2_, CallbackInfoReturnable<ItemStack> cir) {
        if (Survive.CONFIG.nutrition_enabled) {
            float protein = 1.0f;
            float carbs = 1.0f;
            if (DataMaps.Server.consummableItem.containsKey(RegistryHelper.items().m_7981_((Object)p_213357_2_.m_41720_()))) {
                ConsummableJsonHolder data = DataMaps.Server.consummableItem.get(RegistryHelper.items().m_7981_((Object)p_213357_2_.m_41720_()));
                protein = data.getProteinRatio();
                carbs = data.getCarbohydrateRatio();
            }
            FoodProperties food = p_213357_2_.m_41720_().m_41473_();
            float total = protein + carbs;
            this.nutritionData.addCarbs(food.m_38744_() * Mth.m_14167_((float)(carbs / total * 10.0f)));
            this.nutritionData.addProtein(food.m_38744_() * Mth.m_14167_((float)(protein / total * 10.0f)));
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    public void readAdditionalSaveData_inject(CompoundTag pCompound, CallbackInfo ci) {
        if (pCompound.m_128425_("surviveData", 10)) {
            this.wellbeingData.read(pCompound);
            this.nutritionData.read(pCompound);
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    public void addAdditionalSaveData_inject(CompoundTag pCompound, CallbackInfo ci) {
        if (!pCompound.m_128425_("surviveData", 10)) {
            pCompound.m_128365_("surviveData", (Tag)new CompoundTag());
        }
        this.wellbeingData.write(pCompound.m_128469_("surviveData"));
        this.nutritionData.write(pCompound.m_128469_("surviveData"));
    }

    @Override
    public StaminaData getStaminaData() {
        return SurviveEntityStats.getEnergyStats((LivingEntity)((Player)this));
    }

    @Override
    public HygieneData getHygieneData() {
        return SurviveEntityStats.getHygieneStats((LivingEntity)((Player)this));
    }

    @Override
    public NutritionData getNutritionData() {
        return this.nutritionData;
    }

    @Override
    public void setNutritionData(NutritionData data) {
        this.nutritionData = data;
    }

    @Override
    public TemperatureData getTemperatureData() {
        return SurviveEntityStats.getTemperatureStats((LivingEntity)((Player)this));
    }

    @Override
    public WaterData getWaterData() {
        return SurviveEntityStats.getWaterStats((LivingEntity)((Player)this));
    }

    @Override
    public WellbeingData getWellbeingData() {
        return this.wellbeingData;
    }

    @Override
    public void setWellbeingData(WellbeingData data) {
        this.wellbeingData = data;
    }

    @Override
    public SleepData getSleepData() {
        return SurviveEntityStats.getSleepStats((LivingEntity)((Player)this));
    }

    @Override
    public CustomFoodData getRealFoodData() {
        if (this.f_36097_ instanceof CustomFoodData) {
            return (CustomFoodData)this.f_36097_;
        }
        return null;
    }
}

