/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.mixins;

import com.stereowalker.survive.Survive;
import com.stereowalker.survive.core.SurviveEntityStats;
import com.stereowalker.survive.needs.StaminaData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ServerPlayerGameMode;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerPlayerGameMode.class})
public abstract class ServerPlayerGameModeMixin {
    @Inject(at={@At(value="RETURN")}, method={"useItemOn"})
    public void mixinBlockInteraction(ServerPlayer playerIn, Level worldIn, ItemStack stackIn, InteractionHand handIn, BlockHitResult blockRaytraceResultIn, CallbackInfoReturnable<InteractionResult> cir) {
        if (((InteractionResult)cir.getReturnValue()).m_19077_()) {
            StaminaData energyStats = SurviveEntityStats.getEnergyStats((LivingEntity)playerIn);
            energyStats.addExhaustion((Player)playerIn, Survive.STAMINA_CONFIG.stamina_drain_from_using_blocks, "used an item on something");
            SurviveEntityStats.setStaminaStats((LivingEntity)playerIn, energyStats);
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"useItem"})
    public void mixinItemInteraction(ServerPlayer player, Level worldIn, ItemStack stack, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        StaminaData energyStats = SurviveEntityStats.getEnergyStats((LivingEntity)player);
        energyStats.addExhaustion((Player)player, Survive.STAMINA_CONFIG.stamina_drain_from_items, "Used item in air");
        SurviveEntityStats.setStaminaStats((LivingEntity)player, energyStats);
    }
}

