/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.mixins;

import com.stereowalker.survive.Survive;
import com.stereowalker.survive.needs.IRealisticEntity;
import com.stereowalker.survive.network.protocol.game.ServerboundPlayerStatusBookPacket;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.WrittenBookItem;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WrittenBookItem.class})
public abstract class WrittenBookItemMixin
extends Item {
    private static final String TAG_STATUS_OWNER = "status_owner";

    public WrittenBookItemMixin(Item.Properties pProperties) {
        super(pProperties);
    }

    public void m_6883_(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        Player player;
        CompoundTag compoundtag;
        if (pIsSelected && (compoundtag = pStack.m_41783_()) != null && WrittenBookItem.m_43473_((ItemStack)pStack) == 0 && compoundtag.m_128441_(TAG_STATUS_OWNER) && pEntity instanceof Player && (player = (Player)pEntity) instanceof IRealisticEntity) {
            IRealisticEntity real = (IRealisticEntity)player;
            if (compoundtag.m_128461_(TAG_STATUS_OWNER).isEmpty()) {
                compoundtag.m_128359_(TAG_STATUS_OWNER, player.m_20149_());
            } else if (compoundtag.m_128461_(TAG_STATUS_OWNER).equals(player.m_20149_()) && pLevel.f_46443_) {
                this.sendPacket(compoundtag);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void sendPacket(CompoundTag tag) {
        new ServerboundPlayerStatusBookPacket(tag, !Survive.TEMPERATURE_CONFIG.displayTempInFahrenheit, I18n.m_118938_((String)"book.patient.sleep", (Object[])new Object[]{"%1$s"}), I18n.m_118938_((String)"book.patient.temperature", (Object[])new Object[]{"%1$s"})).send();
    }

    @Inject(method={"appendHoverText"}, at={@At(value="TAIL")})
    public void appendHoverText_inject(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltip, TooltipFlag pFlag, CallbackInfo ci) {
        CompoundTag compoundtag = pStack.m_41783_();
        if (compoundtag != null && compoundtag.m_128441_(TAG_STATUS_OWNER)) {
            String s = "";
            if (pLevel != null && !compoundtag.m_128461_(TAG_STATUS_OWNER).isEmpty()) {
                s = pLevel.m_46003_(UUID.fromString(compoundtag.m_128461_(TAG_STATUS_OWNER))).m_7755_().getString();
            }
            if (!StringUtil.m_14408_((String)s)) {
                pTooltip.add((Component)Component.m_237110_((String)"book.forPatient", (Object[])new Object[]{s}).m_130940_(ChatFormatting.GREEN));
            } else {
                pTooltip.add((Component)Component.m_237115_((String)"book.noPatient").m_130940_(ChatFormatting.GREEN));
            }
        }
    }
}

