/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.needs;

import com.mojang.datafixers.util.Pair;
import com.stereowalker.survive.FoodUtils;
import com.stereowalker.survive.Survive;
import com.stereowalker.survive.config.ServerConfig;
import com.stereowalker.survive.damagesource.SDamageSources;
import com.stereowalker.survive.damagesource.SDamageTypes;
import com.stereowalker.survive.needs.IRealisticEntity;
import com.stereowalker.survive.world.effect.SMobEffects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class CustomFoodData
extends FoodData {
    int uncleanConsumption = 0;
    boolean causeAche = false;
    boolean wellFed = false;
    FoodUtils.State isSpoiled = FoodUtils.State.Okay;

    public CustomFoodData(FoodData originalFoodData) {
        this.f_38696_ = originalFoodData.f_38696_;
        this.m_38717_(originalFoodData.m_38722_());
        this.m_150378_(originalFoodData.m_150380_());
        this.f_38699_ = originalFoodData.f_38699_;
    }

    public void m_38707_(int pFoodLevelModifier, float pSaturationLevelModifier) {
        int foodLevel = this.f_38696_;
        float satMod = 1.0f;
        if (this.isSpoiled == FoodUtils.State.Spoiled) {
            pFoodLevelModifier /= 2;
        }
        if (this.isSpoiled == FoodUtils.State.Fresh) {
            satMod = 1.5f;
        } else if (this.isSpoiled == FoodUtils.State.Good) {
            satMod = 1.1f;
        } else if (this.isSpoiled == FoodUtils.State.Spoiling) {
            satMod = 0.9f;
        } else if (this.isSpoiled == FoodUtils.State.Spoiled) {
            satMod = 0.5f;
        }
        super.m_38707_(pFoodLevelModifier, pSaturationLevelModifier * satMod);
        int capacity = 20;
        if (ServerConfig.stomachCapacity == StomachCapacity.DOUBLED) {
            capacity = 40;
        } else if (ServerConfig.stomachCapacity == StomachCapacity.LIMITED && this.f_38696_ < 20) {
            capacity = 40;
        } else if (ServerConfig.stomachCapacity == StomachCapacity.LIMITED && this.f_38696_ >= 20) {
            capacity = this.f_38696_;
        }
        if (ServerConfig.stomachCapacity != StomachCapacity.VANILLA) {
            this.f_38696_ = Math.min(pFoodLevelModifier + foodLevel, capacity);
            if (this.f_38696_ == 20 && foodLevel < 20) {
                this.wellFed = true;
            } else {
                this.causeAche = this.f_38696_ > 20 && foodLevel < 20 && pFoodLevelModifier / 2 < this.f_38696_ - 20 ? true : this.f_38696_ > 20 && foodLevel >= 20;
            }
        }
    }

    public void eat(Item pItem, ItemStack pStack, LivingEntity entity) {
        super.eat(pItem, pStack, entity);
        if (pItem.m_41472_()) {
            FoodProperties foodproperties = pStack.getFoodProperties(entity);
            for (Pair effect : foodproperties.m_38749_()) {
                if (((MobEffectInstance)effect.getFirst()).m_19544_() != MobEffects.f_19612_ && this.isSpoiled != FoodUtils.State.Spoiled) continue;
                ++this.uncleanConsumption;
                break;
            }
        }
    }

    public void markAsSpoiled(ItemStack stack, LivingEntity living) {
        this.isSpoiled = FoodUtils.foodStatus(stack, living.m_9236_());
        if (this.isSpoiled == FoodUtils.State.Spoiled) {
            living.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 1200));
            living.m_7292_(new MobEffectInstance(MobEffects.f_19612_, 1200));
        }
    }

    public void m_38710_(Player pPlayer) {
        Difficulty difficulty = pPlayer.m_9236_().m_46791_();
        if (this.wellFed) {
            if (this.f_38696_ == 20) {
                pPlayer.m_7292_(new MobEffectInstance(SMobEffects.WELL_FED, 300, 0));
            } else {
                this.wellFed = false;
            }
        }
        if (ServerConfig.stomachCapacity != StomachCapacity.VANILLA) {
            int amplifier = -1;
            int duration = 210;
            if (this.f_38696_ > 36) {
                amplifier = 4;
            } else if (this.f_38696_ > 32) {
                amplifier = 3;
            } else if (this.f_38696_ > 28) {
                amplifier = 2;
            } else if (this.f_38696_ > 24) {
                amplifier = 1;
            } else if (this.f_38696_ > 20) {
                amplifier = 0;
            }
            MobEffectInstance upsetStomach = pPlayer.m_21124_(SMobEffects.UPSET_STOMACH);
            if (!(pPlayer.m_5833_() || pPlayer.m_7500_() || amplifier <= 0 || upsetStomach != null && upsetStomach.m_19557_() > 210 && upsetStomach.m_19564_() >= amplifier)) {
                pPlayer.m_7292_(new MobEffectInstance(SMobEffects.UPSET_STOMACH, duration, amplifier));
            }
        }
        if (Survive.WELLBEING_CONFIG.enabled && this.uncleanConsumption >= 3) {
            ((IRealisticEntity)pPlayer).getWellbeingData().setTimer(2400, 6000, "eating bad food");
            this.uncleanConsumption = 0;
        }
        if (this.f_38696_ >= 40 && (pPlayer.m_21223_() > 10.0f || difficulty == Difficulty.HARD || pPlayer.m_21223_() > 1.0f && difficulty == Difficulty.NORMAL)) {
            int tickTimer2 = this.f_38699_;
            this.f_38699_ = 0;
            super.m_38710_(pPlayer);
            this.f_38699_ = tickTimer2 + 1;
            if (this.f_38699_ >= 10) {
                pPlayer.m_6469_(SDamageSources.source(pPlayer.m_9236_().m_9598_(), SDamageTypes.OVEREAT), 1.0f);
                this.f_38699_ = 0;
            }
        } else {
            super.m_38710_(pPlayer);
        }
    }

    public boolean canConsumeFood() {
        switch (ServerConfig.stomachCapacity) {
            case VANILLA: {
                return this.m_38721_();
            }
            case LIMITED: {
                return this.m_38721_();
            }
            case DOUBLED: {
                return this.f_38696_ < 40;
            }
        }
        return this.m_38721_();
    }

    public void m_38715_(CompoundTag pCompoundTag) {
        super.m_38715_(pCompoundTag);
        if (pCompoundTag.m_128425_("foodLevel", 99)) {
            this.uncleanConsumption = pCompoundTag.m_128451_("foodUncleanConsumption");
            this.causeAche = pCompoundTag.m_128471_("foodCauseAche");
            this.wellFed = pCompoundTag.m_128471_("foodWellFed");
        }
    }

    public void m_38719_(CompoundTag pCompoundTag) {
        super.m_38719_(pCompoundTag);
        pCompoundTag.m_128350_("foodUncleanConsumption", (float)this.uncleanConsumption);
        pCompoundTag.m_128379_("foodCauseAche", this.causeAche);
        pCompoundTag.m_128379_("foodWellFed", this.wellFed);
    }

    public static enum StomachCapacity {
        DOUBLED,
        LIMITED,
        VANILLA;

    }
}

