/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.needs;

import com.stereowalker.survive.Survive;
import com.stereowalker.survive.needs.SurviveData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.commons.lang3.mutable.MutableInt;

@Mod.EventBusSubscriber
public class NutritionData
extends SurviveData {
    private MutableInt carbLevel = new MutableInt(0);
    private MutableInt carbTimer = new MutableInt(0);
    private MutableFloat carbStack = new MutableFloat(0.0f);
    private MutableInt proteinLevel = new MutableInt(0);
    private MutableInt proteinTimer = new MutableInt(0);
    private MutableFloat proteinStack = new MutableFloat(0.0f);

    public NutritionData() {
        this.carbLevel = new MutableInt(200);
        this.proteinLevel = new MutableInt(200);
    }

    public void addCarbs(float carb) {
        this.carbStack.add(Mth.m_14036_((float)carb, (float)-100.0f, (float)300.0f));
    }

    public void removeCarbs(int carbs) {
        this.carbLevel.subtract(carbs);
    }

    public void addProtein(float carb) {
        this.proteinStack.add(Mth.m_14036_((float)carb, (float)-100.0f, (float)300.0f));
    }

    public void removeProtein(int protein) {
        this.proteinLevel.subtract(protein);
    }

    public void hand(Player player, MutableInt timer, MutableInt level, MutableFloat stack) {
        if (stack.getValue().floatValue() >= 10.0f && level.getValue() < 300) {
            timer.increment();
            if (timer.getValue() > 100 && player.m_36324_().m_38702_() > 3) {
                stack.subtract(10.0f);
                level.add(10);
                player.m_36324_().m_38705_(player.m_36324_().m_38702_() - 1);
                timer.setValue(0);
            }
        } else {
            timer.setValue(0);
        }
    }

    @Override
    public void tick(Player player) {
        this.hand(player, this.carbTimer, this.carbLevel, this.carbStack);
        this.hand(player, this.proteinTimer, this.proteinLevel, this.proteinStack);
    }

    @Override
    public void read(CompoundTag compound) {
        if (compound.m_128425_("nutritionCarbLevel", 99)) {
            this.carbLevel = new MutableInt(compound.m_128451_("nutritionCarbLevel"));
            this.carbTimer = new MutableInt(compound.m_128451_("nutritionCarbTimer"));
            this.carbStack = new MutableFloat(compound.m_128457_("nutritionCarbStack"));
            this.proteinLevel = new MutableInt(compound.m_128451_("nutritionProteinLevel"));
            this.proteinTimer = new MutableInt(compound.m_128451_("nutritionProteinTimer"));
            this.proteinStack = new MutableFloat(compound.m_128457_("nutritionProteinStack"));
        }
    }

    @Override
    public void write(CompoundTag compound) {
        compound.m_128405_("nutritionCarbLevel", this.carbLevel.getValue().intValue());
        compound.m_128405_("nutritionCarbTimer", this.carbTimer.getValue().intValue());
        compound.m_128350_("nutritionCarbStack", this.carbStack.getValue().floatValue());
        compound.m_128405_("nutritionProteinLevel", this.proteinLevel.getValue().intValue());
        compound.m_128405_("nutritionProteinTimer", this.proteinTimer.getValue().intValue());
        compound.m_128350_("nutritionProteinStack", this.proteinStack.getValue().floatValue());
    }

    public int getCarbLevel() {
        return this.carbLevel.intValue();
    }

    public int getProteinLevel() {
        return this.proteinLevel.intValue();
    }

    @Override
    public void save(LivingEntity player) {
    }

    @Override
    public boolean shouldTick() {
        return Survive.CONFIG.nutrition_enabled;
    }
}

