/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.needs;

import com.stereowalker.survive.Survive;
import com.stereowalker.survive.core.SurviveEntityStats;
import com.stereowalker.survive.needs.SurviveData;
import com.stereowalker.survive.world.effect.SMobEffects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class SleepData
extends SurviveData {
    private int awakeTimer = 0;

    public void addAwakeTime(ServerPlayer player, int awakeTime) {
        if (player.f_8941_.m_9294_()) {
            this.awakeTimer = Math.max(0, this.awakeTimer + awakeTime);
        }
    }

    @Override
    public void tick(Player player) {
        if (!player.m_9236_().f_46443_) {
            ServerPlayer serverplayer = (ServerPlayer)player;
            Difficulty difficulty = player.m_9236_().m_46791_();
            if (difficulty == Difficulty.PEACEFUL) {
                this.addAwakeTime(serverplayer, -1);
            } else if (player.m_5803_()) {
                this.addAwakeTime(serverplayer, -player.m_36318_());
            } else if (serverplayer.m_9236_().m_6042_().f_63862_()) {
                this.addAwakeTime(serverplayer, 1);
            }
            if (player.f_19797_ % 20 == 0) {
                this.addTiredEffect(serverplayer);
            }
        }
    }

    public void addTiredEffect(ServerPlayer player) {
        if (this.tirednessAmplifier((Player)player) >= 0 && !player.m_21023_(SMobEffects.ENERGIZED)) {
            player.m_7292_(new MobEffectInstance(SMobEffects.TIREDNESS, 200, Math.min(this.tirednessAmplifier((Player)player), Survive.CONFIG.tiredTimeStacks), false, false, true));
        }
    }

    public int tirednessAmplifier(Player player) {
        SleepData stats = SurviveEntityStats.getSleepStats((LivingEntity)player);
        float extraTime = stats.getAwakeTimer() - Survive.CONFIG.initialTiredTime;
        return Mth.m_14143_((float)(extraTime / (float)Survive.CONFIG.tiredTimeStep));
    }

    @Override
    public void read(CompoundTag compound) {
        if (compound.m_128425_("awakeTimer", 99)) {
            this.awakeTimer = compound.m_128451_("awakeTimer");
        }
    }

    @Override
    public void write(CompoundTag compound) {
        compound.m_128405_("awakeTimer", this.awakeTimer);
    }

    @Override
    public void save(LivingEntity player) {
        SurviveEntityStats.setSleepStats(player, this);
    }

    @Override
    public boolean shouldTick() {
        return Survive.CONFIG.enable_sleep;
    }

    public int getAwakeTimer() {
        return this.awakeTimer;
    }

    public float getDaysAwake() {
        return (float)Mth.m_14143_((float)((float)this.awakeTimer / 12000.0f)) * 0.5f;
    }

    public void setAwakeTimer(int awakeTimer) {
        this.awakeTimer = awakeTimer;
    }
}

