/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.needs;

import com.stereowalker.survive.Survive;
import com.stereowalker.survive.core.SurviveEntityStats;
import com.stereowalker.survive.core.WeightHandler;
import com.stereowalker.survive.damagesource.SDamageSources;
import com.stereowalker.survive.damagesource.SDamageTypes;
import com.stereowalker.survive.needs.IRealisticEntity;
import com.stereowalker.survive.needs.SurviveData;
import com.stereowalker.survive.network.protocol.game.ServerboundArmorStaminaPacket;
import com.stereowalker.survive.network.protocol.game.ServerboundRelaxPacket;
import com.stereowalker.survive.network.protocol.game.ServerboundStaminaExhaustionPacket;
import com.stereowalker.survive.world.DataMaps;
import com.stereowalker.survive.world.effect.SMobEffects;
import com.stereowalker.survive.world.entity.ai.attributes.SAttributes;
import com.stereowalker.unionlib.util.RegistryHelper;
import java.util.Random;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.SleepFinishedTimeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class StaminaData
extends SurviveData {
    private int energyLevel;
    private int energyReserveLevel = 6;
    private float energyExhaustionLevel;
    private int energyTimer;
    private int prevEnergyLevel;
    private int maxStamina;

    public StaminaData(double maxStamina) {
        this.energyLevel = Mth.m_14107_((double)maxStamina);
        this.prevEnergyLevel = Mth.m_14107_((double)maxStamina);
    }

    public void relax(int energyLevelIn, double maxStamina) {
        int remaining = 0;
        remaining = this.energyReserveLevel + energyLevelIn - 6;
        this.energyReserveLevel = Math.min(energyLevelIn + this.energyReserveLevel, 6);
        if (remaining > 0) {
            this.energyLevel = Math.min(remaining + this.energyLevel, Mth.m_14107_((double)maxStamina));
        }
    }

    public void eat(Item pItem, ItemStack pStack, LivingEntity entity) {
        if (pStack.m_41614_() && DataMaps.Server.consummableItem.containsKey(RegistryHelper.items().m_7981_((Object)pItem)) && entity instanceof ServerPlayer && !entity.m_9236_().f_46443_) {
            ServerPlayer player = (ServerPlayer)entity;
            this.relax(DataMaps.Server.consummableItem.get(RegistryHelper.items().m_7981_((Object)pItem)).getEnergyAmount(), player.m_21133_(SAttributes.MAX_STAMINA));
            this.save((LivingEntity)player);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientTick(AbstractClientPlayer player) {
        if (player.m_20159_() && player.f_19797_ % 400 == 399) {
            if (player.m_20202_().m_20184_().f_82479_ == 0.0 && player.m_20202_().m_20184_().f_82481_ == 0.0) {
                new ServerboundRelaxPacket(1).send();
            } else {
                new ServerboundStaminaExhaustionPacket(0.0312f).send();
            }
        }
        if (player.f_19797_ % 90 == 89 && player.m_9236_().m_46791_() != Difficulty.PEACEFUL) {
            new ServerboundArmorStaminaPacket().send();
        }
    }

    @Override
    public void tick(Player player) {
        this.maxStamina = Mth.m_14107_((double)player.m_21133_(SAttributes.MAX_STAMINA));
        if (player.m_5803_() && player.m_9236_().m_46461_() && this.energyLevel < this.maxStamina / 2) {
            player.f_36110_ = 0;
        }
        Difficulty difficulty = player.m_9236_().m_46791_();
        int energyToRegen = 1 + (player.m_21023_(SMobEffects.WELL_FED) ? new Random().nextInt(2) : 0);
        this.prevEnergyLevel = this.energyLevel;
        if (this.energyExhaustionLevel > 10.0f) {
            this.energyExhaustionLevel -= 10.0f;
            if (difficulty != Difficulty.PEACEFUL) {
                if (this.energyLevel > 0) {
                    this.energyLevel = Math.max(this.energyLevel - 1, 0);
                } else if (this.energyReserveLevel > 0) {
                    this.energyReserveLevel = Math.max(this.energyReserveLevel - 1, 0);
                }
            }
        }
        if (this.isTired() && Survive.CONFIG.nutrition_enabled && ((IRealisticEntity)player).getNutritionData().getCarbLevel() >= 2) {
            ++this.energyTimer;
            if (Survive.STAMINA_CONFIG.stamina_recovery_ticks == 0 || this.energyTimer >= Survive.STAMINA_CONFIG.stamina_recovery_ticks) {
                this.relax(energyToRegen, this.maxStamina);
                ((IRealisticEntity)player).getNutritionData().removeCarbs(2);
                this.energyTimer = 0;
            }
        } else if (this.isTired() && !Survive.CONFIG.nutrition_enabled && player.m_36324_().m_38702_() > Survive.STAMINA_CONFIG.min_food && WeightHandler.getTotalArmorWeight((LivingEntity)player) / Survive.STAMINA_CONFIG.max_weight < 1.0f) {
            ++this.energyTimer;
            if (Survive.STAMINA_CONFIG.stamina_recovery_ticks == 0 || this.energyTimer >= Survive.STAMINA_CONFIG.stamina_recovery_ticks) {
                this.relax(energyToRegen, this.maxStamina);
                player.m_36324_().m_38703_(1.0f);
                this.energyTimer = 0;
            }
        } else if (player.m_5803_()) {
            ++this.energyTimer;
            if ((double)this.energyTimer >= Math.floor((float)Survive.STAMINA_CONFIG.sleepTime / (float)(this.maxStamina + 6))) {
                this.relax(energyToRegen, this.maxStamina);
                this.energyTimer = 0;
            }
        } else if (this.energyLevel <= 0 && this.energyReserveLevel <= 0) {
            ++this.energyTimer;
            if (this.energyTimer >= 20) {
                player.m_6469_(SDamageSources.source(player.m_9236_().m_9598_(), SDamageTypes.OVERWORK), 3.0f);
                this.energyTimer = 0;
            }
        } else {
            this.energyTimer = 0;
        }
        if (difficulty == Difficulty.PEACEFUL && player.m_9236_().m_46469_().m_46207_(GameRules.f_46139_) && this.isTired() && player.f_19797_ % 10 == 0) {
            this.setEnergyLevel(this.getEnergyLevel() + 1);
        }
    }

    @Override
    public void read(CompoundTag compound) {
        if (compound.m_128425_("energyLevel", 99)) {
            this.maxStamina = compound.m_128451_("maxStamina");
            this.energyLevel = compound.m_128451_("energyLevel");
            this.energyTimer = compound.m_128451_("energyTickTimer");
            this.energyReserveLevel = compound.m_128451_("energyReserveLevel");
            this.energyExhaustionLevel = compound.m_128457_("energyExhaustionLevel");
        }
    }

    @Override
    public void write(CompoundTag compound) {
        compound.m_128405_("maxStamina", this.maxStamina);
        compound.m_128405_("energyLevel", this.energyLevel);
        compound.m_128405_("energyTickTimer", this.energyTimer);
        compound.m_128405_("energyReserveLevel", this.energyReserveLevel);
        compound.m_128350_("energyExhaustionLevel", this.energyExhaustionLevel);
    }

    public int getEnergyLevel() {
        return this.energyLevel;
    }

    public boolean isTired() {
        return this.energyLevel < this.maxStamina;
    }

    public boolean isExhausted() {
        return this.energyLevel <= 0;
    }

    private void addExhaustion(float exhaustion) {
        this.energyExhaustionLevel = Math.min(this.energyExhaustionLevel + exhaustion, 40.0f);
    }

    public void addExhaustion(Player player, float exhaustion, String reason) {
        if (!player.m_150110_().f_35934_ && !player.m_9236_().f_46443_) {
            this.addExhaustion(exhaustion);
            this.save((LivingEntity)player);
        }
    }

    public int getReserveLevel() {
        return this.energyReserveLevel;
    }

    public void setEnergyLevel(int energyLevelIn) {
        this.energyLevel = energyLevelIn;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setEnergyReserveLevel(int energyReserveLevelIn) {
        this.energyReserveLevel = energyReserveLevelIn;
    }

    @Override
    public void save(LivingEntity player) {
        SurviveEntityStats.setStaminaStats(player, this);
    }

    @Override
    public boolean shouldTick() {
        return Survive.STAMINA_CONFIG.enabled;
    }

    @SubscribeEvent
    public static void clickItem(PlayerInteractEvent.RightClickItem clickItem) {
        if (clickItem.isCanceled() || !(clickItem.getEntity() instanceof Player) || clickItem.getCancellationResult().m_19077_()) {
            // empty if block
        }
    }

    @SubscribeEvent
    public static void rightClickEmpty(PlayerInteractEvent.RightClickEmpty clickItem) {
        if (!clickItem.isCanceled() && clickItem.getEntity() instanceof LocalPlayer && clickItem.getCancellationResult().m_19077_()) {
            new ServerboundStaminaExhaustionPacket(0.3125f).send();
        }
    }

    @SubscribeEvent
    public static void leftClickEmpty(PlayerInteractEvent.LeftClickEmpty clickItem) {
        if (!clickItem.isCanceled() && clickItem.getEntity() instanceof LocalPlayer && clickItem.getCancellationResult().m_19077_()) {
            new ServerboundStaminaExhaustionPacket(0.3125f).send();
        }
    }

    @SubscribeEvent
    public static void replenishEnergyOnSleep(SleepFinishedTimeEvent event) {
        for (Player player : event.getLevel().m_6907_()) {
            StaminaData energyStats = SurviveEntityStats.getEnergyStats((LivingEntity)player);
            int staminaToRecover = Mth.m_14167_((float)((float)(event.getNewTime() - event.getLevel().m_8044_()) / (float)Survive.STAMINA_CONFIG.sleepTime * (float)(energyStats.maxStamina + 6)));
            energyStats.relax(staminaToRecover, player.m_21133_(SAttributes.MAX_STAMINA));
            SurviveEntityStats.setStaminaStats((LivingEntity)player, energyStats);
        }
    }
}

