/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.needs;

import com.stereowalker.survive.Survive;
import com.stereowalker.survive.config.ServerConfig;
import com.stereowalker.survive.core.SurviveEntityStats;
import com.stereowalker.survive.damagesource.SDamageSources;
import com.stereowalker.survive.damagesource.SDamageTypes;
import com.stereowalker.survive.json.BiomeJsonHolder;
import com.stereowalker.survive.needs.CustomFoodData;
import com.stereowalker.survive.needs.IRealisticEntity;
import com.stereowalker.survive.needs.SurviveData;
import com.stereowalker.survive.world.DataMaps;
import com.stereowalker.survive.world.effect.SMobEffects;
import com.stereowalker.unionlib.util.RegistryHelper;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class WaterData
extends SurviveData {
    private int tempDropTicks = 0;
    private int waterLevel = 20;
    private float waterHydrationLevel = 4.0f;
    private float waterExhaustionLevel;
    private int waterTimer;
    private int prevWaterLevel = 20;
    private int uncleanConsumption = 0;
    private int uncleanStacks = 0;

    public void drink(int waterLevelIn, float waterHydrationModifier, int uncleanStack, boolean isUnclean) {
        int capacity = 20;
        if (ServerConfig.stomachCapacity == CustomFoodData.StomachCapacity.DOUBLED) {
            capacity = 40;
        } else if (ServerConfig.stomachCapacity == CustomFoodData.StomachCapacity.LIMITED && this.waterLevel < 20) {
            capacity = 40;
        } else if (ServerConfig.stomachCapacity == CustomFoodData.StomachCapacity.LIMITED && this.waterLevel >= 20) {
            capacity = this.waterLevel;
        }
        this.waterLevel = Math.min(waterLevelIn + this.waterLevel, capacity);
        if (this.waterHydrationLevel >= waterHydrationModifier) {
            this.waterHydrationLevel = waterHydrationModifier;
        } else if (this.waterHydrationLevel < waterHydrationModifier) {
            this.waterHydrationLevel = Mth.m_14036_((float)(this.waterHydrationLevel + waterHydrationModifier * Survive.THIRST_CONFIG.hydration_restoration), (float)1.0f, (float)waterHydrationModifier);
        }
        if (isUnclean) {
            this.uncleanStacks += uncleanStack;
            ++this.uncleanConsumption;
        }
    }

    public void drink(Item pItem, ItemStack pStack, LivingEntity entity) {
        if (entity != null && entity instanceof ServerPlayer) {
            ResourceLocation biomeSource;
            ServerPlayer player = (ServerPlayer)entity;
            Potion potion = PotionUtils.m_43579_((ItemStack)pStack);
            float biomef = -1.0f;
            int stacks = 0;
            if (pStack.m_41783_() != null && pStack.m_41783_().m_128441_("biome_source") && DataMaps.Server.biome.containsKey(biomeSource = new ResourceLocation(pStack.m_41783_().m_128461_("biome_source")))) {
                BiomeJsonHolder biomeData = DataMaps.Server.biome.get(biomeSource);
                biomef = biomeData.getThirstChance();
                stacks = biomeData.getUnwellIntensity();
            }
            if (potion != Potions.f_43598_ && DataMaps.Server.potionDrink.containsKey(RegistryHelper.potions().m_7981_((Object)potion))) {
                drinkData = DataMaps.Server.potionDrink.get(RegistryHelper.potions().m_7981_((Object)potion));
                this.drink(drinkData.getThirstAmount(), drinkData.getHydrationAmount(), stacks, WaterData.applyThirst(entity, biomef != -1.0f ? biomef : drinkData.getThirstChance()));
                if (drinkData.isHeated()) {
                    entity.m_7292_(new MobEffectInstance(SMobEffects.HEATED, 600));
                }
                if (drinkData.isChilled()) {
                    entity.m_7292_(new MobEffectInstance(SMobEffects.CHILLED, 600));
                }
                if (drinkData.isEnergizing()) {
                    entity.m_7292_(new MobEffectInstance(SMobEffects.ENERGIZED, 6000));
                }
            } else if (DataMaps.Server.consummableItem.containsKey(RegistryHelper.items().m_7981_((Object)pItem))) {
                drinkData = DataMaps.Server.consummableItem.get(RegistryHelper.items().m_7981_((Object)pItem));
                this.drink(drinkData.getThirstAmount(), drinkData.getHydrationAmount(), stacks, WaterData.applyThirst(entity, biomef != -1.0f ? biomef : drinkData.getThirstChance()));
                if (drinkData.isHeated()) {
                    entity.m_7292_(new MobEffectInstance(SMobEffects.HEATED, 600));
                }
                if (drinkData.isChilled()) {
                    entity.m_7292_(new MobEffectInstance(SMobEffects.CHILLED, 600));
                }
                if (drinkData.isEnergizing()) {
                    entity.m_7292_(new MobEffectInstance(SMobEffects.ENERGIZED, 6000));
                }
            }
            this.save((LivingEntity)player);
        }
    }

    @Override
    public void tick(Player player) {
        this.waterHydrationLevel = Mth.m_14036_((float)this.waterHydrationLevel, (float)1.0f, (float)4.0f);
        if (Survive.THIRST_CONFIG.idle_thirst_tick_rate > -1 && player.f_19797_ % Survive.THIRST_CONFIG.idle_thirst_tick_rate == Survive.THIRST_CONFIG.idle_thirst_tick_rate - 1) {
            this.addExhaustion(player, Survive.THIRST_CONFIG.idle_thirst_exhaustion);
        }
        Difficulty difficulty = player.m_9236_().m_46791_();
        this.prevWaterLevel = this.waterLevel;
        if (ServerConfig.stomachCapacity != CustomFoodData.StomachCapacity.VANILLA) {
            int amplifier = -1;
            int duration = 210;
            if (this.waterLevel > 36) {
                amplifier = 4;
            } else if (this.waterLevel > 32) {
                amplifier = 3;
            } else if (this.waterLevel > 28) {
                amplifier = 2;
            } else if (this.waterLevel > 24) {
                amplifier = 1;
            } else if (this.waterLevel > 20) {
                amplifier = 0;
            }
            MobEffectInstance upsetStomach = player.m_21124_(SMobEffects.UPSET_STOMACH);
            if (!(player.m_5833_() || player.m_7500_() || amplifier <= 0 || upsetStomach != null && upsetStomach.m_19557_() > 210 && upsetStomach.m_19564_() >= amplifier)) {
                player.m_7292_(new MobEffectInstance(SMobEffects.UPSET_STOMACH, duration, amplifier));
            }
        }
        if (this.waterExhaustionLevel > 4.0f) {
            this.waterExhaustionLevel -= 4.0f;
            if (this.waterHydrationLevel > 2.8f) {
                this.waterHydrationLevel = Math.max(this.waterHydrationLevel - 0.1f, 2.8f);
            }
            if (difficulty != Difficulty.PEACEFUL) {
                this.waterLevel = Math.max(this.waterLevel - (5 - Mth.m_14167_((float)this.waterHydrationLevel)), 0);
            }
        }
        boolean flag = player.m_9236_().m_46469_().m_46207_(GameRules.f_46139_);
        if (this.waterLevel >= 40) {
            ++this.waterTimer;
            if (this.waterTimer >= 10) {
                if (player.m_21223_() > 10.0f || difficulty == Difficulty.HARD || player.m_21223_() > 1.0f && difficulty == Difficulty.NORMAL) {
                    player.m_6469_(SDamageSources.source(player.m_9236_().m_9598_(), SDamageTypes.OVERHYDRATE), 1.0f);
                }
                this.waterTimer = 0;
            }
        } else if (flag && this.waterLevel >= 16 && ((IRealisticEntity)player).getTemperatureData().getTemperatureLevel() > 37.0) {
            ++this.waterTimer;
            if (this.waterTimer >= 80) {
                ++this.tempDropTicks;
                this.addExhaustion(6.0f);
                this.waterTimer = 0;
            }
        } else if (this.waterLevel <= 0) {
            ++this.waterTimer;
            if (this.waterTimer >= 80) {
                if (player.m_21223_() > 10.0f || difficulty == Difficulty.HARD || player.m_21223_() > 1.0f && difficulty == Difficulty.NORMAL) {
                    player.m_6469_(SDamageSources.source(player.m_9236_().m_9598_(), SDamageTypes.DEHYDRATE), 1.0f);
                }
                this.waterTimer = 0;
            }
        } else {
            this.waterTimer = 0;
        }
        if (Survive.WELLBEING_CONFIG.enabled && this.uncleanConsumption >= 3) {
            ((IRealisticEntity)player).getWellbeingData().setTimer(2400, 6000, Mth.m_14167_((float)((float)this.uncleanStacks / (float)this.uncleanConsumption)), "drinking unpurified water");
            this.uncleanConsumption = 0;
        }
    }

    public void applyTempDrop(Player player) {
        --this.tempDropTicks;
        this.save((LivingEntity)player);
    }

    public boolean shouldTempDrop() {
        return this.tempDropTicks > 0;
    }

    @Override
    public void read(CompoundTag compound) {
        if (compound.m_128425_("waterLevel", 99)) {
            this.tempDropTicks = compound.m_128451_("tempDropTicks");
            this.waterLevel = compound.m_128451_("waterLevel");
            this.waterTimer = compound.m_128451_("waterTickTimer");
            this.waterHydrationLevel = compound.m_128457_("waterHydrationLevel");
            this.waterExhaustionLevel = compound.m_128457_("waterExhaustionLevel");
            this.uncleanConsumption = compound.m_128451_("uncleanComsumption");
            this.uncleanStacks = compound.m_128451_("uncleanStacks");
        }
    }

    @Override
    public void write(CompoundTag compound) {
        compound.m_128405_("tempDropTicks", this.tempDropTicks);
        compound.m_128405_("waterLevel", this.waterLevel);
        compound.m_128405_("waterTickTimer", this.waterTimer);
        compound.m_128350_("waterHydrationLevel", this.waterHydrationLevel);
        compound.m_128350_("waterExhaustionLevel", this.waterExhaustionLevel);
        compound.m_128405_("uncleanComsumption", this.uncleanConsumption);
        compound.m_128405_("uncleanStacks", this.uncleanStacks);
    }

    public int getWaterLevel() {
        return this.waterLevel;
    }

    public boolean needWater() {
        switch (ServerConfig.stomachCapacity) {
            case VANILLA: {
                return this.waterLevel < 20;
            }
            case LIMITED: {
                return this.waterLevel < 20;
            }
            case DOUBLED: {
                return this.waterLevel < 40;
            }
        }
        return this.waterLevel < 20;
    }

    private void addExhaustion(float exhaustion) {
        this.waterExhaustionLevel = Math.min(this.waterExhaustionLevel + exhaustion, 40.0f);
    }

    public void addExhaustion(Player player, float exhaustion) {
        if (!player.m_150110_().f_35934_ && !player.m_9236_().f_46443_) {
            this.addExhaustion(exhaustion);
            this.save((LivingEntity)player);
        }
    }

    public float getHydrationLevel() {
        return this.waterHydrationLevel;
    }

    public void setWaterLevel(int waterLevelIn) {
        this.waterLevel = waterLevelIn;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setWaterHydrationLevel(float waterHydrationLevelIn) {
        this.waterHydrationLevel = waterHydrationLevelIn;
    }

    @Override
    public void save(LivingEntity player) {
        SurviveEntityStats.setWaterStats(player, this);
    }

    @Override
    public boolean shouldTick() {
        return Survive.THIRST_CONFIG.enabled;
    }

    public static boolean applyThirst(LivingEntity entity, float probabiltiy) {
        Random rand;
        if (probabiltiy > 0.0f && (rand = new Random()).nextFloat() < probabiltiy) {
            entity.m_7292_(new MobEffectInstance(SMobEffects.THIRST, 600));
            return true;
        }
        return false;
    }
}

