/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.needs;

import com.stereowalker.survive.Survive;
import com.stereowalker.survive.core.SurviveEntityStats;
import com.stereowalker.survive.needs.SurviveData;
import com.stereowalker.survive.needs.TemperatureData;
import com.stereowalker.survive.world.effect.SMobEffects;
import com.stereowalker.survive.world.entity.ai.attributes.SAttributes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class WellbeingData
extends SurviveData {
    private boolean isWell = true;
    public int timeUntilUnwell = 0;
    public int timeUntilWell = 0;
    public int timeUntilHypothermia;
    public int timeUntilHyperthermia = 6000;
    private int intensity = -1;
    private String reason = "";

    public void setTimer(int min, int max, String reason) {
        if (this.timeUntilUnwell == 0 && this.isWell && this.shouldTick()) {
            this.timeUntilUnwell = min + this.rng.nextInt(max - min);
            this.reason = reason;
        }
    }

    public void setTimer(int min, int max, int intensity, String reason) {
        if (this.timeUntilUnwell == 0 && this.isWell && this.shouldTick()) {
            this.timeUntilUnwell = min + this.rng.nextInt(max - min);
            this.reason = reason;
            this.intensity = intensity;
        }
    }

    @Override
    public void tick(Player player) {
        if (this.timeUntilUnwell > 1 && this.isWell) {
            this.timeUntilWell = 0;
            --this.timeUntilUnwell;
        } else if (this.timeUntilUnwell == 1) {
            int rgn;
            this.timeUntilUnwell = 0;
            this.isWell = false;
            this.timeUntilWell = 6000;
            if (this.intensity == -1) {
                int max = 0;
                for (int i = 1; i <= 9; ++i) {
                    max += i;
                }
                int nte = this.rng.nextInt(max + 1);
                for (int i = 9; i >= 0; --i) {
                    if (nte >= max) {
                        this.intensity = i;
                        break;
                    }
                    max -= 10 - i;
                }
            }
            if ((rgn = this.rng.nextInt(2)) == 0) {
                player.m_7292_(new MobEffectInstance(SMobEffects.SLOWNESS_ILLNESS, this.timeUntilWell, this.intensity));
            } else {
                player.m_7292_(new MobEffectInstance(SMobEffects.WEAKNESS_ILLNESS, this.timeUntilWell, this.intensity));
            }
        } else if (this.timeUntilWell > 1 && !this.isWell) {
            this.timeUntilUnwell = 0;
            --this.timeUntilWell;
        } else if (this.timeUntilWell == 1) {
            this.isWell = true;
            this.timeUntilWell = 0;
            this.reason = "";
            this.intensity = -1;
        }
        if (!Survive.TEMPERATURE_CONFIG.useLegacyTemperatureSystem && Survive.TEMPERATURE_CONFIG.enabled) {
            double div;
            double maxTemp;
            TemperatureData data = SurviveEntityStats.getTemperatureStats((LivingEntity)player);
            double tempLocation = data.getTemperatureLevel() - 37.0;
            double f = 0.0;
            if (tempLocation > 0.0) {
                maxTemp = 0.0;
                if (player.m_21051_(SAttributes.HEAT_RESISTANCE) != null) {
                    maxTemp = player.m_21133_(SAttributes.HEAT_RESISTANCE);
                }
                div = tempLocation / maxTemp;
                f = Mth.m_14008_((double)div, (double)0.0, (double)1.4444444444444444);
            }
            if (tempLocation < 0.0) {
                maxTemp = 0.0;
                if (player.m_21051_(SAttributes.COLD_RESISTANCE) != null) {
                    maxTemp = player.m_21133_(SAttributes.COLD_RESISTANCE);
                }
                div = tempLocation / maxTemp;
                f = Mth.m_14008_((double)div, (double)-1.4444444444444444, (double)0.0);
            }
            this.timeUntilHyperthermia = f > (double)0.7f && !player.m_21023_(SMobEffects.HYPERTHERMIA) ? --this.timeUntilHyperthermia : 6000;
            this.timeUntilHypothermia = f < (double)-0.7f && !player.m_21023_(SMobEffects.HYPOTHERMIA) ? --this.timeUntilHypothermia : 6000;
            if (this.timeUntilHyperthermia <= 0 && !player.m_21023_(SMobEffects.HYPERTHERMIA)) {
                player.m_7292_(new MobEffectInstance(SMobEffects.HYPERTHERMIA, 6000));
            }
            if (this.timeUntilHypothermia <= 0 && !player.m_21023_(SMobEffects.HYPOTHERMIA)) {
                player.m_7292_(new MobEffectInstance(SMobEffects.HYPOTHERMIA, 6000));
            }
        }
    }

    @Override
    public void read(CompoundTag compound) {
        if (compound.m_128425_("timeUntilUnwell", 99)) {
            this.isWell = compound.m_128471_("isWell");
            this.timeUntilWell = compound.m_128451_("timeUntilWell");
            this.timeUntilUnwell = compound.m_128451_("timeUntilUnwell");
            this.timeUntilHypothermia = compound.m_128451_("timeUntilHypothermia");
            this.timeUntilHyperthermia = compound.m_128451_("timeUntilHyperthermia");
            this.intensity = compound.m_128451_("unwellIntensity");
            this.reason = compound.m_128461_("unwellReason");
        }
    }

    @Override
    public void write(CompoundTag compound) {
        compound.m_128379_("isWell", this.isWell);
        compound.m_128405_("timeUntilWell", this.timeUntilWell);
        compound.m_128405_("timeUntilUnwell", this.timeUntilUnwell);
        compound.m_128405_("timeUntilHypothermia", this.timeUntilHypothermia);
        compound.m_128405_("timeUntilHyperthermia", this.timeUntilHyperthermia);
        compound.m_128405_("unwellIntensity", this.intensity);
        compound.m_128359_("unwellReason", this.reason);
    }

    @Override
    public void save(LivingEntity player) {
    }

    @Override
    public boolean shouldTick() {
        return Survive.WELLBEING_CONFIG.enabled;
    }

    public boolean isWell() {
        return this.isWell;
    }

    public int getIntensity() {
        return this.intensity;
    }

    public String getReason() {
        return this.reason;
    }
}

