/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.network.protocol.game;

import com.google.common.collect.ImmutableMap;
import com.stereowalker.survive.Survive;
import com.stereowalker.survive.api.json.JsonHolder;
import com.stereowalker.survive.json.ArmorJsonHolder;
import com.stereowalker.survive.json.BiomeJsonHolder;
import com.stereowalker.survive.json.FluidJsonHolder;
import com.stereowalker.survive.world.DataMaps;
import com.stereowalker.unionlib.network.protocol.game.ClientboundUnionPacket;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ClientboundDataTransferPacket
extends ClientboundUnionPacket {
    private ResourceLocation stat;
    private JsonHolder settings;
    private boolean clear;

    public ClientboundDataTransferPacket(ResourceLocation statIn, JsonHolder settingsIn, boolean clear) {
        super(Survive.getInstance().channel);
        this.stat = statIn;
        this.settings = settingsIn;
        this.clear = clear;
    }

    public ClientboundDataTransferPacket(FriendlyByteBuf byteBuf) {
        super(byteBuf, Survive.getInstance().channel);
        this.stat = byteBuf.m_130281_();
        String cl = byteBuf.m_130277_();
        this.settings = JsonHolder.deserialize(byteBuf.m_130260_(), (Class)JsonHolder.HOLD.get((Object)cl));
        this.clear = byteBuf.readBoolean();
    }

    public void encode(FriendlyByteBuf byteBuf) {
        byteBuf.m_130085_(this.stat);
        byteBuf.m_130070_(this.settings.getClass().descriptorString());
        byteBuf.m_130079_(this.settings.serialize());
        byteBuf.writeBoolean(this.clear);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean handleOnClient(LocalPlayer sender) {
        HashMap<ResourceLocation, JsonHolder> statMap;
        if (this.settings instanceof ArmorJsonHolder) {
            if (this.clear) {
                Survive.getInstance().getLogger().info("Clearing Client Side Armor Data");
                DataMaps.Client.armor = ImmutableMap.of();
            }
            statMap = new HashMap<ResourceLocation, JsonHolder>();
            statMap.putAll((Map<ResourceLocation, JsonHolder>)DataMaps.Client.armor);
            statMap.put(this.stat, (ArmorJsonHolder)this.settings);
            DataMaps.Client.armor = ImmutableMap.copyOf(statMap);
        }
        if (this.settings instanceof FluidJsonHolder) {
            if (this.clear) {
                Survive.getInstance().getLogger().info("Clearing Client Side Fluid Data");
                DataMaps.Client.fluid = ImmutableMap.of();
            }
            statMap = new HashMap();
            statMap.putAll((Map<ResourceLocation, JsonHolder>)DataMaps.Client.fluid);
            statMap.put(this.stat, (FluidJsonHolder)this.settings);
            DataMaps.Client.fluid = ImmutableMap.copyOf(statMap);
        }
        if (this.settings instanceof BiomeJsonHolder) {
            if (this.clear) {
                Survive.getInstance().getLogger().info("Clearing Client Side Biome Data");
                DataMaps.Client.biome = ImmutableMap.of();
            }
            statMap = new HashMap();
            statMap.putAll((Map<ResourceLocation, JsonHolder>)DataMaps.Client.biome);
            statMap.put(this.stat, (BiomeJsonHolder)this.settings);
            DataMaps.Client.biome = ImmutableMap.copyOf(statMap);
        }
        return true;
    }
}

