/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.network.protocol.game;

import com.stereowalker.survive.Survive;
import com.stereowalker.survive.core.SurviveEntityStats;
import com.stereowalker.survive.core.WeightHandler;
import com.stereowalker.survive.needs.StaminaData;
import com.stereowalker.unionlib.network.protocol.game.ServerboundUnionPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class ServerboundArmorStaminaPacket
extends ServerboundUnionPacket {
    public ServerboundArmorStaminaPacket() {
        super(Survive.getInstance().channel);
    }

    public ServerboundArmorStaminaPacket(FriendlyByteBuf packetBuffer) {
        super(packetBuffer, Survive.getInstance().channel);
    }

    public void encode(FriendlyByteBuf packetBuffer) {
    }

    public boolean handleOnServer(ServerPlayer sender) {
        if (Survive.STAMINA_CONFIG.enabled) {
            StaminaData stats = SurviveEntityStats.getEnergyStats((LivingEntity)sender);
            float moveMul = WeightHandler.getTotalArmorWeight((LivingEntity)sender) / Survive.STAMINA_CONFIG.max_weight * 0.1f;
            if (WeightHandler.getTotalArmorWeight((LivingEntity)sender) / Survive.STAMINA_CONFIG.max_weight > 1.0f) {
                moveMul += WeightHandler.getTotalArmorWeight((LivingEntity)sender) / Survive.STAMINA_CONFIG.max_weight - 1.0f;
            }
            if (moveMul > 0.0f) {
                stats.addExhaustion((Player)sender, moveMul * 2.0f, "Armor weight");
            }
            SurviveEntityStats.setStaminaStats((LivingEntity)sender, stats);
        }
        return true;
    }
}

