/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.network.protocol.game;

import com.stereowalker.survive.Survive;
import com.stereowalker.survive.json.BiomeJsonHolder;
import com.stereowalker.survive.needs.IRealisticEntity;
import com.stereowalker.survive.needs.WaterData;
import com.stereowalker.survive.network.protocol.game.ClientboundDrinkSoundPacket;
import com.stereowalker.survive.world.DataMaps;
import com.stereowalker.survive.world.item.SItems;
import com.stereowalker.unionlib.network.protocol.game.ServerboundUnionPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.WaterFluid;

public class ServerboundInteractWithWaterPacket
extends ServerboundUnionPacket {
    private BlockPos pos;
    private float addThirst;
    private double waterAmount;
    private double hydrationAmount;
    private InteractionHand hand;

    public ServerboundInteractWithWaterPacket(BlockPos pos, float addThirst, double waterAmount, double hydrationAmount, InteractionHand hand) {
        super(Survive.getInstance().channel);
        this.pos = pos;
        this.addThirst = addThirst;
        this.waterAmount = waterAmount;
        this.hydrationAmount = hydrationAmount;
        this.hand = hand;
    }

    public ServerboundInteractWithWaterPacket(BlockPos pos, float addThirst, double waterAmount, InteractionHand hand) {
        this(pos, addThirst, waterAmount, 0.0, hand);
    }

    public ServerboundInteractWithWaterPacket(FriendlyByteBuf packetBuffer) {
        super(packetBuffer, Survive.getInstance().channel);
        this.pos = packetBuffer.m_130135_();
        this.addThirst = packetBuffer.readFloat();
        this.hand = (InteractionHand)packetBuffer.m_130066_(InteractionHand.class);
        this.waterAmount = packetBuffer.readDouble();
        this.hydrationAmount = packetBuffer.readDouble();
    }

    public void encode(FriendlyByteBuf byteBuf) {
        byteBuf.m_130064_(this.pos);
        byteBuf.writeFloat(this.addThirst);
        byteBuf.m_130068_((Enum)this.hand);
        byteBuf.writeDouble(this.waterAmount);
        byteBuf.writeDouble(this.hydrationAmount);
    }

    public static boolean canDrinkThis(FluidState fluid, boolean canDrinkFlowingIfInfinite) {
        if (fluid.m_76170_()) {
            return true;
        }
        return fluid.m_76152_() instanceof WaterFluid && canDrinkFlowingIfInfinite;
    }

    public static boolean shouldRemoveSource(FluidState fluid) {
        return (!(fluid.m_76152_() instanceof WaterFluid) || Survive.THIRST_CONFIG.shouldRemoveSourceWaterBlock) && fluid.m_76170_();
    }

    public boolean handleOnServer(ServerPlayer sender) {
        if (Survive.THIRST_CONFIG.enabled) {
            ItemStack heldItem = sender.m_21120_(this.hand);
            BlockState block = sender.m_9236_().m_8055_(this.pos);
            FluidState fluid = sender.m_9236_().m_6425_(this.pos);
            if (heldItem.m_41619_()) {
                if (sender.m_6047_()) {
                    WaterData waterStats = ((IRealisticEntity)sender).getWaterData();
                    if (waterStats.needWater()) {
                        boolean flag = false;
                        if (block.m_60734_() == Blocks.f_152476_) {
                            LayeredCauldronBlock.m_153559_((BlockState)block, (Level)sender.m_9236_(), (BlockPos)this.pos);
                            flag = true;
                        } else if (ServerboundInteractWithWaterPacket.canDrinkThis(fluid, Survive.THIRST_CONFIG.drinkFromFlowingWater)) {
                            if (ServerboundInteractWithWaterPacket.shouldRemoveSource(fluid)) {
                                sender.m_9236_().m_46597_(this.pos, Blocks.f_50016_.m_49966_());
                            }
                            flag = true;
                        } else if (sender.m_9236_().m_46758_(this.pos)) {
                            flag = true;
                        }
                        if (flag) {
                            int stacks = 0;
                            if (DataMaps.Server.biome.containsKey(((ResourceKey)sender.m_9236_().m_204166_(this.pos).m_203543_().get()).m_135782_())) {
                                BiomeJsonHolder biomeData = DataMaps.Server.biome.get(((ResourceKey)sender.m_9236_().m_204166_(this.pos).m_203543_().get()).m_135782_());
                                stacks = biomeData.getUnwellIntensity();
                            }
                            waterStats.drink((int)this.waterAmount, (float)this.hydrationAmount, stacks, WaterData.applyThirst((LivingEntity)sender, this.addThirst));
                        }
                        sender.m_9236_().m_5594_((Player)sender, this.pos, new ItemStack((ItemLike)Items.f_42589_).m_41615_(), SoundSource.PLAYERS, 0.5f, sender.m_9236_().f_46441_.m_188501_() * 0.1f + 0.9f);
                        sender.m_6674_(InteractionHand.MAIN_HAND);
                        new ClientboundDrinkSoundPacket(this.pos).send(sender);
                    }
                    waterStats.save((LivingEntity)sender);
                }
            } else if (heldItem.m_41720_() == Items.f_42399_ && ServerboundInteractWithWaterPacket.isValidContainerSource(this.waterAmount)) {
                heldItem.m_41774_(1);
                if (this.addThirst > 0.0f) {
                    sender.m_36356_(new ItemStack((ItemLike)SItems.WATER_BOWL));
                } else {
                    sender.m_36356_(new ItemStack((ItemLike)SItems.PURIFIED_WATER_BOWL));
                }
            }
        }
        return true;
    }

    public static boolean isValidContainerSource(double waterAmount) {
        return waterAmount >= 3.0;
    }

    public static boolean isValidStack(ItemStack stack) {
        return stack.m_41720_() == Items.f_42399_ || stack.m_41619_();
    }
}

