/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.network.protocol.game;

import com.stereowalker.survive.Survive;
import com.stereowalker.survive.core.SurviveEntityStats;
import com.stereowalker.survive.needs.StaminaData;
import com.stereowalker.unionlib.network.protocol.game.ServerboundUnionPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class ServerboundStaminaExhaustionPacket
extends ServerboundUnionPacket {
    private float exhaustion;

    public ServerboundStaminaExhaustionPacket(float exhaustion) {
        super(Survive.getInstance().channel);
        this.exhaustion = exhaustion;
    }

    public ServerboundStaminaExhaustionPacket(FriendlyByteBuf packetBuffer) {
        super(packetBuffer, Survive.getInstance().channel);
        this.exhaustion = packetBuffer.readFloat();
    }

    public void encode(FriendlyByteBuf packetBuffer) {
        packetBuffer.writeFloat(this.exhaustion);
    }

    public boolean handleOnServer(ServerPlayer sender) {
        if (Survive.STAMINA_CONFIG.enabled) {
            StaminaData stats = SurviveEntityStats.getEnergyStats((LivingEntity)sender);
            stats.addExhaustion((Player)sender, this.exhaustion, "Energy from client");
            SurviveEntityStats.setStaminaStats((LivingEntity)sender, stats);
        }
        return true;
    }
}

