/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.resource;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.stereowalker.survive.Survive;
import com.stereowalker.survive.json.BlockTemperatureJsonHolder;
import com.stereowalker.unionlib.resource.IResourceReloadListener;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockDataManager
implements IResourceReloadListener<Map<ResourceLocation, BlockTemperatureJsonHolder>> {
    public CompletableFuture<Map<ResourceLocation, BlockTemperatureJsonHolder>> load(ResourceManager manager, ProfilerFiller profiler, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            HashMap<ResourceLocation, BlockTemperatureJsonHolder> drinkMap = new HashMap<ResourceLocation, BlockTemperatureJsonHolder>();
            for (Map.Entry resource : manager.m_214159_("survive_modifiers/blocks", s -> s.toString().endsWith(".json")).entrySet()) {
                ResourceLocation blockId = new ResourceLocation(((ResourceLocation)resource.getKey()).m_135827_(), ((ResourceLocation)resource.getKey()).m_135815_().replace("survive_modifiers/blocks/", "").replace(".json", ""));
                if (ForgeRegistries.BLOCKS.containsKey(blockId)) {
                    try (InputStream stream = ((Resource)resource.getValue()).m_215507_();
                         InputStreamReader reader = new InputStreamReader(stream);){
                        JsonObject object = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                        BlockTemperatureJsonHolder blockData = new BlockTemperatureJsonHolder(blockId, object);
                        Survive.getInstance().getLogger().info("Found block temperature modifier for the item " + blockId);
                        drinkMap.put(blockId, blockData);
                    }
                    catch (Exception e) {
                        Survive.getInstance().getLogger().warn("Error reading the block temperature modifier for the item " + blockId + "!", (Throwable)e);
                    }
                    continue;
                }
                Survive.getInstance().getLogger().warn("No such block exists with the block id " + blockId + "!");
            }
            return drinkMap;
        });
    }

    public CompletableFuture<Void> apply(Map<ResourceLocation, BlockTemperatureJsonHolder> data, ResourceManager manager, ProfilerFiller profiler, Executor executor) {
        return CompletableFuture.runAsync(() -> {
            for (ResourceLocation drinkId : data.keySet()) {
                Survive.registerBlockTemperatures(drinkId, (BlockTemperatureJsonHolder)data.get(drinkId));
            }
        });
    }

    public ResourceLocation id() {
        return new ResourceLocation("survive:block_data");
    }
}

