/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.resource;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.stereowalker.survive.Survive;
import com.stereowalker.survive.json.FluidJsonHolder;
import com.stereowalker.survive.world.DataMaps;
import com.stereowalker.unionlib.resource.IResourceReloadListener;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidDataManager
implements IResourceReloadListener<Map<ResourceLocation, FluidJsonHolder>> {
    public CompletableFuture<Map<ResourceLocation, FluidJsonHolder>> load(ResourceManager manager, ProfilerFiller profiler, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            HashMap<ResourceLocation, FluidJsonHolder> drinkMap = new HashMap<ResourceLocation, FluidJsonHolder>();
            for (Map.Entry resource : manager.m_214159_("survive_modifiers/fluids", s -> s.toString().endsWith(".json")).entrySet()) {
                ResourceLocation drinkId = new ResourceLocation(((ResourceLocation)resource.getKey()).m_135827_(), ((ResourceLocation)resource.getKey()).m_135815_().replace("survive_modifiers/fluids/", "").replace(".json", ""));
                if (ForgeRegistries.FLUIDS.containsKey(drinkId)) {
                    try (InputStream stream = ((Resource)resource.getValue()).m_215507_();
                         InputStreamReader reader = new InputStreamReader(stream);){
                        JsonObject object = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                        FluidJsonHolder drinkData = new FluidJsonHolder(drinkId, object);
                        Survive.getInstance().getLogger().info("Found fluid data for " + drinkId);
                        drinkMap.put(drinkId, drinkData);
                    }
                    catch (Exception e) {
                        Survive.getInstance().getLogger().warn("Error reading fluid data " + drinkId + "!", (Throwable)e);
                    }
                    continue;
                }
                Survive.getInstance().getLogger().warn("No such fluid exists with the id " + drinkId + "!");
            }
            return drinkMap;
        });
    }

    public CompletableFuture<Void> apply(Map<ResourceLocation, FluidJsonHolder> data, ResourceManager manager, ProfilerFiller profiler, Executor executor) {
        return CompletableFuture.runAsync(() -> {
            for (ResourceLocation drinkId : data.keySet()) {
                DataMaps.Server.fluid.put(drinkId, (FluidJsonHolder)data.get(drinkId));
            }
        });
    }

    public ResourceLocation id() {
        return new ResourceLocation("survive:fluid_data");
    }
}

