/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.resource;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.stereowalker.survive.Survive;
import com.stereowalker.survive.json.FoodJsonHolder;
import com.stereowalker.survive.world.DataMaps;
import com.stereowalker.unionlib.resource.IResourceReloadListener;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemConsummableDataManager
implements IResourceReloadListener<Map<ResourceLocation, FoodJsonHolder>> {
    public CompletableFuture<Map<ResourceLocation, FoodJsonHolder>> load(ResourceManager manager, ProfilerFiller profiler, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            HashMap<ResourceLocation, FoodJsonHolder> drinkMap = new HashMap<ResourceLocation, FoodJsonHolder>();
            for (Map.Entry resource : manager.m_214159_("survive_modifiers/consumables/items", s -> s.toString().endsWith(".json")).entrySet()) {
                ResourceLocation drinkId = new ResourceLocation(((ResourceLocation)resource.getKey()).m_135827_(), ((ResourceLocation)resource.getKey()).m_135815_().replace("survive_modifiers/consumables/items/", "").replace(".json", ""));
                if (ForgeRegistries.ITEMS.containsKey(drinkId)) {
                    try (InputStream stream = ((Resource)resource.getValue()).m_215507_();
                         InputStreamReader reader = new InputStreamReader(stream);){
                        JsonObject object = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                        FoodJsonHolder drinkData = new FoodJsonHolder(drinkId, object);
                        if (((Item)ForgeRegistries.ITEMS.getValue(drinkId)).m_41472_() && DataMaps.Server.defaultFood.containsKey(drinkId)) {
                            ((Item)ForgeRegistries.ITEMS.getValue((ResourceLocation)drinkId)).m_41473_().f_38723_ = drinkData.overwritesDefaultHunger() ? drinkData.getHungerAmount() : DataMaps.Server.defaultFood.get(drinkId).m_38744_();
                            ((Item)ForgeRegistries.ITEMS.getValue((ResourceLocation)drinkId)).m_41473_().f_38724_ = drinkData.overwritesDefaultSaturation() ? drinkData.getSaturationAmount() : DataMaps.Server.defaultFood.get(drinkId).m_38745_();
                            Pair defaultEffect = null;
                            Pair itemEffect = null;
                            for (Pair effect : ((Item)ForgeRegistries.ITEMS.getValue(drinkId)).m_41473_().m_38749_()) {
                                if (((MobEffectInstance)effect.getFirst()).m_19544_() != MobEffects.f_19612_) continue;
                                itemEffect = effect;
                            }
                            for (Pair effect : DataMaps.Server.defaultFood.get(drinkId).m_38749_()) {
                                if (((MobEffectInstance)effect.getFirst()).m_19544_() != MobEffects.f_19612_) continue;
                                defaultEffect = effect;
                            }
                            if (itemEffect != null) {
                                ((Item)ForgeRegistries.ITEMS.getValue(drinkId)).m_41473_().m_38749_().remove(itemEffect);
                            }
                            if (drinkData.overwritesDefaultHungerChance()) {
                                ((Item)ForgeRegistries.ITEMS.getValue(drinkId)).m_41473_().m_38749_().add(Pair.of((Object)new MobEffectInstance(MobEffects.f_19612_, 600, 0), (Object)Float.valueOf(drinkData.getHungerChance())));
                            } else if (defaultEffect != null) {
                                ((Item)ForgeRegistries.ITEMS.getValue(drinkId)).m_41473_().m_38749_().add(defaultEffect);
                            }
                        }
                        if (drinkData.overwritesDefaultFood() && !((Item)ForgeRegistries.ITEMS.getValue(drinkId)).m_41472_()) {
                            ((Item)ForgeRegistries.ITEMS.getValue((ResourceLocation)drinkId)).f_41380_ = new FoodProperties.Builder().m_38760_(drinkData.getHungerAmount()).m_38758_(drinkData.getSaturationAmount()).effect(() -> new MobEffectInstance(MobEffects.f_19612_, 600, 0), drinkData.getHungerChance()).m_38767_();
                        }
                        if (!DataMaps.Server.defaultFood.containsKey(drinkId) && !drinkData.overwritesDefaultFood() && ((Item)ForgeRegistries.ITEMS.getValue(drinkId)).m_41472_()) {
                            ((Item)ForgeRegistries.ITEMS.getValue((ResourceLocation)drinkId)).f_41380_ = null;
                        }
                        Survive.getInstance().getLogger().info("Found item consummable data for " + drinkId);
                        drinkMap.put(drinkId, drinkData);
                    }
                    catch (Exception e) {
                        Survive.getInstance().getLogger().warn("Error reading item drink data " + drinkId + "!", (Throwable)e);
                    }
                    continue;
                }
                Survive.getInstance().getLogger().warn("No such item exists with the id " + drinkId + "!");
            }
            return drinkMap;
        });
    }

    public CompletableFuture<Void> apply(Map<ResourceLocation, FoodJsonHolder> data, ResourceManager manager, ProfilerFiller profiler, Executor executor) {
        return CompletableFuture.runAsync(() -> {
            for (ResourceLocation drinkId : data.keySet()) {
                Survive.registerDrinkDataForItem(drinkId, (FoodJsonHolder)data.get(drinkId));
            }
        });
    }

    public ResourceLocation id() {
        return new ResourceLocation("survive:item_data");
    }
}

