/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.stereowalker.survive.core.SurviveEntityStats;
import com.stereowalker.survive.needs.HygieneData;
import com.stereowalker.survive.needs.IRealisticEntity;
import com.stereowalker.survive.needs.SleepData;
import com.stereowalker.survive.needs.StaminaData;
import com.stereowalker.survive.needs.WaterData;
import com.stereowalker.survive.world.entity.ai.attributes.SAttributes;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.LivingEntity;

public class NeedsCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"needs").requires(p_137384_ -> p_137384_.m_6761_(2))).then(Commands.m_82127_((String)"restore").then(Commands.m_82129_((String)"amount", (ArgumentType)FloatArgumentType.floatArg((float)0.1f)).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82127_((String)"cleansing").executes(e -> NeedsCommand.restore((CommandSourceStack)e.getSource(), FloatArgumentType.getFloat((CommandContext)e, (String)"amount"), NeedType.CLEANSING, EntityArgument.m_91477_((CommandContext)e, (String)"targets"))))).then(Commands.m_82127_((String)"hunger").executes(e -> NeedsCommand.restore((CommandSourceStack)e.getSource(), FloatArgumentType.getFloat((CommandContext)e, (String)"amount"), NeedType.HUNGER, EntityArgument.m_91477_((CommandContext)e, (String)"targets"))))).then(Commands.m_82127_((String)"hydration").executes(e -> NeedsCommand.restore((CommandSourceStack)e.getSource(), FloatArgumentType.getFloat((CommandContext)e, (String)"amount"), NeedType.HYDRATION, EntityArgument.m_91477_((CommandContext)e, (String)"targets"))))).then(Commands.m_82127_((String)"saturation").executes(e -> NeedsCommand.restore((CommandSourceStack)e.getSource(), FloatArgumentType.getFloat((CommandContext)e, (String)"amount"), NeedType.SATURATION, EntityArgument.m_91477_((CommandContext)e, (String)"targets"))))).then(Commands.m_82127_((String)"sleep").executes(e -> NeedsCommand.restore((CommandSourceStack)e.getSource(), FloatArgumentType.getFloat((CommandContext)e, (String)"amount"), NeedType.SLEEP, EntityArgument.m_91477_((CommandContext)e, (String)"targets"))))).then(Commands.m_82127_((String)"stamina").executes(e -> NeedsCommand.restore((CommandSourceStack)e.getSource(), FloatArgumentType.getFloat((CommandContext)e, (String)"amount"), NeedType.STAMINA, EntityArgument.m_91477_((CommandContext)e, (String)"targets"))))).then(Commands.m_82127_((String)"thirst").executes(e -> NeedsCommand.restore((CommandSourceStack)e.getSource(), FloatArgumentType.getFloat((CommandContext)e, (String)"amount"), NeedType.THIRST, EntityArgument.m_91477_((CommandContext)e, (String)"targets")))))))).then(Commands.m_82127_((String)"deplete").then(Commands.m_82129_((String)"amount", (ArgumentType)FloatArgumentType.floatArg((float)0.1f)).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82127_((String)"cleansing").executes(e -> NeedsCommand.deplete((CommandSourceStack)e.getSource(), FloatArgumentType.getFloat((CommandContext)e, (String)"amount"), NeedType.CLEANSING, EntityArgument.m_91477_((CommandContext)e, (String)"targets"))))).then(Commands.m_82127_((String)"hunger").executes(e -> NeedsCommand.deplete((CommandSourceStack)e.getSource(), FloatArgumentType.getFloat((CommandContext)e, (String)"amount"), NeedType.HUNGER, EntityArgument.m_91477_((CommandContext)e, (String)"targets"))))).then(Commands.m_82127_((String)"hydration").executes(e -> NeedsCommand.deplete((CommandSourceStack)e.getSource(), FloatArgumentType.getFloat((CommandContext)e, (String)"amount"), NeedType.HYDRATION, EntityArgument.m_91477_((CommandContext)e, (String)"targets"))))).then(Commands.m_82127_((String)"saturation").executes(e -> NeedsCommand.deplete((CommandSourceStack)e.getSource(), FloatArgumentType.getFloat((CommandContext)e, (String)"amount"), NeedType.SATURATION, EntityArgument.m_91477_((CommandContext)e, (String)"targets"))))).then(Commands.m_82127_((String)"sleep").executes(e -> NeedsCommand.deplete((CommandSourceStack)e.getSource(), FloatArgumentType.getFloat((CommandContext)e, (String)"amount"), NeedType.SLEEP, EntityArgument.m_91477_((CommandContext)e, (String)"targets"))))).then(Commands.m_82127_((String)"stamina").executes(e -> NeedsCommand.deplete((CommandSourceStack)e.getSource(), FloatArgumentType.getFloat((CommandContext)e, (String)"amount"), NeedType.STAMINA, EntityArgument.m_91477_((CommandContext)e, (String)"targets"))))).then(Commands.m_82127_((String)"thirst").executes(e -> NeedsCommand.deplete((CommandSourceStack)e.getSource(), FloatArgumentType.getFloat((CommandContext)e, (String)"amount"), NeedType.THIRST, EntityArgument.m_91477_((CommandContext)e, (String)"targets")))))))).then(Commands.m_82127_((String)"query").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82127_((String)"cleansing").executes(e -> NeedsCommand.query((CommandSourceStack)e.getSource(), NeedType.CLEANSING, EntityArgument.m_91474_((CommandContext)e, (String)"targets"))))).then(Commands.m_82127_((String)"hunger").executes(e -> NeedsCommand.query((CommandSourceStack)e.getSource(), NeedType.HUNGER, EntityArgument.m_91474_((CommandContext)e, (String)"targets"))))).then(Commands.m_82127_((String)"hydration").executes(e -> NeedsCommand.query((CommandSourceStack)e.getSource(), NeedType.HYDRATION, EntityArgument.m_91474_((CommandContext)e, (String)"targets"))))).then(Commands.m_82127_((String)"saturation").executes(e -> NeedsCommand.query((CommandSourceStack)e.getSource(), NeedType.SATURATION, EntityArgument.m_91474_((CommandContext)e, (String)"targets"))))).then(Commands.m_82127_((String)"sleep").executes(e -> NeedsCommand.query((CommandSourceStack)e.getSource(), NeedType.SLEEP, EntityArgument.m_91474_((CommandContext)e, (String)"targets"))))).then(Commands.m_82127_((String)"stamina").executes(e -> NeedsCommand.query((CommandSourceStack)e.getSource(), NeedType.STAMINA, EntityArgument.m_91474_((CommandContext)e, (String)"targets"))))).then(Commands.m_82127_((String)"thirst").executes(e -> NeedsCommand.query((CommandSourceStack)e.getSource(), NeedType.THIRST, EntityArgument.m_91474_((CommandContext)e, (String)"targets")))))));
    }

    private static int restore(CommandSourceStack source, float amount, NeedType type, Collection<ServerPlayer> pTargets) throws CommandSyntaxException {
        for (ServerPlayer player : pTargets) {
            IRealisticEntity realisticPlayer = (IRealisticEntity)player;
            SleepData sleepData = SurviveEntityStats.getSleepStats((LivingEntity)player);
            WaterData waterData = realisticPlayer.getWaterData();
            StaminaData staminaData = SurviveEntityStats.getEnergyStats((LivingEntity)player);
            HygieneData hygieneData = SurviveEntityStats.getHygieneStats((LivingEntity)player);
            switch (type) {
                case STAMINA: {
                    staminaData.relax(Mth.m_14143_((float)amount), player.m_21133_(SAttributes.MAX_STAMINA));
                    break;
                }
                case HUNGER: {
                    player.m_36324_().m_38705_(Mth.m_14143_((float)amount));
                    break;
                }
                case SATURATION: {
                    player.m_36324_().m_38717_(amount);
                    break;
                }
                case CLEANSING: {
                    hygieneData.clean(Mth.m_14143_((float)amount), true);
                    break;
                }
                case SLEEP: {
                    sleepData.addAwakeTime(player, -Mth.m_14143_((float)amount));
                    break;
                }
                case THIRST: {
                    waterData.drink(Mth.m_14143_((float)amount), waterData.getHydrationLevel(), 0, false);
                    break;
                }
                case HYDRATION: {
                    waterData.drink(0, waterData.getHydrationLevel() + amount, 0, false);
                }
            }
            sleepData.save((LivingEntity)player);
            waterData.save((LivingEntity)player);
            hygieneData.save((LivingEntity)player);
            staminaData.save((LivingEntity)player);
        }
        if (pTargets.size() == 1) {
            source.m_288197_(() -> Component.m_237110_((String)("commands.needs.restore." + type.m_7912_() + ".success.single"), (Object[])new Object[]{Float.valueOf(amount), ((ServerPlayer)pTargets.iterator().next()).m_5446_()}), true);
        } else {
            source.m_288197_(() -> Component.m_237110_((String)("commands.needs.restore." + type.m_7912_() + ".success.multiple"), (Object[])new Object[]{Float.valueOf(amount), pTargets.size()}), true);
        }
        return pTargets.size();
    }

    private static int deplete(CommandSourceStack source, float amount, NeedType type, Collection<ServerPlayer> pTargets) throws CommandSyntaxException {
        for (ServerPlayer player : pTargets) {
            IRealisticEntity realisticPlayer = (IRealisticEntity)player;
            SleepData sleepData = SurviveEntityStats.getSleepStats((LivingEntity)player);
            WaterData waterData = realisticPlayer.getWaterData();
            StaminaData staminaData = SurviveEntityStats.getEnergyStats((LivingEntity)player);
            HygieneData hygieneData = SurviveEntityStats.getHygieneStats((LivingEntity)player);
            switch (type) {
                case STAMINA: {
                    staminaData.setEnergyLevel(staminaData.getEnergyLevel() - Mth.m_14143_((float)amount));
                    break;
                }
                case HUNGER: {
                    player.m_36324_().m_38705_(player.m_36324_().m_38702_() - Mth.m_14143_((float)amount));
                    break;
                }
                case SATURATION: {
                    player.m_36324_().m_38717_(player.m_36324_().m_38722_() - amount);
                    break;
                }
                case CLEANSING: {
                    hygieneData.dirty(Mth.m_14143_((float)amount));
                    break;
                }
                case SLEEP: {
                    sleepData.addAwakeTime(player, Mth.m_14143_((float)amount));
                    break;
                }
                case THIRST: {
                    waterData.setWaterLevel(waterData.getWaterLevel() - Mth.m_14143_((float)amount));
                    break;
                }
                case HYDRATION: {
                    waterData.setWaterHydrationLevel(waterData.getHydrationLevel() - amount);
                }
            }
            sleepData.save((LivingEntity)player);
            waterData.save((LivingEntity)player);
            hygieneData.save((LivingEntity)player);
            staminaData.save((LivingEntity)player);
        }
        if (pTargets.size() == 1) {
            source.m_288197_(() -> Component.m_237110_((String)("commands.needs.deplete." + type.m_7912_() + ".success.single"), (Object[])new Object[]{Float.valueOf(amount), ((ServerPlayer)pTargets.iterator().next()).m_5446_()}), true);
        } else {
            source.m_288197_(() -> Component.m_237110_((String)("commands.needs.deplete." + type.m_7912_() + ".success.multiple"), (Object[])new Object[]{Float.valueOf(amount), pTargets.size()}), true);
        }
        return pTargets.size();
    }

    private static int query(CommandSourceStack source, NeedType type, ServerPlayer pTarget) throws CommandSyntaxException {
        IRealisticEntity realisticPlayer = (IRealisticEntity)pTarget;
        float result = 0.0f;
        SleepData sleepData = SurviveEntityStats.getSleepStats((LivingEntity)pTarget);
        StaminaData staminaData = SurviveEntityStats.getEnergyStats((LivingEntity)pTarget);
        HygieneData hygieneData = SurviveEntityStats.getHygieneStats((LivingEntity)pTarget);
        switch (type) {
            case STAMINA: {
                result = staminaData.getEnergyLevel();
                break;
            }
            case HUNGER: {
                result = pTarget.m_36324_().m_38702_();
                break;
            }
            case SATURATION: {
                result = pTarget.m_36324_().m_38722_();
                break;
            }
            case CLEANSING: {
                result = hygieneData.getUncleanLevel();
                break;
            }
            case SLEEP: {
                result = sleepData.getAwakeTimer();
                break;
            }
            case THIRST: {
                result = realisticPlayer.getWaterData().getWaterLevel();
                break;
            }
            case HYDRATION: {
                result = realisticPlayer.getWaterData().getHydrationLevel();
            }
        }
        float r = result;
        source.m_288197_(() -> Component.m_237110_((String)("commands.needs.query." + type.m_7912_()), (Object[])new Object[]{pTarget.m_5446_(), Float.valueOf(r)}), true);
        return Mth.m_14143_((float)result);
    }

    static enum NeedType implements StringRepresentable
    {
        STAMINA("stamina"),
        HUNGER("hunger"),
        SATURATION("saturation"),
        CLEANSING("cleansing"),
        SLEEP("sleep"),
        THIRST("thirst"),
        HYDRATION("hydration");

        String name;

        private NeedType(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

