/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.world.item.crafting;

import com.stereowalker.survive.Survive;
import com.stereowalker.survive.world.item.CanteenItem;
import com.stereowalker.survive.world.item.SItems;
import com.stereowalker.survive.world.item.crafting.SRecipeSerializer;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class CanteenFillingRecipe
extends CustomRecipe {
    public CanteenFillingRecipe(ResourceLocation idIn, CraftingBookCategory pCategory) {
        super(idIn, pCategory);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean matches(CraftingContainer inv, Level worldIn) {
        Potion savedPotion = null;
        int bottles = 0;
        int canteens = 0;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41720_() == SItems.CANTEEN) {
                ++canteens;
            } else if (stack.m_41720_() == Items.f_42589_) {
                if (savedPotion == null) {
                    savedPotion = PotionUtils.m_43579_((ItemStack)stack);
                    ++bottles;
                } else {
                    if (!savedPotion.equals(PotionUtils.m_43579_((ItemStack)stack))) return false;
                    ++bottles;
                }
            } else if (!stack.m_41619_()) {
                return false;
            }
            if (bottles <= Survive.THIRST_CONFIG.canteen_fill_amount) continue;
            return false;
        }
        if (savedPotion == null) return false;
        if (bottles > Survive.THIRST_CONFIG.canteen_fill_amount) return false;
        if (canteens != 1) return false;
        return true;
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess ra) {
        int count = 0;
        Potion savedPotion = null;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41720_() != Items.f_42589_) continue;
            ++count;
            savedPotion = PotionUtils.m_43579_((ItemStack)stack);
        }
        if (savedPotion != null && count > 0) {
            return CanteenItem.addToCanteen(new ItemStack((ItemLike)SItems.FILLED_CANTEEN), count, savedPotion);
        }
        return ItemStack.f_41583_;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer pContainer) {
        NonNullList nonnulllist = NonNullList.m_122780_((int)pContainer.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack item = pContainer.m_8020_(i);
            if (item.hasCraftingRemainingItem()) {
                nonnulllist.set(i, (Object)item.getCraftingRemainingItem());
            }
            if (item.m_41720_() != Items.f_42589_) continue;
            nonnulllist.set(i, (Object)new ItemStack((ItemLike)Items.f_42590_));
        }
        return nonnulllist;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return SRecipeSerializer.CRAFTING_SPECIAL_CANTEEN_FILLING;
    }
}

