/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.world.level.block;

import com.stereowalker.survive.api.world.level.block.TemperatureEmitter;
import com.stereowalker.survive.world.item.SItems;
import com.stereowalker.survive.world.item.TemperatureRegulatorPlateItem;
import com.stereowalker.survive.world.level.block.AbstractTemperatureRegulatorBlock;
import com.stereowalker.survive.world.level.block.state.properties.SBlockStateProperties;
import com.stereowalker.survive.world.level.block.state.properties.TempRegulationPlateSize;
import com.stereowalker.survive.world.level.block.state.properties.TempRegulationPlateType;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;

public class PlatedTemperatureRegulatorBlock
extends AbstractTemperatureRegulatorBlock
implements TemperatureEmitter {
    public static final EnumProperty<TempRegulationPlateType> TEMP_REG_TYPE = SBlockStateProperties.TEMP_REG_TYPE;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;

    public PlatedTemperatureRegulatorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(TEMP_REG_TYPE, (Comparable)((Object)TempRegulationPlateType.HEATER))).m_61124_((Property)RADIATOR_SIZE, (Comparable)((Object)TempRegulationPlateSize.LARGE))).m_61124_((Property)PLATE_COUNT, (Comparable)Integer.valueOf(0))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_7820_().m_122424_())).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(PlatedTemperatureRegulatorBlock.hasPowerInEitherDirection(pContext.m_43725_(), pContext.m_8083_(), pContext.m_43719_())));
    }

    public void m_6861_(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        if (PlatedTemperatureRegulatorBlock.hasPowerInEitherDirection(pLevel, pPos, (Direction)pState.m_61143_((Property)FACING)) && !((Boolean)pState.m_61143_((Property)POWERED)).booleanValue()) {
            pLevel.m_46597_(pPos, (BlockState)pState.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true)));
        } else if (!PlatedTemperatureRegulatorBlock.hasPowerInEitherDirection(pLevel, pPos, (Direction)pState.m_61143_((Property)FACING)) && ((Boolean)pState.m_61143_((Property)POWERED)).booleanValue()) {
            pLevel.m_46597_(pPos, (BlockState)pState.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
        }
    }

    public List<ItemStack> m_49635_(BlockState pState, LootParams.Builder pBuilder) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.addAll(super.m_49635_(pState, pBuilder));
        for (int i = 0; i < (Integer)pState.m_61143_((Property)AbstractTemperatureRegulatorBlock.PLATE_COUNT); ++i) {
            drops.add(this.getPlateStack(pState));
        }
        return drops;
    }

    public static boolean hasPowerInEitherDirection(Level pLevel, BlockPos pPos, Direction pDirection) {
        return pLevel.m_276987_(pPos.m_121945_(pDirection), pDirection) || pLevel.m_276987_(pPos.m_121945_(pDirection.m_122424_()), pDirection.m_122424_());
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{TEMP_REG_TYPE, RADIATOR_SIZE, PLATE_COUNT, FACING, POWERED, WATERLOGGED});
    }

    @Override
    public boolean canAddPlate(BlockState pState, ItemStack plate) {
        TempRegulationPlateType newControl = null;
        TempRegulationPlateSize newSize = null;
        if (plate.m_41720_() instanceof TemperatureRegulatorPlateItem) {
            newControl = ((TemperatureRegulatorPlateItem)plate.m_41720_()).getType();
            newSize = ((TemperatureRegulatorPlateItem)plate.m_41720_()).getSize();
        }
        return pState.m_61143_(TEMP_REG_TYPE) == newControl && pState.m_61143_((Property)RADIATOR_SIZE) == newSize;
    }

    public static int getColor(BlockState pState) {
        if (pState.m_60734_() instanceof PlatedTemperatureRegulatorBlock) {
            if (((Boolean)pState.m_61143_((Property)POWERED)).booleanValue()) {
                switch ((TempRegulationPlateType)((Object)pState.m_61143_(TEMP_REG_TYPE))) {
                    case HEATER: {
                        return 12414271;
                    }
                    case CHILLER: {
                        return 8041171;
                    }
                }
            } else {
                return ((TempRegulationPlateType)((Object)pState.m_61143_(TEMP_REG_TYPE))).getColor();
            }
        }
        return 0xFFFFFF;
    }

    @Override
    public boolean canRemovePlates(BlockState pState) {
        return true;
    }

    @Override
    public ItemStack getPlateStack(BlockState pState) {
        if (pState.m_61143_((Property)RADIATOR_SIZE) == TempRegulationPlateSize.LARGE && pState.m_61143_(TEMP_REG_TYPE) == TempRegulationPlateType.HEATER) {
            return new ItemStack((ItemLike)SItems.LARGE_HEATING_PLATE);
        }
        if (pState.m_61143_((Property)RADIATOR_SIZE) == TempRegulationPlateSize.LARGE && pState.m_61143_(TEMP_REG_TYPE) == TempRegulationPlateType.CHILLER) {
            return new ItemStack((ItemLike)SItems.LARGE_COOLING_PLATE);
        }
        if (pState.m_61143_((Property)RADIATOR_SIZE) == TempRegulationPlateSize.MEDIUM && pState.m_61143_(TEMP_REG_TYPE) == TempRegulationPlateType.HEATER) {
            return new ItemStack((ItemLike)SItems.MEDIUM_HEATING_PLATE);
        }
        if (pState.m_61143_((Property)RADIATOR_SIZE) == TempRegulationPlateSize.MEDIUM && pState.m_61143_(TEMP_REG_TYPE) == TempRegulationPlateType.CHILLER) {
            return new ItemStack((ItemLike)SItems.MEDIUM_COOLING_PLATE);
        }
        if (pState.m_61143_((Property)RADIATOR_SIZE) == TempRegulationPlateSize.SMALL && pState.m_61143_(TEMP_REG_TYPE) == TempRegulationPlateType.HEATER) {
            return new ItemStack((ItemLike)SItems.SMALL_HEATING_PLATE);
        }
        if (pState.m_61143_((Property)RADIATOR_SIZE) == TempRegulationPlateSize.SMALL && pState.m_61143_(TEMP_REG_TYPE) == TempRegulationPlateType.CHILLER) {
            return new ItemStack((ItemLike)SItems.SMALL_COOLING_PLATE);
        }
        return ItemStack.f_41583_;
    }

    @Override
    public float getTemperatureModification(BlockState pState) {
        if (((Boolean)pState.m_61143_((Property)POWERED)).booleanValue()) {
            float blockTemp = (float)((Integer)pState.m_61143_((Property)AbstractTemperatureRegulatorBlock.PLATE_COUNT)).intValue() * ((TempRegulationPlateSize)((Object)pState.m_61143_(AbstractTemperatureRegulatorBlock.RADIATOR_SIZE))).getModifier();
            switch ((TempRegulationPlateType)((Object)pState.m_61143_(TEMP_REG_TYPE))) {
                case CHILLER: {
                    blockTemp *= -1.0f;
                    break;
                }
                case HEATER: {
                    blockTemp *= 1.0f;
                    break;
                }
                default: {
                    blockTemp *= 0.0f;
                }
            }
            return blockTemp;
        }
        return 0.0f;
    }

    @Override
    public float getModificationRange(BlockState pState) {
        return ((TempRegulationPlateSize)((Object)pState.m_61143_(AbstractTemperatureRegulatorBlock.RADIATOR_SIZE))).getRange();
    }
}

