/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.world.level.material;

import com.stereowalker.survive.Survive;
import com.stereowalker.survive.world.item.SItems;
import com.stereowalker.survive.world.level.block.SBlocks;
import com.stereowalker.survive.world.level.material.SFluids;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.fluids.FluidType;

public abstract class PurifiedWaterFluid
extends FlowingFluid {
    public static final FluidType TYPE = new FluidType(FluidType.Properties.create().descriptionId("block.survive.purified_water").fallDistanceModifier(0.0f).canExtinguish(true).canConvertToSource(true).supportsBoating(true).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11781_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11778_).sound(SoundActions.FLUID_VAPORIZE, SoundEvents.f_11937_).canHydrate(true).density(10).viscosity(10)){

        @Nullable
        public BlockPathTypes getBlockPathType(FluidState state, BlockGetter level, BlockPos pos, @Nullable Mob mob, boolean canFluidLog) {
            return canFluidLog ? super.getBlockPathType(state, level, pos, mob, true) : null;
        }

        public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
            consumer.accept(new IClientFluidTypeExtensions(){
                private static final ResourceLocation UNDERWATER_LOCATION = new ResourceLocation("textures/misc/underwater.png");

                public ResourceLocation getStillTexture() {
                    return Survive.getInstance().location("block/purified_water_still");
                }

                public ResourceLocation getFlowingTexture() {
                    return Survive.getInstance().location("block/purified_water_flow");
                }

                @Nullable
                public ResourceLocation getOverlayTexture() {
                    return Survive.getInstance().location("block/purified_water_overlay");
                }

                public ResourceLocation getRenderOverlayTexture(Minecraft mc) {
                    return UNDERWATER_LOCATION;
                }

                public int getTintColor() {
                    return -8303908;
                }

                public int getTintColor(FluidState state, BlockAndTintGetter getter, BlockPos pos) {
                    return BiomeColors.m_108811_((BlockAndTintGetter)getter, (BlockPos)pos) | 0xFF41D3F8;
                }
            });
        }
    };

    public Fluid m_5615_() {
        return SFluids.FLOWING_PURIFIED_WATER;
    }

    public Fluid m_5613_() {
        return SFluids.PURIFIED_WATER;
    }

    public Item m_6859_() {
        return SItems.PURIFIED_WATER_BUCKET;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_213811_(Level worldIn, BlockPos pos, FluidState state, RandomSource pRandom) {
        if (!state.m_76170_() && !((Boolean)state.m_61143_((Property)f_75947_)).booleanValue()) {
            if (pRandom.m_188503_(64) == 0) {
                worldIn.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_12540_, SoundSource.BLOCKS, pRandom.m_188501_() * 0.25f + 0.75f, pRandom.m_188501_() + 0.5f, false);
            }
        } else if (pRandom.m_188503_(10) == 0) {
            worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123768_, (double)pos.m_123341_() + pRandom.m_188500_(), (double)pos.m_123342_() + pRandom.m_188500_(), (double)pos.m_123343_() + pRandom.m_188500_(), 0.0, 0.0, 0.0);
        }
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public ParticleOptions m_7792_() {
        return ParticleTypes.f_123803_;
    }

    protected boolean m_6760_(Level level) {
        return level.m_46469_().m_46207_(GameRules.f_254725_);
    }

    protected void m_7456_(LevelAccessor worldIn, BlockPos pos, BlockState state) {
        BlockEntity tileentity = state.m_155947_() ? worldIn.m_7702_(pos) : null;
        Block.m_49892_((BlockState)state, (LevelAccessor)worldIn, (BlockPos)pos, (BlockEntity)tileentity);
    }

    public int m_6719_(LevelReader worldIn) {
        return 4;
    }

    public FluidType getFluidType() {
        return TYPE;
    }

    public BlockState m_5804_(FluidState state) {
        return (BlockState)SBlocks.PURIFIED_WATER.m_49966_().m_61124_((Property)LiquidBlock.f_54688_, (Comparable)Integer.valueOf(PurifiedWaterFluid.m_76092_((FluidState)state)));
    }

    public boolean m_6212_(Fluid fluidIn) {
        return fluidIn == SFluids.PURIFIED_WATER || fluidIn == SFluids.FLOWING_PURIFIED_WATER;
    }

    public int m_6713_(LevelReader worldIn) {
        return 1;
    }

    public int m_6718_(LevelReader p_205569_1_) {
        return 5;
    }

    public boolean m_5486_(FluidState fluidState, BlockGetter blockReader, BlockPos pos, Fluid fluid, Direction direction) {
        return direction == Direction.DOWN && !fluid.m_205067_(FluidTags.f_13131_);
    }

    protected float m_6752_() {
        return 100.0f;
    }

    public static class Source
    extends PurifiedWaterFluid {
        public int m_7430_(FluidState p_207192_1_) {
            return 8;
        }

        public boolean m_7444_(FluidState state) {
            return true;
        }
    }

    public static class Flowing
    extends PurifiedWaterFluid {
        protected void m_7180_(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.m_7180_(builder);
            builder.m_61104_(new Property[]{f_75948_});
        }

        public int m_7430_(FluidState p_207192_1_) {
            return (Integer)p_207192_1_.m_61143_((Property)f_75948_);
        }

        public boolean m_7444_(FluidState state) {
            return false;
        }
    }
}

