/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.world.seasons;

import com.stereowalker.survive.Survive;
import com.stereowalker.survive.world.seasons.Season;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.RegisterEvent;

public class Seasons {
    public static final Map<ResourceLocation, Season> SEASON_LIST = new HashMap<ResourceLocation, Season>();
    public static final Season NONE = Seasons.register("none", new Season(0.0f));
    public static final Season DRY_BEGIN = Seasons.register("dry_begin", new Season(0.1f));
    public static final Season DRY_MIDST = Seasons.register("dry_midst", new Season(0.2f));
    public static final Season DRY_CLOSE = Seasons.register("dry_close", new Season(0.1f));
    public static final Season WET_BEGIN = Seasons.register("wet_begin", new Season(-0.1f));
    public static final Season WET_MIDST = Seasons.register("wet_midst", new Season(-0.2f));
    public static final Season WET_CLOSE = Seasons.register("wet_close", new Season(-0.1f));
    public static final Season WINTER_BEGIN = Seasons.register("winter_begin", new Season(-0.6f));
    public static final Season WINTER_MIDST = Seasons.register("winter_midst", new Season(-0.9f));
    public static final Season WINTER_CLOSE = Seasons.register("winter_close", new Season(-0.6f));
    public static final Season SPRING_BEGIN = Seasons.register("spring_begin", new Season(-0.3f));
    public static final Season SPRING_MIDST = Seasons.register("spring_midst", new Season(0.0f));
    public static final Season SPRING_CLOSE = Seasons.register("spring_close", new Season(0.3f));
    public static final Season SUMMER_BEGIN = Seasons.register("summer_begin", new Season(0.6f));
    public static final Season SUMMER_MIDST = Seasons.register("summer_midst", new Season(0.9f));
    public static final Season SUMMER_CLOSE = Seasons.register("summer_close", new Season(0.6f));
    public static final Season AUTUMN_BEGIN = Seasons.register("autumn_begin", new Season(0.3f));
    public static final Season AUTUMN_MIDST = Seasons.register("autumn_midst", new Season(0.0f));
    public static final Season AUTUMN_CLOSE = Seasons.register("autumn_close", new Season(-0.3f));

    public static Season register(String name, Season season) {
        SEASON_LIST.put(Survive.getInstance().location(name), season);
        return season;
    }

    public static void registerAll(RegisterEvent.RegisterHelper<Season> registry) {
        for (Map.Entry<ResourceLocation, Season> season : SEASON_LIST.entrySet()) {
            registry.register(season.getKey(), (Object)season.getValue());
            Survive.getInstance().debug("Season: \"" + season.getKey().toString() + "\" registered");
        }
        Survive.getInstance().debug("All Seasons Registered");
    }
}

