/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.world.temperature;

import com.stereowalker.unionlib.util.math.UnionMathHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;

public class TemperatureModifier {
    private ResourceLocation id;
    private double mod;
    private ContributingFactor factor;

    public TemperatureModifier() {
    }

    public TemperatureModifier(ResourceLocation id, double mod) {
        this.id = id;
        this.mod = mod;
        this.factor = ContributingFactor.INTERNAL;
    }

    public TemperatureModifier(ResourceLocation id, double mod, ContributingFactor factor) {
        this.id = id;
        this.mod = mod;
        this.factor = factor;
    }

    public double getMod() {
        return this.mod;
    }

    public ContributingFactor getFactor() {
        return this.factor;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public CompoundTag write(CompoundTag nbt) {
        nbt.m_128359_("id", this.id.toString());
        nbt.m_128347_("mod", this.mod);
        nbt.m_128405_("factor", this.factor.ordinal());
        return nbt;
    }

    public void read(CompoundTag nbt) {
        this.id = new ResourceLocation(nbt.m_128461_("id"));
        this.mod = nbt.m_128459_("mod");
        this.factor = nbt.m_128451_("factor") >= ContributingFactor.values().length ? ContributingFactor.INTERNAL : ContributingFactor.values()[nbt.m_128451_("factor")];
    }

    public TemperatureModifier setMod(double mod) {
        this.mod = UnionMathHelper.roundDecimal((int)3, (double)mod);
        return this;
    }

    public TemperatureModifier setFactor(ContributingFactor factor) {
        this.factor = factor;
        return this;
    }

    public String toString() {
        return "{id: " + this.id + ", modifier: " + this.mod + ", contributing factor: " + this.factor + "}";
    }

    public static enum ContributingFactor {
        ENVIRONMENTAL,
        INTERNAL;

    }
}

