/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.world.temperature.conditions;

import com.stereowalker.survive.Survive;
import com.stereowalker.survive.world.temperature.conditions.BiomeCondition;
import com.stereowalker.survive.world.temperature.conditions.BiomeNotCondition;
import com.stereowalker.survive.world.temperature.conditions.DefaultCondition;
import com.stereowalker.survive.world.temperature.conditions.OnFireCondition;
import com.stereowalker.survive.world.temperature.conditions.TemperatureChangeCondition;
import com.stereowalker.survive.world.temperature.conditions.UnderwaterCondition;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.RegisterEvent;

public class TemperatureChangeConditions {
    public static final Map<ResourceLocation, TemperatureChangeCondition<?>> CONDITION_LIST = new HashMap();
    public static final TemperatureChangeCondition<?> DEFAULT = TemperatureChangeConditions.register("default", new DefaultCondition());
    public static final TemperatureChangeCondition<?> UNDERWATER = TemperatureChangeConditions.register("underwater", new UnderwaterCondition());
    public static final TemperatureChangeCondition<?> ON_FIRE = TemperatureChangeConditions.register("on_fire", new OnFireCondition());
    public static final TemperatureChangeCondition<?> BIOME = TemperatureChangeConditions.register("biome", new BiomeCondition());
    public static final TemperatureChangeCondition<?> NOT_BIOME = TemperatureChangeConditions.register("not_biome", new BiomeNotCondition());

    public static TemperatureChangeCondition<?> register(String name, TemperatureChangeCondition<?> condition) {
        CONDITION_LIST.put(Survive.getInstance().location(name), condition);
        return condition;
    }

    public static void registerAll(RegisterEvent.RegisterHelper<TemperatureChangeCondition<?>> registry) {
        for (Map.Entry<ResourceLocation, TemperatureChangeCondition<?>> condition : CONDITION_LIST.entrySet()) {
            registry.register(condition.getKey(), condition.getValue());
            Survive.getInstance().debug("Condition: \"" + condition.getKey().toString() + "\" registered");
        }
        Survive.getInstance().debug("All Conditions Registered");
    }
}

