/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.world.temperature.conditions;

import com.google.gson.JsonObject;
import com.stereowalker.survive.world.temperature.conditions.TemperatureChangeCondition;
import com.stereowalker.survive.world.temperature.conditions.TemperatureChangeInstance;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class UnderwaterCondition
extends TemperatureChangeCondition<Instance> {
    @Override
    public Instance createInstance(JsonObject object) {
        float temperatureIn = 0.0f;
        int depthIn = 0;
        String operationIn = "";
        if (object.has("temperature") && object.get("temperature").isJsonPrimitive()) {
            temperatureIn = object.get("temperature").getAsFloat();
        }
        if (object.has("depth") && object.get("depth").isJsonPrimitive()) {
            depthIn = object.get("depth").getAsInt();
        }
        if (object.has("operation") && object.get("operation").isJsonPrimitive()) {
            operationIn = object.get("operation").getAsString();
        }
        return new Instance(temperatureIn, depthIn, operationIn);
    }

    @Override
    public Instance createInstance(CompoundTag nbt) {
        float temperatureIn = nbt.m_128457_("temperature");
        int depthIn = nbt.m_128451_("depth");
        String operationIn = nbt.m_128461_("operation");
        return new Instance(temperatureIn, depthIn, operationIn);
    }

    static class Instance
    extends TemperatureChangeInstance {
        private int depth;
        private String operation;

        public Instance(float temperatureIn, int depthIn, String operationIn) {
            super(temperatureIn);
            this.depth = depthIn;
            this.operation = operationIn;
        }

        @Override
        public boolean shouldChangeTemperature(Player player) {
            boolean flag = true;
            int i = 0;
            while (flag) {
                if (player.m_9236_().m_6425_(player.m_20183_().m_6630_(i)).m_205070_(FluidTags.f_13131_)) {
                    ++i;
                    continue;
                }
                flag = false;
            }
            if (player.m_20069_()) {
                if (this.depth > 0) {
                    if (this.operation.equals("y_=")) {
                        return player.m_20186_() == (double)this.depth;
                    }
                    if (this.operation.equals("y_>=")) {
                        return player.m_20186_() >= (double)this.depth;
                    }
                    if (this.operation.equals("y_<=")) {
                        return player.m_20186_() <= (double)this.depth;
                    }
                    if (this.operation.equals("y_>")) {
                        return player.m_20186_() > (double)this.depth;
                    }
                    if (this.operation.equals("y_<")) {
                        return player.m_20186_() < (double)this.depth;
                    }
                    if (this.operation.equals("water_=")) {
                        return i == this.depth;
                    }
                    if (this.operation.equals("water_>=")) {
                        return i >= this.depth;
                    }
                    if (this.operation.equals("water_<=")) {
                        return i <= this.depth;
                    }
                    if (this.operation.equals("water_>")) {
                        return i > this.depth;
                    }
                    if (this.operation.equals("water_<")) {
                        return i < this.depth;
                    }
                    return i <= this.depth;
                }
                return true;
            }
            return false;
        }

        @Override
        public CompoundTag serialize() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128350_("temperature", this.getTemperature());
            nbt.m_128405_("depth", this.depth);
            nbt.m_128359_("operation", this.operation);
            return nbt;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public Component getAdditionalContext() {
            return Component.m_237115_((String)"temperature_context.underwater");
        }
    }
}

