/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.common.base.Preconditions;
import com.mojang.serialization.Codec;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Base64;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.MessageSignatureCache;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.SignatureUpdater;
import net.minecraft.util.SignatureValidator;

public record MessageSignature(byte[] f_240884_) {
    public static final Codec<MessageSignature> f_252463_ = ExtraCodecs.f_216160_.xmap(MessageSignature::new, MessageSignature::f_240884_);
    public static final int f_244417_ = 256;

    public MessageSignature {
        Preconditions.checkState((f_240884_.length == 256 ? 1 : 0) != 0, (Object)"Invalid message signature size");
    }

    public static MessageSignature m_245099_(FriendlyByteBuf p_249837_) {
        byte[] $$1 = new byte[256];
        p_249837_.readBytes($$1);
        return new MessageSignature($$1);
    }

    public static void m_246050_(FriendlyByteBuf p_250642_, MessageSignature p_249714_) {
        p_250642_.writeBytes(p_249714_.f_240884_);
    }

    public boolean m_245457_(SignatureValidator p_250998_, SignatureUpdater p_249843_) {
        return p_250998_.m_216378_(p_249843_, this.f_240884_);
    }

    public ByteBuffer m_241929_() {
        return ByteBuffer.wrap(this.f_240884_);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object p_237166_) {
        if (this == p_237166_) return true;
        if (!(p_237166_ instanceof MessageSignature)) return false;
        MessageSignature $$1 = (MessageSignature)p_237166_;
        if (!Arrays.equals(this.f_240884_, $$1.f_240884_)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.f_240884_);
    }

    @Override
    public String toString() {
        return Base64.getEncoder().encodeToString(this.f_240884_);
    }

    public Packed m_252849_(MessageSignatureCache p_253845_) {
        int $$1 = p_253845_.m_252764_(this);
        return $$1 != -1 ? new Packed($$1) : new Packed(this);
    }

    public record Packed(int f_244111_, @Nullable MessageSignature f_244020_) {
        public static final int f_244178_ = -1;

        public Packed(MessageSignature p_249705_) {
            this(-1, p_249705_);
        }

        public Packed(int p_250015_) {
            this(p_250015_, null);
        }

        public static Packed m_246521_(FriendlyByteBuf p_250810_) {
            int $$1 = p_250810_.m_130242_() - 1;
            if ($$1 == -1) {
                return new Packed(MessageSignature.m_245099_(p_250810_));
            }
            return new Packed($$1);
        }

        public static void m_246314_(FriendlyByteBuf p_251691_, Packed p_252193_) {
            p_251691_.m_130130_(p_252193_.f_244111_() + 1);
            if (p_252193_.f_244020_() != null) {
                MessageSignature.m_246050_(p_251691_, p_252193_.f_244020_());
            }
        }

        public Optional<MessageSignature> m_253223_(MessageSignatureCache p_254423_) {
            if (this.f_244020_ != null) {
                return Optional.of(this.f_244020_);
            }
            return Optional.ofNullable(p_254423_.m_252914_(this.f_244111_));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Packed.class, "id;fullSignature", "f_244111_", "f_244020_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Packed.class, "id;fullSignature", "f_244111_", "f_244020_"}, this);
        }

        @Override
        public final boolean equals(Object p_249581_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Packed.class, "id;fullSignature", "f_244111_", "f_244020_"}, this, p_249581_);
        }
    }
}

