/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.api.event;

import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;

public final class EntityFitnessEvents {
    public static final Event<StartRunning> START_RUNNING = EventFactory.createArrayBacked(StartRunning.class, callbacks -> (entity, energyStorage) -> {
        for (StartRunning callback : callbacks) {
            callback.onStartRunning(entity, energyStorage);
        }
    });
    public static final Event<StopRunning> STOP_RUNNING = EventFactory.createArrayBacked(StopRunning.class, callbacks -> (entity, energyStorage) -> {
        for (StopRunning callback : callbacks) {
            callback.onStopRunning(entity, energyStorage);
        }
    });
    public static final Event<ModifyOutputEnergyQuantity> MODIFY_OUTPUT_ENERGY_QUANTITY = EventFactory.createArrayBacked(ModifyOutputEnergyQuantity.class, callbacks -> (entity, energyStorage, outputEnergyQuantity) -> {
        for (ModifyOutputEnergyQuantity callback : callbacks) {
            outputEnergyQuantity = callback.modifyOutputEnergyQuantity(entity, energyStorage, outputEnergyQuantity);
        }
        return outputEnergyQuantity;
    });

    private EntityFitnessEvents() {
    }

    @FunctionalInterface
    public static interface ModifyOutputEnergyQuantity {
        @Nullable
        public Long modifyOutputEnergyQuantity(Entity var1, EnergyStorage var2, @Nullable Long var3);
    }

    @FunctionalInterface
    public static interface StopRunning {
        public void onStopRunning(Entity var1, EnergyStorage var2);
    }

    @FunctionalInterface
    public static interface StartRunning {
        public void onStartRunning(Entity var1, EnergyStorage var2);
    }
}

