/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.api.networking;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.kir.sync.api.networking.PlayerPacket;
import dev.kir.sync.util.client.PlayerUtil;
import dev.kir.sync.util.reflect.Activator;
import dev.kir.sync.util.reflect.ClassUtil;
import java.util.Collection;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.Nullable;

public interface ClientPlayerPacket
extends PlayerPacket {
    default public void sendToAll(MinecraftServer server) {
        this.send(PlayerLookup.all((MinecraftServer)server));
    }

    default public void send(ServerPlayer player) {
        this.send(Stream.of(player));
    }

    default public void send(Collection<ServerPlayer> players) {
        this.send(players.stream());
    }

    default public void send(Stream<ServerPlayer> players) {
        ResourceLocation id = this.getId();
        FriendlyByteBuf buffer = PacketByteBufs.create();
        this.write(buffer);
        players.forEach(player -> ServerPlayNetworking.send((ServerPlayer)player, (ResourceLocation)id, (FriendlyByteBuf)buffer));
    }

    default public boolean isRenderTask() {
        return false;
    }

    @Nullable
    default public ResourceLocation getTargetWorldId() {
        return null;
    }

    @Environment(value=EnvType.CLIENT)
    default public void execute(Minecraft client, ClientPacketListener handler, PacketSender responseSender) {
        PlayerUtil.recordPlayerUpdate(this.getTargetWorldId(), (player, w, c) -> {
            if (this.isBackgroundTask()) {
                this.execute(client, player, handler, responseSender);
            } else if (this.isRenderTask()) {
                RenderSystem.recordRenderCall(() -> this.execute(client, player, handler, responseSender));
            } else {
                client.execute(() -> this.execute(client, player, handler, responseSender));
            }
        });
    }

    @Environment(value=EnvType.CLIENT)
    default public void execute(Minecraft client, LocalPlayer player, ClientPacketListener handler, PacketSender responseSender) {
    }

    @Environment(value=EnvType.CLIENT)
    public static <T extends ClientPlayerPacket> void register(Class<T> type) {
        Supplier supplier = Activator.createSupplier(type).orElseThrow();
        ClientPlayerPacket packet = (ClientPlayerPacket)supplier.get();
        boolean originalExecute = ClassUtil.getMethod(type, "execute", Minecraft.class, ClientPacketListener.class, PacketSender.class).map(x -> "ClientPlayerPacket".equals(x.getDeclaringClass().getName())).orElse(false);
        ClientPlayNetworking.registerGlobalReceiver((ResourceLocation)packet.getId(), (client, handler, buffer, responseSender) -> {
            ClientPlayerPacket localPacket = (ClientPlayerPacket)supplier.get();
            localPacket.read(buffer);
            if (originalExecute || localPacket.isBackgroundTask()) {
                localPacket.execute(client, handler, responseSender);
            } else if (localPacket.isRenderTask()) {
                RenderSystem.recordRenderCall(() -> localPacket.execute(client, handler, responseSender));
            } else {
                client.execute(() -> localPacket.execute(client, handler, responseSender));
            }
        });
    }
}

