/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.api.networking;

import dev.kir.sync.api.networking.PlayerPacket;
import dev.kir.sync.util.reflect.Activator;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;

public interface ServerPlayerPacket
extends PlayerPacket {
    @Environment(value=EnvType.CLIENT)
    default public void send() {
        ResourceLocation id = this.getId();
        FriendlyByteBuf buffer = PacketByteBufs.create();
        this.write(buffer);
        ClientPlayNetworking.send((ResourceLocation)id, (FriendlyByteBuf)buffer);
    }

    public void execute(MinecraftServer var1, ServerPlayer var2, ServerGamePacketListenerImpl var3, PacketSender var4);

    public static <T extends ServerPlayerPacket> void register(Class<T> type) {
        Supplier supplier = Activator.createSupplier(type).orElseThrow();
        ServerPlayerPacket packet = (ServerPlayerPacket)supplier.get();
        ServerPlayNetworking.registerGlobalReceiver((ResourceLocation)packet.getId(), (server, player, handler, buffer, responseSender) -> {
            ServerPlayerPacket localPacket = (ServerPlayerPacket)supplier.get();
            localPacket.read(buffer);
            if (localPacket.isBackgroundTask()) {
                localPacket.execute(server, player, handler, responseSender);
            } else {
                server.execute(() -> localPacket.execute(server, player, handler, responseSender));
            }
        });
    }
}

